package de.tobias.playpad;

public class Waveform {

	public static native void initialize();
	
	public static native void createWaveform(String path);

	private static WaveformDelegate delegate;

	private static void sampleProcessed(float[] data) {
		if (delegate != null) {
			delegate.sampleProcessed(data);
		}
	}

	public static void setDelegate(WaveformDelegate delegate) {
		Waveform.delegate = delegate;
	}

	public interface WaveformDelegate {

		public void sampleProcessed(float[] data);

	}
}
