package de.tobias.playpad.view;

import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;

public class WaveformView extends Path {

	public WaveformView(float[] data) {
		getElements().add(new MoveTo(0, 0));

		for (int i = 0; i < data.length; i++) {
			LineTo lineTo = new LineTo(i, data[i] * 50.0);
			MoveTo moveTo = new MoveTo(i, data[i] * 50.0);

			getElements().addAll(lineTo, moveTo);
		}
		for (int i = data.length - 1; i >= 0; i--) {
			LineTo lineTo = new LineTo(i, -data[i] * 50.0);
			MoveTo moveTo = new MoveTo(i, -data[i] * 50.0);

			getElements().addAll(lineTo, moveTo);
		}
		getElements().add(new LineTo(0, 0));
		getElements().add(new MoveTo(0, 0));
		setScaleX(0.5);

	}
}
