package de.tobias.playwall.service;

import de.tobias.playwall.model.Plugin;
import de.tobias.playwall.model.PluginDescription;
import de.tobias.playwall.model.PluginManifest;
import de.tobias.playwall.model.artifactory.Version;
import de.tobias.playwall.repository.PluginDescriptionRepository;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

@Service
@AllArgsConstructor
public class PluginService
{
	private final PluginDescriptionRepository pluginDescriptionRepository;
	private final ArtifactoryClient artifactoryClient;

	public List<Plugin> getAllPlugins()
	{
		return pluginDescriptionRepository.findAll().stream().map(this::collectPluginInformation).toList();
	}

	public Optional<Plugin> getPlugin(Integer id)
	{
		return pluginDescriptionRepository.findById(id).map(this::collectPluginInformation);
	}

	private Plugin collectPluginInformation(PluginDescription pluginDescription)
	{
		final Version version = artifactoryClient.getLatestVersion(pluginDescription);
		final PluginManifest manifest = artifactoryClient.getPluginManifest(pluginDescription, version);

		return Plugin.builder()
				.id(pluginDescription.getId())
				.name(pluginDescription.getName())
				.displayName(pluginDescription.getDisplayName())
				.description(pluginDescription.getDescription())
				.icon(pluginDescription.getIcon())
				.version(version.toVersionString())
				.build(manifest.getBuild())
				.build();
	}
}
