package de.tobias.playwall.infrastructure;

import lombok.AllArgsConstructor;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClient;

import static org.springframework.web.reactive.function.client.ExchangeFilterFunctions.basicAuthentication;

@Component
@AllArgsConstructor
public class ArtifactoryWebClientBean
{
	private final ArtifactoryConfigurationProperties configurationProperties;

	@Bean
	WebClient artifactoryWebClient()
	{
		return WebClient.builder()
				.filter(basicAuthentication(configurationProperties.getUsername(), configurationProperties.getPassword()))
				.baseUrl(configurationProperties.getBaseUrl())
				.build();
	}
}
