package de.tobias.playwall.model.artifactory;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

@Data
public class Folder
{
	public static final String ISO_DATE_TIME = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";

	@Data
	public static class FolderItem {
		private String uri;
		private boolean folder;
	}

	private String uri;
	private String repo;
	private String path;
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = ISO_DATE_TIME)
	private LocalDateTime created;
	private String createdBy;
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = ISO_DATE_TIME)
	private LocalDateTime lastModified;
	private String modifiedBy;
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = ISO_DATE_TIME)
	private LocalDateTime lastUpdated;
	private List<FolderItem> children;
}
