package de.tobias.playwall.repository;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import de.tobias.playwall.model.PluginDescription;
import jakarta.annotation.PostConstruct;
import lombok.SneakyThrows;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

import java.nio.charset.StandardCharsets;
import java.util.List;

@Service
@EnableConfigurationProperties
public class PluginDescriptionRepository
{
	@Value("${playwall.plugin.description}")
	private Resource pluginDescriptionFile;

	private ObjectMapper mapper;

	@PostConstruct
	private void init()
	{
		mapper = new ObjectMapper(new YAMLFactory());
		mapper.findAndRegisterModules();
	}

	@SneakyThrows
	public List<PluginDescription> findAll()
	{
		return mapper.readValue(pluginDescriptionFile.getContentAsString(StandardCharsets.UTF_8), new TypeReference<List<PluginDescription>>()
		{
		});
	}
}
