package de.tobias.playwall.service;

import de.tobias.playwall.model.Plugin;
import de.tobias.playwall.model.PluginManifest;
import de.tobias.playwall.model.artifactory.Version;
import de.tobias.playwall.repository.PluginDescriptionRepository;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@AllArgsConstructor
public class PluginService
{
	private final PluginDescriptionRepository pluginDescriptionRepository;
	private final ArtifactoryClient artifactoryClient;

	public List<Plugin> getAllPlugins()
	{
		return pluginDescriptionRepository.findAll().stream().map(pluginDescription -> {
			final Version version = artifactoryClient.getLatestVersion(pluginDescription);
			final PluginManifest manifest = artifactoryClient.getPluginManifest(pluginDescription, version);

			return Plugin.builder()
					.id(pluginDescription.getId())
					.name(pluginDescription.getName())
					.displayName(pluginDescription.getDisplayName())
					.description(pluginDescription.getDescription())
					.icon(pluginDescription.getIcon())
					.version(version.toVersionString())
					.build(manifest.getBuild())
					.build();
		}).toList();
	}
}
