from typing import List

from pydantic import BaseModel


class Status(BaseModel):
    message: str


# ===== measurement =====
class Measurement(BaseModel):
    id: int
    value: str
    timestamp: str
    sensorId: int

    class Config:
        orm_mode = True


class MeasurementCreate(BaseModel):
    value: str
    sensorId: int


# ===== sensor =====
class SensorBase(BaseModel):
    id: int
    name: str
    type: str

    class Config:
        orm_mode = True


class SensorCreate(BaseModel):
    name: str
    type: str
    deviceId: int


class Sensor(SensorBase):
    id: int
    name: str
    type: str
    deviceId: int

    class Config:
        orm_mode = True


# ===== device =====
class Device(BaseModel):
    id: int
    name: str
    sensors: List[SensorBase]

    class Config:
        orm_mode = True


class DeviceCreate(BaseModel):
    name: str
