/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.Worker;
import fontAwesome.FontIcon;
import fontAwesome.FontIconType;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;

public class Controller {
    @FXML
    AnchorPane anchorPaneMain;
    @FXML
    Label labelAppName;
    @FXML
    ProgressIndicator progressIndicator;
    @FXML
    ImageView imageView;
    @FXML
    Button buttonClose;
    private String sourcePath;
    private String targetPath;
    private String appName;
    private Label labelSuccess;
    private Label labelError;
    private boolean success = false;

    public void init() {
        System.exit(0);
    }

    public void init(String sourcePath, String targetPath, String appName) {
        this.sourcePath = sourcePath;
        this.targetPath = targetPath;
        this.appName = appName;
        this.buttonClose.setVisible(false);
        this.imageView.setImage(new Image("/application/icon.png"));
        this.labelAppName.setText("Updating " + appName + "...");
        this.progressIndicator.setVisible(true);
        FontIcon iconSuccess = new FontIcon(FontIconType.CHECK);
        iconSuccess.setSize(38);
        iconSuccess.setColor(Color.web((String)"#247A2C"));
        this.labelSuccess = new Label("", (Node)iconSuccess);
        this.anchorPaneMain.getChildren().add((Object)this.labelSuccess);
        AnchorPane.setLeftAnchor((Node)this.labelSuccess, (Double)25.0);
        AnchorPane.setTopAnchor((Node)this.labelSuccess, (Double)73.0);
        this.labelSuccess.setVisible(false);
        FontIcon iconError = new FontIcon(FontIconType.TIMES);
        iconError.setSize(38);
        iconError.setColor(Color.web((String)"#CC0000"));
        this.labelError = new Label("", (Node)iconError);
        this.anchorPaneMain.getChildren().add((Object)this.labelError);
        AnchorPane.setLeftAnchor((Node)this.labelError, (Double)25.0);
        AnchorPane.setTopAnchor((Node)this.labelError, (Double)73.0);
        this.labelError.setVisible(false);
        Worker.runLater(() -> this.download());
    }

    public void download() {
        try {
            Files.move(Paths.get(this.sourcePath, new String[0]), Paths.get(this.targetPath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            Platform.runLater(() -> {
                this.labelAppName.setText("Successfully updated " + this.appName);
                this.progressIndicator.setVisible(false);
                this.labelError.setVisible(false);
                this.labelSuccess.setVisible(true);
                this.buttonClose.setVisible(true);
            });
            this.success = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            Platform.runLater(() -> {
                this.labelAppName.setText("Couln't update " + this.appName);
                this.progressIndicator.setVisible(false);
                this.labelError.setVisible(true);
                this.labelSuccess.setVisible(false);
                this.buttonClose.setVisible(true);
            });
            this.success = false;
        }
    }

    public void buttonClose() {
        if (this.success) {
            try {
                ProcessBuilder pb = new ProcessBuilder("java", "-jar", this.targetPath, "--update=1");
                pb.start();
                System.exit(0);
            }
            catch (IOException e) {
                System.exit(0);
            }
        } else {
            System.exit(0);
        }
    }
}

