/*
 * Decompiled with CFR 0.152.
 */
package logger;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import logger.ConsoleFileStream;
import logger.FileOutputMode;
import logger.LogLevel;

public class Logger {
    private static final SimpleDateFormat format = new SimpleDateFormat("dd.MM.YY - HH:mm:ss");
    private static LogLevel level;
    private static File folder;
    private static PrintStream outStream;
    private static PrintStream errorStream;

    public static LogLevel getLevel() {
        return level;
    }

    public static void setLevel(LogLevel newLevel) {
        level = newLevel;
        System.out.println("Logger running in LogLevel: " + (Object)((Object)level));
    }

    public static void setLevel(String newLevel) {
        try {
            Logger.setLevel(LogLevel.valueOf(newLevel.toUpperCase()));
        }
        catch (Exception e) {
            Logger.setLevel(LogLevel.NORMAL);
            Logger.error(String.valueOf(newLevel) + " is no valid LogLevel - set LogLevel to NORMAL");
        }
    }

    public static void appInfo(String appName, String versionName, String versionCode, String versionDate) {
        Logger.log(LogLevel.INFO, String.valueOf(appName) + " - v" + versionName + " - (versioncode: " + versionCode + ") from " + versionDate + ")");
    }

    public static void info(Object message) {
        Logger.log(LogLevel.INFO, message.toString());
    }

    public static void debug(Object message) {
        Logger.log(LogLevel.DEBUG, message.toString());
    }

    public static void warning(Object message) {
        Logger.log(LogLevel.WARNING, message.toString());
    }

    public static void error(Object message) {
        Logger.log(LogLevel.ERROR, message.toString());
    }

    public static void error(Exception exception) {
        Logger.log(LogLevel.ERROR, Logger.getStringFromException(exception));
    }

    private static void log(LogLevel logLevel, String message) {
        if (level == null) {
            level = LogLevel.OFF;
        }
        String logMessage = Logger.createLogMessage(logLevel, message);
        if (level.getLevel() >= logLevel.getLevel()) {
            if (logLevel.equals((Object)LogLevel.ERROR)) {
                Logger.logErrorToConsole(logMessage);
            } else {
                Logger.logToConsole(logMessage);
            }
        }
    }

    private static String createLogMessage(LogLevel logLevel, String message) {
        StackTraceElement element = Thread.currentThread().getStackTrace()[4];
        return "[" + (Object)((Object)logLevel) + "] - " + format.format(System.currentTimeMillis()) + " - " + element.getClassName() + "." + element.getMethodName() + ":" + element.getLineNumber() + "  -  " + message;
    }

    private static void logToConsole(String logMessage) {
        System.out.println(logMessage);
    }

    private static void logErrorToConsole(String logMessage) {
        System.err.println(logMessage);
    }

    public static void enableFileOutput(File folder, PrintStream outStream, PrintStream errorStream, FileOutputMode fileOutputMode) {
        Logger.folder = folder;
        Logger.outStream = outStream;
        Logger.errorStream = errorStream;
        File outLog = new File(folder.getAbsolutePath(), "out.log");
        File errorLog = new File(folder.getAbsolutePath(), "error.log");
        if (fileOutputMode == FileOutputMode.COMBINED) {
            outLog = errorLog;
        }
        try {
            System.setOut(new ConsoleFileStream(outLog, System.out));
            System.setErr(new ConsoleFileStream(errorLog, System.err));
            if (fileOutputMode == FileOutputMode.COMBINED) {
                Logger.info("File output enabled (" + errorLog.getAbsolutePath() + ")");
            } else {
                Logger.info("File output enabled (" + outLog.getAbsolutePath() + "\n" + errorLog.getAbsolutePath() + ")");
            }
        }
        catch (FileNotFoundException e) {
            Logger.disableFileOutput();
            Logger.error("Can't log to folder " + folder + "(" + e.getMessage() + ") FILEOUTPUT NOW DISABLED!");
        }
    }

    public static void disableFileOutput() {
        System.setOut(outStream);
        System.setErr(errorStream);
    }

    public static void deleteLogfile() {
        try {
            File outLog = new File(folder.getAbsolutePath(), "/out.log");
            Files.deleteIfExists(outLog.toPath());
            File errorLog = new File(folder.getAbsolutePath(), "/error.log");
            Files.deleteIfExists(errorLog.toPath());
        }
        catch (IOException e) {
            Logger.error("Can't delete log file(s)");
        }
    }

    private static String getStringFromException(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }
}

