/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqlx.io;

import com.mysql.cj.core.exceptions.CJCommunicationsException;
import com.mysql.cj.mysqlx.io.SerializingBufferWriter;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

public class TlsEncryptingByteChannel
extends AsynchronousSocketChannel {
    private AsynchronousSocketChannel channel;
    private SerializingBufferWriter bufferWriter;
    private SSLEngine sslEngine;
    private LinkedBlockingQueue<ByteBuffer> cipherTextBuffers = new LinkedBlockingQueue();

    public TlsEncryptingByteChannel(AsynchronousSocketChannel channel, SSLEngine sslEngine) {
        super(null);
        this.channel = channel;
        this.bufferWriter = new SerializingBufferWriter(channel);
        this.sslEngine = sslEngine;
    }

    private boolean isDrained(ByteBuffer[] buffers) {
        for (ByteBuffer b : buffers) {
            if (!b.hasRemaining()) continue;
            return false;
        }
        return true;
    }

    @Override
    public <A> void write(ByteBuffer[] srcs, int offset, int length, long timeout, TimeUnit unit, A attachment, CompletionHandler<Long, ? super A> handler) {
        try {
            long totalWriteSize = 0L;
            while (true) {
                ByteBuffer cipherText;
                SSLEngineResult res;
                if ((res = this.sslEngine.wrap(srcs, offset, length, cipherText = this.getCipherTextBuffer())).getStatus() != SSLEngineResult.Status.OK) {
                    handler.failed(new CJCommunicationsException("Unacceptable SSLEngine result: " + res), null);
                }
                totalWriteSize += (long)res.bytesConsumed();
                cipherText.flip();
                if (this.isDrained(srcs)) {
                    long finalTotal = totalWriteSize;
                    Runnable successHandler = () -> {
                        handler.completed(finalTotal, null);
                        this.putCipherTextBuffer(cipherText);
                    };
                    this.bufferWriter.queueBuffer(cipherText, new ErrorPropagatingCompletionHandler<Long>(handler, successHandler));
                    break;
                }
                this.bufferWriter.queueBuffer(cipherText, new ErrorPropagatingCompletionHandler<Long>(handler, () -> this.putCipherTextBuffer(cipherText)));
            }
        }
        catch (SSLException ex) {
            handler.failed(new CJCommunicationsException(ex), null);
        }
        catch (Throwable ex) {
            handler.failed(ex, null);
        }
    }

    private ByteBuffer getCipherTextBuffer() {
        ByteBuffer buf = this.cipherTextBuffers.poll();
        if (buf == null) {
            return ByteBuffer.allocate(this.sslEngine.getSession().getPacketBufferSize());
        }
        buf.clear();
        return buf;
    }

    private void putCipherTextBuffer(ByteBuffer buf) {
        if (this.cipherTextBuffers.size() < 10) {
            this.cipherTextBuffers.offer(buf);
        }
    }

    @Override
    public AsynchronousSocketChannel bind(SocketAddress local) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getOption(SocketOption<T> name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> AsynchronousSocketChannel setOption(SocketOption<T> name, T value) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public AsynchronousSocketChannel shutdownInput() throws IOException {
        return this.channel.shutdownInput();
    }

    @Override
    public AsynchronousSocketChannel shutdownOutput() throws IOException {
        return this.channel.shutdownOutput();
    }

    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        return this.channel.getRemoteAddress();
    }

    @Override
    public <A> void connect(SocketAddress remote, A attachment, CompletionHandler<Void, ? super A> handler) {
        handler.failed(new UnsupportedOperationException(), null);
    }

    @Override
    public Future<Void> connect(SocketAddress remote) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A> void read(ByteBuffer dst, long timeout, TimeUnit unit, A attachment, CompletionHandler<Integer, ? super A> handler) {
        handler.failed(new UnsupportedOperationException(), null);
    }

    @Override
    public Future<Integer> read(ByteBuffer dst) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A> void read(ByteBuffer[] dsts, int offset, int length, long timeout, TimeUnit unit, A attachment, CompletionHandler<Long, ? super A> handler) {
        handler.failed(new UnsupportedOperationException(), null);
    }

    @Override
    public <A> void write(ByteBuffer src, long timeout, TimeUnit unit, A attachment, CompletionHandler<Integer, ? super A> handler) {
        handler.failed(new UnsupportedOperationException(), null);
    }

    @Override
    public Future<Integer> write(ByteBuffer src) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        return this.channel.getLocalAddress();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    private static class ErrorPropagatingCompletionHandler<V>
    implements CompletionHandler<V, Void> {
        private CompletionHandler<Long, ?> target;
        private Runnable success;

        public ErrorPropagatingCompletionHandler(CompletionHandler<Long, ?> target, Runnable success) {
            this.target = target;
            this.success = success;
        }

        @Override
        public void completed(V result, Void attachment) {
            this.success.run();
        }

        @Override
        public void failed(Throwable ex, Void attachment) {
            this.target.failed(ex, null);
        }
    }
}

