/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmaster.logic.charts;

import de.deadlocker8.budgetmaster.logic.charts.CategoryInOutSum;
import de.deadlocker8.budgetmaster.logic.charts.ChartExportable;
import de.deadlocker8.budgetmaster.logic.charts.LegendType;
import de.deadlocker8.budgetmaster.logic.utils.Colors;
import de.deadlocker8.budgetmaster.logic.utils.Helpers;
import java.util.ArrayList;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.transform.Transform;
import javafx.stage.Modality;
import javafx.stage.Stage;
import tools.ConvertTo;
import tools.Localization;

public class CategoriesChart
extends VBox
implements ChartExportable {
    private String titleIncomes;
    private String titlePayments;
    private ArrayList<CategoryInOutSum> categoryInOutSums;
    private String currency;
    private double totalIncomes;
    private double totalPayments;
    private LegendType legendType;
    private final double CHART_HEIGHT = 200.0;
    private final double FULL_LEGEND_ITEM_HEIGHT = 40.0;
    private final double DELIMITER_HEIGHT = 21.0;

    public CategoriesChart(String titleIncomes, String titlePayments, ArrayList<CategoryInOutSum> categoryInOutSums, String currency, LegendType legendType) {
        this.titleIncomes = titleIncomes;
        this.titlePayments = titlePayments;
        this.categoryInOutSums = categoryInOutSums == null ? new ArrayList() : categoryInOutSums;
        this.currency = currency;
        this.totalIncomes = this.getTotal(this.categoryInOutSums, true);
        this.totalPayments = this.getTotal(categoryInOutSums, false);
        this.legendType = legendType;
        this.setSpacing(10.0);
        this.getChildren().add((Object)this.generate(titleIncomes, true));
        this.getChildren().add((Object)this.generate(titlePayments, false));
        Region spacer = new Region();
        this.getChildren().add((Object)spacer);
        VBox.setVgrow((Node)spacer, (Priority)Priority.ALWAYS);
        if (this.legendType == LegendType.NORMAL) {
            this.getChildren().add((Object)this.generateLegend());
        } else if (this.legendType == LegendType.FULL) {
            this.getChildren().add((Object)this.generateFullLegend());
        }
    }

    private VBox generate(String title, boolean useIncomes) {
        VBox generatedChart = new VBox();
        HBox chart = new HBox();
        chart.setMinHeight(50.0);
        Label labelTitle = new Label(title);
        labelTitle.setStyle("-fx-font-size: 16; -fx-font-weight: bold;");
        generatedChart.getChildren().add((Object)labelTitle);
        VBox.setMargin((Node)labelTitle, (Insets)new Insets(0.0, 0.0, 10.0, 0.0));
        for (CategoryInOutSum currentItem : this.categoryInOutSums) {
            double percentage;
            double value;
            Label currentPart = new Label();
            currentPart.setStyle("-fx-background-color: " + currentItem.getColor());
            currentPart.prefHeightProperty().bind((ObservableValue)chart.heightProperty());
            chart.getChildren().add((Object)currentPart);
            if (useIncomes) {
                value = (double)currentItem.getBudgetIN() / 100.0;
                percentage = value / this.totalIncomes;
            } else {
                value = (double)(-currentItem.getBudgetOUT()) / 100.0;
                percentage = value / this.totalPayments;
            }
            currentPart.prefWidthProperty().bind((ObservableValue)chart.widthProperty().multiply(percentage));
            Tooltip tooltip = new Tooltip();
            tooltip.setText(Localization.getString("tooltip.chart.categories", currentItem.getName(), Helpers.NUMBER_FORMAT.format(percentage * 100.0), Helpers.getCurrencyString(value, this.currency)));
            currentPart.setTooltip(tooltip);
        }
        generatedChart.getChildren().add((Object)chart);
        return generatedChart;
    }

    private GridPane generateLegend() {
        GridPane legend = new GridPane();
        legend.setPadding(new Insets(10.0));
        legend.setHgap(20.0);
        legend.setVgap(10.0);
        legend.setAlignment(Pos.CENTER);
        legend.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_CHART_LEGEND) + "; -fx-border-color: #212121; -fx-border-width: 1; -fx-border-radius: 5;");
        if (this.categoryInOutSums.size() == 0) {
            return legend;
        }
        ArrayList<HBox> legendItems = new ArrayList<HBox>();
        for (CategoryInOutSum currentItem : this.categoryInOutSums) {
            legendItems.add(this.getLegendItem(currentItem.getName(), Color.web((String)currentItem.getColor())));
        }
        int numberOfItems = legendItems.size();
        int legendWidth = numberOfItems <= 3 ? numberOfItems : (int)Math.ceil(Math.sqrt(numberOfItems));
        for (int i = 0; i < numberOfItems; ++i) {
            int columnIndex = i % legendWidth;
            int rowIndex = i / legendWidth;
            legend.add((Node)legendItems.get(i), columnIndex, rowIndex);
        }
        return legend;
    }

    private VBox generateFullLegend() {
        VBox legend = new VBox();
        legend.setPadding(new Insets(10.0));
        legend.setSpacing(10.0);
        legend.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_CHART_LEGEND) + "; -fx-border-color: #212121; -fx-border-width: 1; -fx-border-radius: 5;");
        if (this.categoryInOutSums.size() == 0) {
            return legend;
        }
        double totalIn = this.getTotal(this.categoryInOutSums, true);
        double totalOut = this.getTotal(this.categoryInOutSums, false);
        HBox hboxLegend = new HBox();
        hboxLegend.setSpacing(0.0);
        VBox vboxCircles = new VBox();
        vboxCircles.setSpacing(10.0);
        VBox vboxNames = new VBox();
        vboxNames.setSpacing(10.0);
        VBox vboxIn = new VBox();
        vboxIn.setSpacing(10.0);
        VBox vboxOut = new VBox();
        vboxOut.setSpacing(10.0);
        Label labelHeaderSpacer = new Label();
        labelHeaderSpacer.setMinWidth(20.0);
        labelHeaderSpacer.setMinHeight(20.0);
        vboxCircles.getChildren().add((Object)labelHeaderSpacer);
        Label labelHeaderName = new Label(Localization.getString("title.categories"));
        labelHeaderName.setStyle("-fx-font-weight: bold; -fx-underline: true;");
        labelHeaderName.setMinHeight(20.0);
        labelHeaderName.setPadding(new Insets(0.0, 0.0, 0.0, 10.0));
        vboxNames.getChildren().add((Object)labelHeaderName);
        Label labelHeaderIn = new Label(Localization.getString("title.incomes"));
        labelHeaderIn.setStyle("-fx-font-weight: bold; -fx-underline: true;");
        labelHeaderIn.setMinHeight(20.0);
        vboxIn.getChildren().add((Object)labelHeaderIn);
        Label labelHeaderOut = new Label(Localization.getString("title.payments"));
        labelHeaderOut.setStyle("-fx-font-weight: bold; -fx-underline: true;");
        labelHeaderOut.setMinHeight(20.0);
        vboxOut.getChildren().add((Object)labelHeaderOut);
        for (int i = 0; i < this.categoryInOutSums.size(); ++i) {
            CategoryInOutSum currentItem = this.categoryInOutSums.get(i);
            Label labelCircle = new Label();
            labelCircle.setMinWidth(20.0);
            labelCircle.setMinHeight(20.0);
            labelCircle.setStyle("-fx-background-color: " + currentItem.getColor() + "; -fx-background-radius: 50%; -fx-border-width: 1; -fx-border-color: black - fx-border-radius: 50%");
            vboxCircles.getChildren().add((Object)labelCircle);
            Label labelName = new Label(currentItem.getName());
            labelName.setStyle("-fx-font-weight: bold;");
            labelName.setMinHeight(20.0);
            labelName.setPadding(new Insets(0.0, 0.0, 0.0, 10.0));
            vboxNames.getChildren().add((Object)labelName);
            String percentageIn = totalIn != 0.0 ? Helpers.NUMBER_FORMAT.format(Math.abs((double)currentItem.getBudgetIN() / totalIn)) : "0,00";
            Label labelInSum = new Label("+" + Helpers.getCurrencyString(currentItem.getBudgetIN(), this.currency) + " (" + percentageIn + "%)");
            labelInSum.setStyle("-fx-font-weight: bold;");
            labelInSum.setMinHeight(20.0);
            vboxIn.getChildren().add((Object)labelInSum);
            String percentageOut = totalOut != 0.0 ? Helpers.NUMBER_FORMAT.format(Math.abs((double)currentItem.getBudgetOUT() / totalOut)) : "0,00";
            Label labelOutSum = new Label(Helpers.getCurrencyString(currentItem.getBudgetOUT(), this.currency) + " (" + percentageOut + "%)");
            labelOutSum.setStyle("-fx-font-weight: bold;");
            labelOutSum.setMinHeight(20.0);
            vboxOut.getChildren().add((Object)labelOutSum);
            if (i >= this.categoryInOutSums.size() - 1) continue;
            vboxCircles.getChildren().add((Object)this.generateNewSeparator());
            vboxNames.getChildren().add((Object)this.generateNewSeparator());
            vboxIn.getChildren().add((Object)this.generateNewSeparator());
            vboxOut.getChildren().add((Object)this.generateNewSeparator());
        }
        hboxLegend.getChildren().add((Object)vboxCircles);
        hboxLegend.getChildren().add((Object)vboxNames);
        HBox.setHgrow((Node)vboxNames, (Priority)Priority.ALWAYS);
        hboxLegend.getChildren().add((Object)vboxIn);
        HBox.setHgrow((Node)vboxIn, (Priority)Priority.ALWAYS);
        hboxLegend.getChildren().add((Object)vboxOut);
        HBox.setHgrow((Node)vboxOut, (Priority)Priority.ALWAYS);
        legend.getChildren().add((Object)hboxLegend);
        return legend;
    }

    private HBox getLegendItem(String name, Color color) {
        HBox legendItem = new HBox();
        Label labelCircle = new Label();
        labelCircle.setMinWidth(20.0);
        labelCircle.setMinHeight(20.0);
        labelCircle.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(color) + "; -fx-background-radius: 50%; -fx-border-width: 1; -fx-border-color: black - fx-border-radius: 50%");
        Label labelText = new Label(name);
        labelText.setStyle("-fx-font-weight: bold;");
        legendItem.getChildren().add((Object)labelCircle);
        legendItem.getChildren().add((Object)labelText);
        HBox.setMargin((Node)labelText, (Insets)new Insets(0.0, 0.0, 0.0, 5.0));
        return legendItem;
    }

    private Label generateNewSeparator() {
        Label separator = new Label();
        separator.setStyle("-fx-background-color: #212121; -fx-padding: 0;");
        separator.setFont(new Font(1.0));
        separator.setMinHeight(1.0);
        separator.setMaxHeight(1.0);
        separator.setMaxWidth(Double.MAX_VALUE);
        return separator;
    }

    private double getTotal(ArrayList<CategoryInOutSum> categoryInOutSums, boolean useIncomes) {
        double total = 0.0;
        for (CategoryInOutSum currentItem : categoryInOutSums) {
            if (useIncomes) {
                total += (double)currentItem.getBudgetIN() / 100.0;
                continue;
            }
            total += (double)(-currentItem.getBudgetOUT()) / 100.0;
        }
        return total;
    }

    @Override
    public WritableImage export(int width, int height) {
        VBox root = new VBox();
        root.setStyle("-fx-background-color: transparent;");
        root.setPadding(new Insets(25.0));
        root.setSpacing(10.0);
        root.getChildren().add((Object)this.generate(this.titleIncomes, true));
        root.getChildren().add((Object)this.generate(this.titlePayments, false));
        Region spacer = new Region();
        spacer.setMinHeight(25.0);
        root.getChildren().add((Object)spacer);
        VBox.setVgrow((Node)spacer, (Priority)Priority.ALWAYS);
        root.getChildren().add((Object)this.generateFullLegend());
        Stage newStage = new Stage();
        newStage.initModality(Modality.NONE);
        newStage.setScene(new Scene((Parent)root, (double)width, (double)height));
        newStage.setResizable(false);
        newStage.show();
        SnapshotParameters sp = new SnapshotParameters();
        sp.setTransform((Transform)Transform.scale((double)((double)width / root.getWidth()), (double)((double)height / root.getHeight())));
        newStage.close();
        return root.snapshot(sp, null);
    }

    @Override
    public double getSuggestedWidth() {
        return this.getWidth() + 50.0;
    }

    @Override
    public double getSuggestedHeight() {
        return 200.0 + (double)this.categoryInOutSums.size() * 61.0 + 50.0;
    }
}

