/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmaster.logic.tag;

import de.deadlocker8.budgetmaster.logic.payment.Payment;
import de.deadlocker8.budgetmaster.logic.payment.RepeatingPaymentEntry;
import de.deadlocker8.budgetmaster.logic.tag.Tag;
import java.util.ArrayList;
import java.util.HashMap;

public class TagCache {
    private HashMap<Integer, ArrayList<Tag>> normalPaymentTagCache;
    private HashMap<Integer, ArrayList<Tag>> repeatingPaymentTagCache;

    public TagCache() {
        this.clear();
    }

    public void clear() {
        this.normalPaymentTagCache = new HashMap();
        this.repeatingPaymentTagCache = new HashMap();
    }

    public void addTags(Payment payment, ArrayList<Tag> tags) {
        if (payment instanceof RepeatingPaymentEntry) {
            this.repeatingPaymentTagCache.put(((RepeatingPaymentEntry)payment).getRepeatingPaymentID(), tags);
        } else {
            this.normalPaymentTagCache.put(payment.getID(), tags);
        }
    }

    public ArrayList<Tag> getTags(Payment payment) {
        if (payment instanceof RepeatingPaymentEntry) {
            RepeatingPaymentEntry repeatingPayment = (RepeatingPaymentEntry)payment;
            if (this.repeatingPaymentTagCache.containsKey(repeatingPayment.getRepeatingPaymentID())) {
                return this.repeatingPaymentTagCache.get(repeatingPayment.getRepeatingPaymentID());
            }
        } else if (this.normalPaymentTagCache.containsKey(payment.getID())) {
            return this.normalPaymentTagCache.get(payment.getID());
        }
        return null;
    }

    public HashMap<Integer, ArrayList<Tag>> getNormalPaymentTagCache() {
        return this.normalPaymentTagCache;
    }

    public HashMap<Integer, ArrayList<Tag>> getRepeatingPaymentTagCache() {
        return this.repeatingPaymentTagCache;
    }
}

