/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterserver.logic.database.creator;

import de.deadlocker8.budgetmasterserver.logic.Settings;
import java.sql.Connection;
import java.util.ArrayList;
import logger.Logger;

public abstract class DatabaseCreator {
    Connection connection;
    Settings settings;

    public DatabaseCreator(Connection connection, Settings settings) {
        this.connection = connection;
        this.settings = settings;
    }

    public void createTables() {
        Logger.info("Checking tables...");
        this.createTables(this.getExistingTables());
        Logger.info("Checking tables [DONE]");
    }

    public abstract ArrayList<String> getExistingTables();

    private void createTables(ArrayList<String> existingTables) {
        if (!existingTables.contains("category")) {
            this.createTableCategory();
        }
        if (!existingTables.contains("payment")) {
            this.createTablePayment();
        }
        if (!existingTables.contains("repeating_payment")) {
            this.createTableRepeatingPayment();
        }
        if (!existingTables.contains("repeating_entry")) {
            this.createTableRepeatingEntry();
        }
        if (!existingTables.contains("tag")) {
            this.createTableTag();
        }
        if (!existingTables.contains("tag_match")) {
            this.createTableTagMatch();
        }
    }

    public abstract void createTableCategory();

    public abstract void createTablePayment();

    public abstract void createTableRepeatingEntry();

    public abstract void createTableRepeatingPayment();

    public abstract void createTableTag();

    public abstract void createTableTagMatch();
}

