/*
 * Decompiled with CFR 0.152.
 */
package notification;

import java.util.ArrayList;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Background;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Duration;

public class Notification {
    public ArrayList<Rectangle> rects = new ArrayList();
    private int notificationWidth = 350;
    private int notificationHeight = 120;
    private int offset = 5;
    private int iconSize = 50;
    private String title;
    private String description;
    private Image icon;
    private int hideAfterInMillis;
    private int fadeOutTimeInMillis;
    private Timeline timeline;
    private Stage stage;
    private Stage owner;

    public void close() {
        if (this.stage != null) {
            this.stage.close();
            this.timeline.stop();
        }
    }

    public void show() {
        try {
            if (this.hideAfterInMillis == 0) {
                this.hideAfterInMillis = 4000;
            }
            if (this.fadeOutTimeInMillis == 0) {
                this.fadeOutTimeInMillis = 1000;
            }
            Rectangle2D primaryScreenBounds = Screen.getPrimary().getVisualBounds();
            this.stage = new Stage();
            this.stage.initStyle(StageStyle.TRANSPARENT);
            this.stage.setX(primaryScreenBounds.getMaxX() - (double)this.notificationWidth - (double)this.offset);
            this.stage.setY(primaryScreenBounds.getMaxY() - (double)this.notificationHeight - (double)this.offset);
            this.stage.setAlwaysOnTop(true);
            AnchorPane root = new AnchorPane();
            root.setPrefWidth((double)this.notificationWidth);
            root.setPrefHeight((double)this.notificationHeight);
            root.setBackground(Background.EMPTY);
            AnchorPane content = new AnchorPane();
            content.setPrefWidth((double)(this.notificationWidth - 10));
            content.setPrefHeight((double)(this.notificationHeight - 10));
            content.setStyle("-fx-background-color:  linear-gradient(#EFEFEF,#D9D9D9); -fx-border-color: #B5B5B5; -border-radius: 5; -fx-background-radius: 5;  -fx-effect: dropshadow(three-pass-box, rgba(0, 0, 0, 0.4), 11, 0.0, 0, 3); ");
            root.getChildren().add((Object)content);
            AnchorPane.setLeftAnchor((Node)content, (Double)5.0);
            AnchorPane.setTopAnchor((Node)content, (Double)5.0);
            Button button = new Button();
            button.setText("x");
            button.setStyle("-fx-font-weight: bold; -fx-background-color: transparent; -fx-font-size: 19px");
            button.setFocusTraversable(false);
            button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    Notification.this.stage.close();
                    Notification.this.timeline.stop();
                }
            });
            content.getChildren().add((Object)button);
            AnchorPane.setRightAnchor((Node)button, (Double)5.0);
            AnchorPane.setTopAnchor((Node)button, (Double)0.0);
            if (this.icon == null) {
                this.icon = new Image("/notification/trophyUnlocked.png");
            }
            ImageView view = new ImageView(this.icon);
            view.setFitWidth((double)this.iconSize);
            view.setFitHeight((double)this.iconSize);
            content.getChildren().add((Object)view);
            AnchorPane.setLeftAnchor((Node)view, (Double)15.0);
            AnchorPane.setTopAnchor((Node)view, (Double)((double)(this.notificationHeight - this.offset - this.iconSize) / 2.0));
            Label labelTitle = new Label(this.title);
            labelTitle.setStyle("-fx-font-weight: bold; -fx-font-size: 16px;");
            content.getChildren().add((Object)labelTitle);
            AnchorPane.setLeftAnchor((Node)labelTitle, (Double)(15.0 + (double)this.iconSize + 25.0));
            AnchorPane.setTopAnchor((Node)labelTitle, (Double)15.0);
            Label labelDescription = new Label(this.description);
            labelDescription.setStyle("-fx-font-size: 17px;");
            labelDescription.setPrefWidth((double)(this.notificationWidth - this.offset - this.iconSize) - 35.0);
            labelDescription.setWrapText(true);
            content.getChildren().add((Object)labelDescription);
            AnchorPane.setLeftAnchor((Node)labelDescription, (Double)(15.0 + (double)this.iconSize + 25.0));
            AnchorPane.setTopAnchor((Node)labelDescription, (Double)50.0);
            Scene scene = new Scene((Parent)root, (double)this.notificationWidth, (double)this.notificationHeight);
            scene.setFill((Paint)Color.TRANSPARENT);
            this.stage.setScene(scene);
            this.stage.show();
            if (this.owner != null) {
                this.owner.requestFocus();
            }
            this.timeline = new Timeline();
            KeyFrame key = new KeyFrame(Duration.millis((double)this.fadeOutTimeInMillis), new KeyValue[]{new KeyValue((WritableValue)this.stage.getScene().getRoot().opacityProperty(), (Object)0)});
            this.timeline.getKeyFrames().add((Object)key);
            this.timeline.setDelay(Duration.millis((double)this.hideAfterInMillis));
            this.timeline.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    if (Notification.this.stage != null) {
                        Notification.this.stage.close();
                        Notification.this.stage = null;
                    }
                }
            });
            this.timeline.play();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setIcon(Image icon) {
        this.icon = icon;
    }

    public void setHideAfterInMillis(int hideAfterInMillis) {
        this.hideAfterInMillis = hideAfterInMillis;
    }

    public void setFadeOutTimeInMillis(int fadeOutTimeInMillis) {
        this.fadeOutTimeInMillis = fadeOutTimeInMillis;
    }

    public void setOwner(Stage owner) {
        this.owner = owner;
    }

    public boolean isOpen() {
        return this.stage != null;
    }
}

