/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmaster.logic.payment;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import de.deadlocker8.budgetmaster.logic.payment.NormalPayment;
import de.deadlocker8.budgetmaster.logic.payment.Payment;
import de.deadlocker8.budgetmaster.logic.payment.RepeatingPayment;
import java.util.ArrayList;

public class PaymentJSONDeserializer {
    public static Payment deserializePayment(JsonObject paymentObject) {
        if (paymentObject.get("classType").getAsString().equals("NormalPayment")) {
            NormalPayment payment = new NormalPayment();
            payment.setID(paymentObject.get("ID").getAsInt());
            payment.setAmount(paymentObject.get("amount").getAsInt());
            payment.setDate(paymentObject.get("date").getAsString());
            payment.setCategoryID(paymentObject.get("categoryID").getAsInt());
            payment.setName(paymentObject.get("name").getAsString());
            payment.setDescription(paymentObject.get("description").getAsString());
            return payment;
        }
        if (paymentObject.get("classType").getAsString().equals("RepeatingPayment")) {
            RepeatingPayment payment = new RepeatingPayment();
            payment.setID(paymentObject.get("ID").getAsInt());
            payment.setAmount(paymentObject.get("amount").getAsInt());
            payment.setDate(paymentObject.get("date").getAsString());
            payment.setCategoryID(paymentObject.get("categoryID").getAsInt());
            payment.setName(paymentObject.get("name").getAsString());
            payment.setDescription(paymentObject.get("description").getAsString());
            payment.setRepeatInterval(paymentObject.get("repeatInterval").getAsInt());
            payment.setRepeatMonthDay(paymentObject.get("repeatMonthDay").getAsInt());
            JsonElement repeatEndDate = paymentObject.get("repeatEndDate");
            payment.setRepeatEndDate(repeatEndDate != JsonNull.INSTANCE ? repeatEndDate.getAsString() : null);
            return payment;
        }
        return null;
    }

    public static ArrayList<Payment> deserializePaymentList(JsonArray paymentArray) {
        ArrayList<Payment> payments = new ArrayList<Payment>();
        for (JsonElement currentElement : paymentArray) {
            payments.add(PaymentJSONDeserializer.deserializePayment(currentElement.getAsJsonObject()));
        }
        return payments;
    }
}

