/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.ui;

import de.deadlocker8.budgetmaster.logic.utils.LanguageType;
import de.deadlocker8.budgetmasterclient.main.Main;
import de.deadlocker8.budgetmasterclient.ui.controller.Controller;
import de.deadlocker8.budgetmasterclient.ui.controller.SplashScreenController;
import java.util.Optional;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import tools.Localization;

public class RestartHandler {
    private Controller controller;

    public RestartHandler(Controller controller) {
        this.controller = controller;
    }

    public void handleRestart(LanguageType previousLanguage) {
        this.controller.refresh(this.controller.getFilterSettings());
        this.controller.showNotification(Localization.getString("notification.settings.save"));
        if (this.controller.getSettings().isAutoUpdateCheckEnabled()) {
            this.controller.checkForUpdates(false);
        }
        if (this.controller.getSettings().getLanguage() != previousLanguage) {
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setTitle(Localization.getString("info.title.language.changed"));
            alert.setHeaderText("");
            alert.setContentText(Localization.getString("info.text.language.changed"));
            Stage dialogStage = (Stage)alert.getDialogPane().getScene().getWindow();
            dialogStage.getIcons().add((Object)this.controller.getIcon());
            ButtonType buttonTypeOne = new ButtonType(Localization.getString("info.text.language.changed.restart.now"));
            ButtonType buttonTypeTwo = new ButtonType(Localization.getString("info.text.language.changed.restart.later"));
            alert.getButtonTypes().setAll((Object[])new ButtonType[]{buttonTypeOne, buttonTypeTwo});
            DialogPane dialogPane = alert.getDialogPane();
            dialogPane.getButtonTypes().stream().map(arg_0 -> ((DialogPane)dialogPane).lookupButton(arg_0)).forEach(button -> button.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
                if (KeyCode.ENTER.equals((Object)event.getCode()) && event.getTarget() instanceof Button) {
                    ((Button)event.getTarget()).fire();
                }
            }));
            Optional result = alert.showAndWait();
            if (result.get() == buttonTypeOne) {
                this.controller.getStage().close();
                Localization.loadLanguage(this.controller.getSettings().getLanguage().getLocale());
                Image icon = new Image("/de/deadlocker8/budgetmaster/icon.png");
                new SplashScreenController(Main.primaryStage, icon, false, this.controller.getShutdownHandler());
            } else {
                alert.close();
            }
        }
    }
}

