/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.ui.commandLine.commands;

import de.deadlocker8.budgetmaster.logic.serverconnection.ServerConnection;
import de.deadlocker8.budgetmaster.logic.serverconnection.ServerInformation;
import de.deadlocker8.budgetmaster.logic.updater.VersionInformation;
import de.deadlocker8.budgetmasterclient.ui.commandLine.CommandBundle;
import de.deadlocker8.budgetmasterclient.ui.commandLine.commands.Command;
import tools.Localization;

public class CommandInfo
extends Command {
    public CommandInfo() {
        this.keyword = "info";
        this.numberOfParams = 1;
        this.helptText = "help.info";
    }

    @Override
    public void execute(String[] command, CommandBundle bundle) {
        if (!this.isValid(command)) {
            bundle.getController().print(bundle.getString("error.invalid.arguments"));
            return;
        }
        if (command[1].equals("client")) {
            String text = Localization.getString("app.name") + " v" + Localization.getString("version.name") + " (" + Localization.getString("version.code") + ") from " + Localization.getString("version.date");
            bundle.getController().print(text);
            return;
        }
        if (command[1].equals("server")) {
            try {
                ServerConnection connection = new ServerConnection(bundle.getParentController().getSettings());
                ServerInformation serverInfo = connection.getServerInfo();
                VersionInformation versionInfo = serverInfo.getVersionInfo();
                String text = "BudgetMasterServer v" + versionInfo.getVersionName() + " (" + versionInfo.getVersionCode() + ") from " + versionInfo.getDate() + "\nListening on port " + serverInfo.getServerPort() + "\nConnected with user \"" + serverInfo.getDatabaseUsername() + "\" to database \"" + serverInfo.getDatabaseName() + "@" + serverInfo.getDatabaseUrl() + "\"\nKeystore location is: \"" + serverInfo.getKeystorePath() + "\"";
                bundle.getController().print(text);
            }
            catch (Exception e) {
                bundle.getController().print(bundle.getString("delete.error.connection"));
            }
            return;
        }
        bundle.getController().print(bundle.getString("error.invalid.parameter", command[1], this.keyword));
    }
}

