/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.ui.controller;

import de.deadlocker8.budgetmaster.logic.FilterSettings;
import de.deadlocker8.budgetmaster.logic.ServerType;
import de.deadlocker8.budgetmaster.logic.Settings;
import de.deadlocker8.budgetmaster.logic.category.CategoryBudget;
import de.deadlocker8.budgetmaster.logic.category.CategoryHandler;
import de.deadlocker8.budgetmaster.logic.payment.NormalPayment;
import de.deadlocker8.budgetmaster.logic.payment.Payment;
import de.deadlocker8.budgetmaster.logic.payment.PaymentHandler;
import de.deadlocker8.budgetmaster.logic.search.SearchPreferences;
import de.deadlocker8.budgetmaster.logic.serverconnection.ExceptionHandler;
import de.deadlocker8.budgetmaster.logic.serverconnection.ServerConnection;
import de.deadlocker8.budgetmaster.logic.tag.TagHandler;
import de.deadlocker8.budgetmaster.logic.updater.Updater;
import de.deadlocker8.budgetmaster.logic.updater.VersionInformation;
import de.deadlocker8.budgetmaster.logic.utils.Colors;
import de.deadlocker8.budgetmasterclient.ui.ShutdownHandler;
import de.deadlocker8.budgetmasterclient.ui.commandLine.CommandBundle;
import de.deadlocker8.budgetmasterclient.ui.commandLine.CommandLine;
import de.deadlocker8.budgetmasterclient.ui.controller.BaseController;
import de.deadlocker8.budgetmasterclient.ui.controller.CategoryController;
import de.deadlocker8.budgetmasterclient.ui.controller.ChartController;
import de.deadlocker8.budgetmasterclient.ui.controller.DatePickerController;
import de.deadlocker8.budgetmasterclient.ui.controller.HomeController;
import de.deadlocker8.budgetmasterclient.ui.controller.PaymentController;
import de.deadlocker8.budgetmasterclient.ui.controller.ReportController;
import de.deadlocker8.budgetmasterclient.ui.controller.settings.LocalServerSettingsController;
import de.deadlocker8.budgetmasterclient.ui.controller.settings.SettingsController;
import de.deadlocker8.budgetmasterclient.utils.LoadingModal;
import fontAwesome.FontIcon;
import fontAwesome.FontIconType;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.SequentialTransition;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import logger.Logger;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import tools.AlertGenerator;
import tools.ConvertTo;
import tools.Localization;
import tools.Worker;

public class Controller
extends BaseController {
    @FXML
    private AnchorPane anchorPaneMain;
    @FXML
    private Button buttonDate;
    @FXML
    private Button buttonLeft;
    @FXML
    private Button buttonRight;
    @FXML
    private Button buttonToday;
    @FXML
    private Button buttonAbout;
    @FXML
    private TabPane tabPane;
    @FXML
    private Tab tabHome;
    @FXML
    private Tab tabPayments;
    @FXML
    private Tab tabCategories;
    @FXML
    private Tab tabCharts;
    @FXML
    private Tab tabReports;
    @FXML
    private Tab tabSettings;
    @FXML
    private Label labelNotification;
    private HomeController homeController;
    private PaymentController paymentController;
    private CategoryController categoryController;
    private ChartController chartController;
    private ReportController reportController;
    private SettingsController settingsController;
    private Image icon = new Image("de/deadlocker8/budgetmaster/icon.png");
    private Settings settings;
    private ShutdownHandler shutdownHandler;
    private DateTime currentDate;
    private ArrayList<CategoryBudget> categoryBudgets;
    private PaymentHandler paymentHandler;
    private CategoryHandler categoryHandler;
    private FilterSettings filterSettings;
    private Updater updater;
    private Payment selectedPayment;
    private SearchPreferences searchPreferences;
    private CommandLine cmd;
    private boolean alertIsShowing = false;
    private static DateTimeFormatter DATE_FORMAT;

    public Controller(Settings settings, ShutdownHandler shutdownHandler) {
        this.settings = settings;
        this.shutdownHandler = shutdownHandler;
        DATE_FORMAT = DateTimeFormat.forPattern("MMMM yyyy").withLocale(this.settings.getLanguage().getLocale());
        this.load("/de/deadlocker8/budgetmaster/ui/fxml/GUI.fxml", Localization.getBundle());
        this.getStage().show();
    }

    @Override
    public void initStage(Stage stage) {
        stage.setTitle(Localization.getString("app.name"));
        stage.getIcons().add((Object)this.icon);
        stage.setResizable(true);
        stage.setWidth(660.0);
        stage.setHeight(725.0);
        stage.setMinWidth(660.0);
        stage.setMinHeight(650.0);
        stage.getScene().getStylesheets().add((Object)"/de/deadlocker8/budgetmaster/ui/style.css");
    }

    @Override
    public void init() {
        this.shutdownHandler.setController(this);
        this.getStage().setOnCloseRequest(event -> {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHandler.getShutdownThread());
            this.shutdownHandler.shutdown();
        });
        try {
            Runtime.getRuntime().addShutdownHook(this.shutdownHandler.getShutdownThread());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (this.settings.getServerType() == null) {
            this.settings.setServerType(ServerType.ONLINE);
        }
        Logger.info("Running with ServerType: " + (Object)((Object)this.settings.getServerType()));
        this.currentDate = DateTime.now();
        this.buttonDate.setText(this.currentDate.toString(DATE_FORMAT));
        this.filterSettings = new FilterSettings();
        this.paymentHandler = new PaymentHandler();
        this.updater = new Updater();
        CommandBundle commandBundle = new CommandBundle(this);
        this.cmd = new CommandLine(this.getStage(), this.icon, ResourceBundle.getBundle("de/deadlocker8/budgetmaster/ui/commandLine/", Locale.ENGLISH), commandBundle);
        if (this.settings.isAutoUpdateCheckEnabled()) {
            this.checkForUpdates(false);
        }
        KeyCodeCombination keyCombinationSearch = new KeyCodeCombination(KeyCode.F, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN});
        this.getStage().getScene().setOnKeyReleased(arg_0 -> this.lambda$init$1((KeyCombination)keyCombinationSearch, arg_0));
        this.initUI();
    }

    private <T> T loadTab(String fileName, Tab tab) throws IOException {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource(fileName));
        fxmlLoader.setResources(Localization.getBundle());
        Parent nodeTab = (Parent)fxmlLoader.load();
        tab.setContent((Node)nodeTab);
        return (T)fxmlLoader.getController();
    }

    private void initUI() {
        try {
            this.homeController = (HomeController)this.loadTab("/de/deadlocker8/budgetmaster/ui/fxml/HomeTab.fxml", this.tabHome);
            this.homeController.init(this);
            this.paymentController = (PaymentController)this.loadTab("/de/deadlocker8/budgetmaster/ui/fxml/PaymentTab.fxml", this.tabPayments);
            this.paymentController.init(this);
            this.categoryController = (CategoryController)this.loadTab("/de/deadlocker8/budgetmaster/ui/fxml/CategoryTab.fxml", this.tabCategories);
            this.categoryController.init(this);
            this.chartController = (ChartController)this.loadTab("/de/deadlocker8/budgetmaster/ui/fxml/ChartTab.fxml", this.tabCharts);
            this.chartController.init(this);
            this.tabCharts.selectedProperty().addListener((a, b, c) -> {
                if (c.booleanValue()) {
                    this.chartController.refresh();
                }
            });
            this.reportController = (ReportController)this.loadTab("/de/deadlocker8/budgetmaster/ui/fxml/ReportTab.fxml", this.tabReports);
            this.reportController.init(this);
            this.tabReports.selectedProperty().addListener((a, b, c) -> {
                if (c.booleanValue()) {
                    this.reportController.refresh();
                }
            });
            this.loadSettingsTab();
        }
        catch (IOException e) {
            Logger.error(e);
            Platform.runLater(() -> AlertGenerator.showAlert(Alert.AlertType.ERROR, Localization.getString("title.error"), "", Localization.getString("error.create.ui"), this.icon, (Window)this.getStage(), null, false));
        }
        this.buttonLeft.setGraphic((Node)new FontIcon(FontIconType.CHEVRON_LEFT, 20, Colors.TEXT));
        this.buttonRight.setGraphic((Node)new FontIcon(FontIconType.CHEVRON_RIGHT, 20, Colors.TEXT));
        this.buttonToday.setGraphic((Node)new FontIcon(FontIconType.CALENDAR_ALT, 20, Colors.TEXT));
        this.buttonAbout.setGraphic((Node)new FontIcon(FontIconType.INFO, 20, Colors.TEXT));
        this.anchorPaneMain.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_MAIN));
        this.labelNotification.setStyle("-fx-text-fill: #FFFFFF; -fx-font-size: 16; -fx-font-weight: bold; -fx-background-color: transparent;");
        this.buttonDate.setStyle("-fx-padding: 0; -fx-background-color: transparent; -fx-font-weight: bold; -fx-font-size: 24; -fx-text-fill: " + ConvertTo.toRGBHexWithoutOpacity(Colors.TEXT));
        this.buttonDate.getStyleClass().add((Object)"button-hoverable");
        this.buttonLeft.setStyle("-fx-background-color: transparent;");
        this.buttonLeft.getStyleClass().add((Object)"button-hoverable");
        this.buttonRight.setStyle("-fx-background-color: transparent;");
        this.buttonRight.getStyleClass().add((Object)"button-hoverable");
        this.buttonToday.setStyle("-fx-background-color: transparent;");
        this.buttonToday.getStyleClass().add((Object)"button-hoverable");
        this.buttonAbout.setStyle("-fx-background-color: transparent;");
        this.buttonAbout.getStyleClass().add((Object)"button-hoverable");
    }

    public void loadSettingsTab() {
        try {
            if (this.settings.getServerType().equals((Object)ServerType.ONLINE)) {
                this.settingsController = (SettingsController)this.loadTab("/de/deadlocker8/budgetmaster/ui/fxml/SettingsTabOnlineServer.fxml", this.tabSettings);
                this.settingsController.init(this);
            } else {
                this.settingsController = (SettingsController)this.loadTab("/de/deadlocker8/budgetmaster/ui/fxml/SettingsTabLocalServer.fxml", this.tabSettings);
                this.settingsController.init(this);
            }
        }
        catch (IOException e) {
            Logger.error(e);
            Platform.runLater(() -> AlertGenerator.showAlert(Alert.AlertType.ERROR, Localization.getString("title.error"), "", Localization.getString("error.create.ui"), this.icon, (Window)this.getStage(), null, false));
        }
    }

    public boolean checkSettings() {
        if (!this.settings.isComplete()) {
            Platform.runLater(() -> {
                this.toggleAllTabsExceptSettings(true);
                this.tabPane.getSelectionModel().select((Object)this.tabSettings);
                AlertGenerator.showAlert(Alert.AlertType.INFORMATION, Localization.getString("title.info"), "", Localization.getString("info.first.start"), this.icon, (Window)this.getStage(), null, false);
            });
            return false;
        }
        return true;
    }

    public Image getIcon() {
        return this.icon;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public ShutdownHandler getShutdownHandler() {
        return this.shutdownHandler;
    }

    public void showNotification(String text) {
        this.labelNotification.setText(text);
        this.labelNotification.setStyle("-fx-text-fill: #FFFFFF; -fx-font-size: 16; -fx-font-weight: bold; -fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_NOTIFICATION));
        FadeTransition fadeIn = new FadeTransition(Duration.millis((double)200.0), (Node)this.labelNotification);
        fadeIn.setFromValue(0.0);
        fadeIn.setToValue(1.0);
        FadeTransition fadeOut = new FadeTransition(Duration.millis((double)400.0), (Node)this.labelNotification);
        fadeOut.setFromValue(1.0);
        fadeOut.setToValue(0.0);
        fadeOut.setDelay(Duration.millis((double)3000.0));
        fadeOut.play();
        SequentialTransition seqT = new SequentialTransition(new Animation[]{fadeIn, fadeOut});
        seqT.play();
        seqT.setOnFinished(a -> this.labelNotification.setStyle("-fx-text-fill: #FFFFFF; -fx-font-size: 16; -fx-font-weight: bold; -fx-background-color: transparent;"));
    }

    public void previousMonth() {
        this.currentDate = this.currentDate.minusMonths(1);
        this.buttonDate.setText(this.currentDate.toString(DATE_FORMAT));
        this.refresh(this.filterSettings);
    }

    public void nextMonth() {
        this.currentDate = this.currentDate.plusMonths(1);
        this.buttonDate.setText(this.currentDate.toString(DATE_FORMAT));
        this.refresh(this.filterSettings);
    }

    public void today() {
        this.currentDate = DateTime.now();
        this.buttonDate.setText(this.currentDate.toString(DATE_FORMAT));
        this.refresh(this.filterSettings);
    }

    public void setDate(DateTime newDate) {
        this.currentDate = newDate;
        this.buttonDate.setText(this.currentDate.toString(DATE_FORMAT));
        this.refresh(this.filterSettings);
    }

    public DateTime getCurrentDate() {
        return this.currentDate;
    }

    public void openDatePicker() {
        new DatePickerController(this.getStage(), this, this.currentDate);
    }

    public void forceSettingsTab() {
        this.toggleAllTabsExceptSettings(true);
        this.tabPane.getSelectionModel().select((Object)this.tabSettings);
    }

    public void showConnectionErrorAlert(String errorMessage) {
        if (!this.alertIsShowing) {
            this.alertIsShowing = true;
            Platform.runLater(() -> {
                this.toggleAllTabsExceptSettings(true);
                this.tabPane.getSelectionModel().select((Object)this.tabSettings);
                this.alertIsShowing = true;
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle(Localization.getString("title.error"));
                alert.setHeaderText("");
                if (errorMessage == null) {
                    alert.setContentText(Localization.getString("error.server.connection"));
                } else {
                    alert.setContentText(Localization.getString("error.server.connection.with.details", errorMessage));
                }
                Stage dialogStage = (Stage)alert.getDialogPane().getScene().getWindow();
                dialogStage.getIcons().add((Object)this.icon);
                dialogStage.initOwner((Window)this.getStage());
                alert.showAndWait();
                this.alertIsShowing = false;
            });
        }
    }

    public void refreshAllTabs() {
        this.homeController.refresh();
        this.paymentController.refresh();
        this.categoryController.refresh();
        if (this.tabCharts.isSelected()) {
            this.chartController.refresh();
        }
        if (this.tabReports.isSelected()) {
            this.reportController.refresh();
        }
    }

    public ArrayList<CategoryBudget> getCategoryBudgets() {
        return this.categoryBudgets;
    }

    public PaymentHandler getPaymentHandler() {
        return this.paymentHandler;
    }

    public CategoryHandler getCategoryHandler() {
        return this.categoryHandler;
    }

    public FilterSettings getFilterSettings() {
        return this.filterSettings;
    }

    public Updater getUpdater() {
        return this.updater;
    }

    public SettingsController getSettingsController() {
        return this.settingsController;
    }

    public void setFilterSettings(FilterSettings filterSettings) {
        this.filterSettings = filterSettings;
    }

    public void toggleAllTabsExceptSettings(boolean disable) {
        this.tabHome.setDisable(disable);
        this.tabPayments.setDisable(disable);
        this.tabCategories.setDisable(disable);
        this.tabCharts.setDisable(disable);
        this.tabReports.setDisable(disable);
        this.buttonLeft.setDisable(disable);
        this.buttonRight.setDisable(disable);
        this.buttonToday.setDisable(disable);
        this.buttonDate.setDisable(disable);
    }

    public void setSelectedPayment(Payment payment) {
        this.selectedPayment = payment;
    }

    public Payment getSelectedPayment() {
        return this.selectedPayment;
    }

    public SearchPreferences getSearchPreferences() {
        return this.searchPreferences;
    }

    public void setSearchPreferences(SearchPreferences searchPreferences) {
        this.searchPreferences = searchPreferences;
    }

    public PaymentController getPaymentController() {
        return this.paymentController;
    }

    public void checkForUpdates(boolean showNotification) {
        try {
            boolean updateAvailable = this.updater.isUpdateAvailable(Integer.parseInt(Localization.getString("version.code")));
            if (!updateAvailable) {
                if (showNotification) {
                    this.showNotification(Localization.getString("notification.no.update.available"));
                }
                return;
            }
            Platform.runLater(() -> this.showUpdateAlert());
        }
        catch (Exception e) {
            Logger.error(e);
            AlertGenerator.showAlert(Alert.AlertType.ERROR, Localization.getString("title.error"), "", Localization.getString("error.updater.get.latest.version"), this.icon, null, null, true);
        }
    }

    private void showUpdateAlert() {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle(Localization.getString("info.title.update.available"));
        alert.setHeaderText("");
        Stage dialogStage = (Stage)alert.getDialogPane().getScene().getWindow();
        dialogStage.getIcons().add((Object)this.icon);
        Hyperlink linkText = new Hyperlink(Localization.getString("info.text.update.available.show.changes"));
        linkText.setOnAction(event -> {
            if (Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().browse(new URI(Localization.getString("roadmap.url")));
                }
                catch (IOException | URISyntaxException e) {
                    Logger.error(e);
                    AlertGenerator.showAlert(Alert.AlertType.ERROR, Localization.getString("title.error"), "", Localization.getString("error.open.browser"), this.icon, (Window)this.getStage(), null, false);
                }
            }
        });
        Hyperlink detailedMilestones = new Hyperlink(Localization.getString("info.text.update.available.show.changes.detailed"));
        detailedMilestones.setOnAction(event -> {
            if (Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().browse(new URI(Localization.getString("github.url")));
                }
                catch (IOException | URISyntaxException e) {
                    Logger.error(e);
                    AlertGenerator.showAlert(Alert.AlertType.ERROR, Localization.getString("title.error"), "", Localization.getString("error.open.browser"), this.icon, (Window)this.getStage(), null, false);
                }
            }
        });
        TextFlow textFlow = new TextFlow(new Node[]{new Text(Localization.getString("info.text.update.available", this.updater.getLatestVersion().getVersionName())), linkText, new Text("\n\n"), detailedMilestones});
        alert.getDialogPane().setContent((Node)textFlow);
        ButtonType buttonTypeOne = new ButtonType(Localization.getString("info.text.update.available.now"));
        ButtonType buttonTypeTwo = new ButtonType(Localization.getString("cancel"));
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{buttonTypeOne, buttonTypeTwo});
        DialogPane dialogPane = alert.getDialogPane();
        dialogPane.getButtonTypes().stream().map(arg_0 -> ((DialogPane)dialogPane).lookupButton(arg_0)).forEach(button -> button.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.ENTER.equals((Object)event.getCode()) && event.getTarget() instanceof Button) {
                ((Button)event.getTarget()).fire();
            }
        }));
        Optional result = alert.showAndWait();
        if (result.get() == buttonTypeOne) {
            LoadingModal.showModal(this, Localization.getString("title.modal"), Localization.getString("load.update"), this.getStage(), this.icon);
            Worker.runLater(() -> {
                try {
                    this.updater.downloadLatestVersion();
                    Platform.runLater(() -> LoadingModal.closeModal());
                }
                catch (Exception ex) {
                    Logger.error(ex);
                    Platform.runLater(() -> {
                        LoadingModal.closeModal();
                        AlertGenerator.showAlert(Alert.AlertType.ERROR, Localization.getString("title.error"), "", Localization.getString("error.updater.download.latest.version", ex.getMessage()), this.icon, (Window)this.getStage(), null, true);
                    });
                }
            });
        } else {
            alert.close();
        }
    }

    private Label getLabelForAboutColumns(String text, boolean bold) {
        Label label = new Label(text);
        if (bold) {
            label.setStyle("-fx-font-size: 14; -fx-font-weight: bold;");
        } else {
            label.setStyle("-fx-font-size: 14;");
        }
        return label;
    }

    public void about() {
        Alert alert = new Alert(Alert.AlertType.NONE);
        alert.setTitle(Localization.getString("about", Localization.getString("app.name")));
        alert.setHeaderText("");
        Stage dialogStage = (Stage)alert.getDialogPane().getScene().getWindow();
        dialogStage.getIcons().add((Object)this.icon);
        Hyperlink roadmapLink = new Hyperlink(Localization.getString("about.roadmap.link"));
        roadmapLink.setFont(new Font(14.0));
        roadmapLink.setPadding(new Insets(0.0));
        roadmapLink.setOnAction(event -> {
            if (Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().browse(new URI(Localization.getString("roadmap.url")));
                }
                catch (IOException | URISyntaxException e) {
                    Logger.error(e);
                    AlertGenerator.showAlert(Alert.AlertType.ERROR, Localization.getString("title.error"), "", Localization.getString("error.open.browser"), this.icon, (Window)this.getStage(), null, false);
                }
            }
        });
        Hyperlink githubLink = new Hyperlink(Localization.getString("github.url"));
        githubLink.setFont(new Font(14.0));
        githubLink.setPadding(new Insets(0.0));
        githubLink.setOnAction(event -> {
            if (Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().browse(new URI(Localization.getString("github.url")));
                }
                catch (IOException | URISyntaxException e) {
                    Logger.error(e);
                    AlertGenerator.showAlert(Alert.AlertType.ERROR, Localization.getString("title.error"), "", Localization.getString("error.open.browser"), this.icon, (Window)this.getStage(), null, false);
                }
            }
        });
        VBox vbox = new VBox();
        vbox.setSpacing(10.0);
        HBox hboxLogo = new HBox();
        hboxLogo.setSpacing(25.0);
        ImageView imageViewLogo = new ImageView(this.icon);
        imageViewLogo.setFitHeight(75.0);
        imageViewLogo.setFitWidth(75.0);
        hboxLogo.getChildren().add((Object)imageViewLogo);
        Label labelName = new Label(Localization.getString("about", Localization.getString("app.name")));
        labelName.setStyle("-fx-font-weight: bold; -fx-font-size: 22;");
        labelName.setMaxWidth(Double.MAX_VALUE);
        hboxLogo.getChildren().add((Object)labelName);
        HBox.setHgrow((Node)labelName, (Priority)Priority.ALWAYS);
        hboxLogo.setAlignment(Pos.CENTER);
        vbox.getChildren().add((Object)hboxLogo);
        HBox hboxColumns = new HBox();
        VBox vboxLeft = new VBox();
        vboxLeft.setSpacing(7.0);
        VBox vboxRight = new VBox();
        vboxRight.setSpacing(7.0);
        vboxLeft.getChildren().add((Object)this.getLabelForAboutColumns(Localization.getString("about.version"), true));
        vboxLeft.getChildren().add((Object)this.getLabelForAboutColumns(Localization.getString("about.date"), true));
        vboxLeft.getChildren().add((Object)this.getLabelForAboutColumns(Localization.getString("about.author"), true));
        vboxLeft.getChildren().add((Object)this.getLabelForAboutColumns(Localization.getString("about.roadmap"), true));
        Label labelSourceCode = this.getLabelForAboutColumns(Localization.getString("about.sourcecode"), true);
        vboxLeft.getChildren().add((Object)labelSourceCode);
        VBox.setMargin((Node)labelSourceCode, (Insets)new Insets(2.0, 0.0, 0.0, 0.0));
        vboxLeft.getChildren().add((Object)this.getLabelForAboutColumns(Localization.getString("about.credits"), true));
        vboxRight.getChildren().add((Object)this.getLabelForAboutColumns(Localization.getString("version.name") + " (" + Localization.getString("version.code") + ")", false));
        vboxRight.getChildren().add((Object)this.getLabelForAboutColumns(Localization.getString("version.date"), false));
        vboxRight.getChildren().add((Object)this.getLabelForAboutColumns(Localization.getString("author"), false));
        vboxRight.getChildren().add((Object)roadmapLink);
        vboxRight.getChildren().add((Object)githubLink);
        VBox vboxCredits = new VBox();
        for (String line : Localization.getString("credits").split("\n")) {
            vboxCredits.getChildren().add((Object)this.getLabelForAboutColumns(line, false));
        }
        vboxRight.getChildren().add((Object)vboxCredits);
        vboxLeft.setMinWidth(100.0);
        hboxColumns.getChildren().addAll((Object[])new Node[]{vboxLeft, vboxRight});
        HBox.setHgrow((Node)vboxLeft, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)vboxRight, (Priority)Priority.ALWAYS);
        vbox.getChildren().add((Object)hboxColumns);
        alert.getDialogPane().setContent((Node)vbox);
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{new ButtonType(Localization.getString("ok"))});
        DialogPane dialogPane = alert.getDialogPane();
        dialogPane.getButtonTypes().stream().map(arg_0 -> ((DialogPane)dialogPane).lookupButton(arg_0)).forEach(button -> button.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.ENTER.equals((Object)event.getCode()) && event.getTarget() instanceof Button) {
                ((Button)event.getTarget()).fire();
            }
        }));
        alert.showAndWait();
    }

    public void refresh(FilterSettings newFilterSettings) {
        Logger.debug("Starting main refresh...");
        Platform.runLater(() -> LoadingModal.showModal(this, Localization.getString("title.modal"), Localization.getString("load.data"), this.getStage(), this.icon));
        Worker.runLater(() -> {
            try {
                ServerConnection connection = new ServerConnection(this.settings);
                try {
                    Logger.debug("Checking server compatibility...");
                    VersionInformation serverVersion = connection.getServerVersion();
                    if (serverVersion.getVersionCode() < Integer.parseInt(Localization.getString("version.code"))) {
                        Logger.debug("Server (versionCode: " + serverVersion.getVersionCode() + ") is incompatible with client (versionCode: " + Localization.getString("version.code") + ")");
                        if (this.settings.getServerType().equals((Object)ServerType.ONLINE)) {
                            Platform.runLater(() -> {
                                AlertGenerator.showAlert(Alert.AlertType.WARNING, Localization.getString("title.warning"), "", Localization.getString("warning.server.version", serverVersion.getVersionName(), Localization.getString("version.name")), this.icon, (Window)this.getStage(), null, false);
                                LoadingModal.closeModal();
                                this.categoryHandler = new CategoryHandler(null);
                                this.toggleAllTabsExceptSettings(true);
                                this.tabPane.getSelectionModel().select((Object)this.tabSettings);
                            });
                        } else {
                            Platform.runLater(() -> {
                                LoadingModal.closeModal();
                                this.categoryHandler = new CategoryHandler(null);
                                this.toggleAllTabsExceptSettings(true);
                                this.tabPane.getSelectionModel().select((Object)this.tabSettings);
                                ((LocalServerSettingsController)this.settingsController).handleIncompatibleServer();
                            });
                        }
                        return;
                    }
                    Logger.debug("Found compatible server (versionCode: " + serverVersion.getVersionCode() + ")");
                }
                catch (Exception e1) {
                    Logger.error(e1);
                    Platform.runLater(() -> LoadingModal.closeModal());
                    if (e1.getMessage().contains("404")) {
                        Logger.debug("Server version is incompatible with current client version (" + Localization.getString("version.code") + ")");
                        Platform.runLater(() -> {
                            AlertGenerator.showAlert(Alert.AlertType.WARNING, Localization.getString("title.warning"), "", Localization.getString("warning.server.version", Localization.getString("undefined"), Localization.getString("version.name")), this.icon, (Window)this.getStage(), null, false);
                            this.categoryHandler = new CategoryHandler(null);
                            this.toggleAllTabsExceptSettings(true);
                            this.tabPane.getSelectionModel().select((Object)this.tabSettings);
                        });
                    } else {
                        this.showConnectionErrorAlert(ExceptionHandler.getMessageForException(e1));
                    }
                    return;
                }
                Logger.debug("Connected");
                this.paymentHandler = new PaymentHandler();
                this.paymentHandler.getPayments().addAll(connection.getPayments(this.currentDate.getYear(), this.currentDate.getMonthOfYear()));
                this.paymentHandler.getPayments().addAll(connection.getRepeatingPayments(this.currentDate.getYear(), this.currentDate.getMonthOfYear()));
                this.paymentHandler.sort();
                if (this.settings.isRestActivated()) {
                    int rest = connection.getRestForAllPreviousMonths(this.currentDate.getYear(), this.currentDate.getMonthOfYear());
                    this.paymentHandler.getPayments().add(new NormalPayment(-1, rest, this.currentDate.withDayOfMonth(1).toString("yyyy-MM-dd"), 2, Localization.getString("category.rest"), ""));
                }
                this.categoryHandler = new CategoryHandler(connection.getCategories());
                this.categoryBudgets = connection.getCategoryBudgets(this.currentDate.getYear(), this.currentDate.getMonthOfYear());
                this.paymentHandler.filter(newFilterSettings, new TagHandler(this.settings));
                Logger.debug("Main refresh done");
                Platform.runLater(() -> {
                    LoadingModal.closeModal();
                    this.toggleAllTabsExceptSettings(false);
                    this.refreshAllTabs();
                });
            }
            catch (Exception e) {
                Logger.error(e);
                Platform.runLater(() -> {
                    LoadingModal.closeModal();
                    this.categoryHandler = new CategoryHandler(null);
                    this.showConnectionErrorAlert(ExceptionHandler.getMessageForException(e));
                    this.refreshAllTabs();
                });
            }
        });
    }

    private /* synthetic */ void lambda$init$1(KeyCombination keyCombinationSearch, KeyEvent event) {
        if (event.getCode().toString().equals(Localization.getString("shortcut.dev.console"))) {
            try {
                this.cmd.showCommandLine("Dev Console", 400.0, 250.0, 400.0, 200.0, -1.0, -1.0, true);
            }
            catch (IOException e) {
                Logger.error("Error opening dev console");
                Logger.error(e);
            }
        } else if (keyCombinationSearch.match(event) && !this.tabPayments.isDisabled()) {
            this.tabPane.getSelectionModel().select((Object)this.tabPayments);
            this.paymentController.search();
        }
    }
}

