/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.ui.controller;

import de.deadlocker8.budgetmaster.logic.utils.Colors;
import de.deadlocker8.budgetmaster.logic.utils.Helpers;
import de.deadlocker8.budgetmasterclient.ui.Styleable;
import de.deadlocker8.budgetmasterclient.ui.controller.BaseController;
import de.deadlocker8.budgetmasterclient.ui.controller.Controller;
import fontAwesome.FontIcon;
import fontAwesome.FontIconType;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.paint.Color;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import tools.AlertGenerator;
import tools.ConvertTo;
import tools.Localization;

public class DatePickerController
extends BaseController
implements Styleable {
    @FXML
    private ComboBox<String> comboBoxMonth;
    @FXML
    private Spinner<Integer> spinnerYear;
    @FXML
    private Button buttonCancel;
    @FXML
    private Button buttonConfirm;
    private Stage parentStage;
    private Controller controller;
    private DateTime currentDate;

    public DatePickerController(Stage parentStage, Controller controller, DateTime currentDate) {
        this.parentStage = parentStage;
        this.controller = controller;
        this.currentDate = currentDate;
        this.load("/de/deadlocker8/budgetmaster/ui/fxml/DatePickerGUI.fxml", Localization.getBundle());
        this.getStage().showAndWait();
    }

    @Override
    public void initStage(Stage stage) {
        stage.initOwner((Window)this.parentStage);
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.setTitle(Localization.getString("title.datepicker"));
        stage.getIcons().add((Object)this.controller.getIcon());
        stage.setResizable(false);
    }

    @Override
    public void init() {
        SpinnerValueFactory.IntegerSpinnerValueFactory spinnerYearValueFactory = new SpinnerValueFactory.IntegerSpinnerValueFactory(1, 3000, this.currentDate.getYear());
        this.spinnerYear.setValueFactory((SpinnerValueFactory)spinnerYearValueFactory);
        this.spinnerYear.setEditable(false);
        this.spinnerYear.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.spinnerYear.increment(0);
            }
        });
        this.comboBoxMonth.getItems().addAll(Helpers.getMonthList());
        this.comboBoxMonth.setValue((Object)Helpers.getMonthList().get(this.currentDate.getMonthOfYear() - 1));
        this.applyStyle();
    }

    public void confirm() {
        String year = String.valueOf(this.spinnerYear.getValue());
        if (year == null || year.equals("")) {
            AlertGenerator.showAlert(Alert.AlertType.WARNING, Localization.getString("title.warning"), "", Localization.getString("warning.empty.year"), this.controller.getIcon(), (Window)this.getStage(), null, false);
            return;
        }
        if (year.length() > 4) {
            AlertGenerator.showAlert(Alert.AlertType.WARNING, Localization.getString("title.warning"), "", Localization.getString("warning.wrong.year"), this.controller.getIcon(), (Window)this.getStage(), null, false);
            return;
        }
        String dateString = year + "-" + (Helpers.getMonthList().indexOf(this.comboBoxMonth.getValue()) + 1);
        DateTime newDate = DateTime.parse(dateString, DateTimeFormat.forPattern("YYYY-MM"));
        this.getStage().close();
        this.controller.setDate(newDate);
    }

    public void cancel() {
        this.getStage().close();
    }

    @Override
    public void applyStyle() {
        this.buttonCancel.setGraphic((Node)new FontIcon(FontIconType.TIMES, 17, Color.WHITE));
        this.buttonConfirm.setGraphic((Node)new FontIcon(FontIconType.SAVE, 17, Color.WHITE));
        this.buttonCancel.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 15;");
        this.buttonConfirm.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 15;");
    }
}

