/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.ui.controller;

import de.deadlocker8.budgetmaster.logic.category.Category;
import de.deadlocker8.budgetmaster.logic.payment.NormalPayment;
import de.deadlocker8.budgetmaster.logic.payment.Payment;
import de.deadlocker8.budgetmaster.logic.payment.RepeatingPayment;
import de.deadlocker8.budgetmaster.logic.payment.RepeatingPaymentEntry;
import de.deadlocker8.budgetmaster.logic.serverconnection.ExceptionHandler;
import de.deadlocker8.budgetmaster.logic.serverconnection.ServerConnection;
import de.deadlocker8.budgetmaster.logic.serverconnection.ServerTagConnection;
import de.deadlocker8.budgetmaster.logic.tag.Tag;
import de.deadlocker8.budgetmaster.logic.utils.Colors;
import de.deadlocker8.budgetmaster.logic.utils.Helpers;
import de.deadlocker8.budgetmasterclient.ui.Styleable;
import de.deadlocker8.budgetmasterclient.ui.cells.ButtonCategoryCell;
import de.deadlocker8.budgetmasterclient.ui.cells.RepeatingDayCell;
import de.deadlocker8.budgetmasterclient.ui.cells.SmallCategoryCell;
import de.deadlocker8.budgetmasterclient.ui.controller.BaseController;
import de.deadlocker8.budgetmasterclient.ui.controller.Controller;
import de.deadlocker8.budgetmasterclient.ui.controller.PaymentController;
import de.deadlocker8.budgetmasterclient.ui.tagField.TagField;
import fontAwesome.FontIcon;
import fontAwesome.FontIconType;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.ArrayList;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DateCell;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import logger.Logger;
import org.joda.time.DateTime;
import tools.AlertGenerator;
import tools.ConvertTo;
import tools.Localization;

public class NewPaymentController
extends BaseController
implements Styleable {
    @FXML
    private ScrollPane scrollPane;
    @FXML
    private VBox vboxContent;
    @FXML
    private TextField textFieldName;
    @FXML
    private TextField textFieldAmount;
    @FXML
    private Button buttonCancel;
    @FXML
    private Button buttonSave;
    @FXML
    private ComboBox<Category> comboBoxCategory;
    @FXML
    private DatePicker datePicker;
    @FXML
    private DatePicker datePickerEnddate;
    @FXML
    private Spinner<Integer> spinnerRepeatingPeriod;
    @FXML
    private ComboBox<Integer> comboBoxRepeatingDay;
    @FXML
    private CheckBox checkBoxRepeat;
    @FXML
    private RadioButton radioButtonPeriod;
    @FXML
    private RadioButton radioButtonDay;
    @FXML
    private Label labelText1;
    @FXML
    private Label labelText2;
    @FXML
    private Label labelText3;
    @FXML
    private TextArea textArea;
    @FXML
    private HBox hboxTags;
    @FXML
    private Button buttonTagsHelp;
    @FXML
    private CheckBox checkBoxEndDate;
    private Stage parentStage;
    private Controller controller;
    private PaymentController paymentController;
    private boolean isPayment;
    private boolean edit;
    private Payment payment;
    private ButtonCategoryCell buttonCategoryCell;
    private TagField tagField;
    private ArrayList<Tag> previousTags;

    public NewPaymentController(Stage parentStage, Controller controller, PaymentController paymentController, boolean isPayment, boolean edit, Payment payment) {
        this.parentStage = parentStage;
        this.controller = controller;
        this.paymentController = paymentController;
        this.isPayment = isPayment;
        this.edit = edit;
        this.payment = payment;
        this.load("/de/deadlocker8/budgetmaster/ui/fxml/NewPaymentGUI.fxml", Localization.getBundle());
        this.getStage().showAndWait();
    }

    @Override
    public void initStage(Stage stage) {
        String titlePart;
        stage.initOwner((Window)this.parentStage);
        stage.initModality(Modality.APPLICATION_MODAL);
        String string = titlePart = this.isPayment ? Localization.getString("title.payment") : Localization.getString("title.income");
        if (this.edit) {
            stage.setTitle(Localization.getString("title.payment.edit", titlePart));
        } else {
            stage.setTitle(Localization.getString("title.payment.new", titlePart));
        }
        stage.getIcons().add((Object)this.controller.getIcon());
        stage.setResizable(true);
        stage.setMinHeight(600.0);
        stage.setMinWidth(450.0);
        stage.getScene().getStylesheets().add((Object)"/de/deadlocker8/budgetmaster/ui/style.css");
    }

    @Override
    public void init() {
        this.vboxContent.prefWidthProperty().bind((ObservableValue)this.scrollPane.widthProperty().subtract(25));
        this.vboxContent.prefHeightProperty().bind((ObservableValue)this.scrollPane.heightProperty().subtract(10));
        this.applyStyle();
        this.tagField = new TagField(new ArrayList<Tag>(), new ArrayList<Tag>(), this);
        this.hboxTags.getChildren().add((Object)this.tagField);
        this.tagField.maxWidthProperty().bind((ObservableValue)this.hboxTags.widthProperty());
        HBox.setHgrow((Node)this.tagField, (Priority)Priority.ALWAYS);
        this.previousTags = new ArrayList();
        this.initRepeatingArea();
        if (this.edit) {
            this.prefill();
        } else {
            this.comboBoxCategory.setValue((Object)this.controller.getCategoryHandler().getCategory(1));
            this.checkBoxRepeat.setSelected(false);
            this.radioButtonPeriod.setSelected(true);
            this.toggleRepeatingArea(false);
            DateTime currentDate = this.controller.getCurrentDate();
            if (DateTime.now().getDayOfMonth() > currentDate.dayOfMonth().withMaximumValue().getDayOfMonth()) {
                currentDate = currentDate.dayOfMonth().withMaximumValue();
            }
            LocalDate currentLocalDate = LocalDate.now().withYear(currentDate.getYear()).withMonth(currentDate.getMonthOfYear()).withDayOfMonth(currentDate.getDayOfMonth());
            this.datePicker.setValue((Object)currentLocalDate);
            this.datePickerEnddate.setValue((Object)currentLocalDate);
            try {
                ServerTagConnection serverTagConnection = new ServerTagConnection(this.controller.getSettings());
                this.tagField.setAllTags(serverTagConnection.getTags());
            }
            catch (Exception e) {
                Logger.error(e);
                this.controller.showConnectionErrorAlert(ExceptionHandler.getMessageForException(e));
            }
        }
        this.datePicker.setEditable(false);
    }

    public Controller getController() {
        return this.controller;
    }

    private void initComboBoxCategory() {
        this.buttonCategoryCell = new ButtonCategoryCell(Color.WHITE);
        this.comboBoxCategory.setButtonCell((ListCell)this.buttonCategoryCell);
        this.comboBoxCategory.setStyle("-fx-border-color: #000000; -fx-border-width: 2; -fx-border-radius: 5; -fx-background-radius: 5;");
        this.comboBoxCategory.valueProperty().addListener((listener, oldValue, newValue) -> {
            this.comboBoxCategory.setStyle("-fx-background-color: " + newValue.getColor() + "; -fx-border-color: #000000; -fx-border-width: 2; -fx-border-radius: 5; -fx-background-radius: 5;");
            this.buttonCategoryCell.setColor(Color.web((String)newValue.getColor()));
        });
        this.comboBoxCategory.setCellFactory(view -> new SmallCategoryCell());
        this.comboBoxCategory.getItems().clear();
        try {
            ServerConnection connection = new ServerConnection(this.controller.getSettings());
            ArrayList<Category> categories = connection.getCategories();
            if (categories != null) {
                for (Category currentCategory : categories) {
                    if (currentCategory.getID() == 2) continue;
                    this.comboBoxCategory.getItems().add((Object)currentCategory);
                }
            }
        }
        catch (Exception e) {
            this.controller.showConnectionErrorAlert(ExceptionHandler.getMessageForException(e));
            this.getStage().close();
            return;
        }
    }

    private void initRepeatingArea() {
        this.checkBoxRepeat.selectedProperty().addListener((listener, oldValue, newValue) -> this.toggleRepeatingArea((boolean)newValue));
        this.initSpinnerRepeatingPeriod();
        this.initComboBoxRepeatingDay();
        this.initComboBoxCategory();
        ToggleGroup toggleGroup = new ToggleGroup();
        this.radioButtonPeriod.setToggleGroup(toggleGroup);
        this.radioButtonDay.setToggleGroup(toggleGroup);
        this.radioButtonPeriod.selectedProperty().addListener((listener, oldValue, newValue) -> this.toggleRadioButtonPeriod((boolean)newValue));
        this.datePickerEnddate.setDayCellFactory(p -> new DateCell(){

            public void updateItem(LocalDate ld, boolean bln) {
                super.updateItem(ld, bln);
                if (NewPaymentController.this.datePicker.getValue() != null && ld.isBefore((ChronoLocalDate)NewPaymentController.this.datePicker.getValue())) {
                    this.setDisable(true);
                    this.setStyle("-fx-background-color: #ffc0cb;");
                }
            }
        });
        this.checkBoxEndDate.selectedProperty().addListener((obs, oldValue, newValue) -> this.datePickerEnddate.setDisable(newValue == false));
    }

    private void initSpinnerRepeatingPeriod() {
        SpinnerValueFactory.IntegerSpinnerValueFactory valueFactory = new SpinnerValueFactory.IntegerSpinnerValueFactory(1, 1000, 0);
        this.spinnerRepeatingPeriod.setValueFactory((SpinnerValueFactory)valueFactory);
        this.spinnerRepeatingPeriod.setEditable(false);
        this.spinnerRepeatingPeriod.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.spinnerRepeatingPeriod.increment(0);
            }
        });
    }

    private void initComboBoxRepeatingDay() {
        this.comboBoxRepeatingDay.setCellFactory(view -> new RepeatingDayCell());
        ArrayList<Integer> days = new ArrayList<Integer>();
        for (int i = 1; i <= 31; ++i) {
            days.add(i);
        }
        this.comboBoxRepeatingDay.getItems().addAll(days);
        this.comboBoxRepeatingDay.setValue((Object)1);
    }

    private void prefill() {
        block9: {
            this.textFieldName.setText(this.payment.getName());
            this.textFieldAmount.setText(Helpers.NUMBER_FORMAT.format(Math.abs((double)this.payment.getAmount() / 100.0)).replace(".", ","));
            this.comboBoxCategory.setValue((Object)this.controller.getCategoryHandler().getCategory(this.payment.getCategoryID()));
            this.datePicker.setValue((Object)LocalDate.parse(this.payment.getDate()));
            this.textArea.setText(this.payment.getDescription());
            try {
                ServerTagConnection serverTagConnection = new ServerTagConnection(this.controller.getSettings());
                this.tagField.setAllTags(serverTagConnection.getTags());
                if (this.payment instanceof RepeatingPayment) {
                    RepeatingPayment tempPayment = (RepeatingPayment)this.payment;
                    this.payment = new RepeatingPaymentEntry(-1, tempPayment.getID(), tempPayment.getDate(), tempPayment.getAmount(), tempPayment.getCategoryID(), tempPayment.getName(), tempPayment.getDescription(), tempPayment.getRepeatInterval(), tempPayment.getRepeatEndDate(), tempPayment.getRepeatMonthDay());
                }
                if (this.payment instanceof RepeatingPaymentEntry) {
                    try {
                        RepeatingPaymentEntry currentPayment = (RepeatingPaymentEntry)this.payment;
                        this.previousTags = serverTagConnection.getAllTagsForRepeatingPayment(currentPayment.getRepeatingPaymentID());
                        this.tagField.setTags(new ArrayList<Tag>(this.previousTags));
                        ServerConnection connection = new ServerConnection(this.controller.getSettings());
                        RepeatingPayment repeatingPayment = connection.getRepeatingPayment(currentPayment.getRepeatingPaymentID());
                        this.datePicker.setValue((Object)LocalDate.parse(repeatingPayment.getDate()));
                        if (currentPayment.getRepeatInterval() != 0) {
                            this.checkBoxRepeat.setSelected(true);
                            this.radioButtonPeriod.setSelected(true);
                            this.toggleRepeatingArea(true);
                            this.spinnerRepeatingPeriod.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(0, 1000, currentPayment.getRepeatInterval()));
                        } else {
                            this.checkBoxRepeat.setSelected(true);
                            this.radioButtonDay.setSelected(true);
                            this.toggleRepeatingArea(true);
                            this.comboBoxRepeatingDay.getSelectionModel().select(currentPayment.getRepeatMonthDay() - 1);
                        }
                        this.checkBoxEndDate.setSelected(currentPayment.getRepeatEndDate() != null);
                        if (currentPayment.getRepeatEndDate() != null) {
                            this.datePickerEnddate.setValue((Object)LocalDate.parse(currentPayment.getRepeatEndDate()));
                        }
                        break block9;
                    }
                    catch (Exception e) {
                        Logger.error(e);
                        this.controller.showConnectionErrorAlert(ExceptionHandler.getMessageForException(e));
                    }
                    break block9;
                }
                this.previousTags = serverTagConnection.getAllTagsForPayment((NormalPayment)this.payment);
                this.tagField.setTags(new ArrayList<Tag>(this.previousTags));
                this.checkBoxRepeat.setSelected(false);
                this.radioButtonPeriod.setSelected(true);
                this.toggleRepeatingArea(false);
            }
            catch (Exception e) {
                Logger.error(e);
                this.controller.showConnectionErrorAlert(ExceptionHandler.getMessageForException(e));
            }
        }
    }

    private void showWarning(String message) {
        AlertGenerator.showAlert(Alert.AlertType.WARNING, Localization.getString("title.warning"), "", message, this.controller.getIcon(), (Window)this.controller.getStage(), null, false);
    }

    @FXML
    public void save() {
        Payment finalPayment;
        String description;
        String name = this.textFieldName.getText();
        if (name == null || name.equals("")) {
            this.showWarning(Localization.getString("warning.empty.payment.name"));
            return;
        }
        if (name.length() > 150) {
            this.showWarning(Localization.getString("warning.name.character.limit.reached.150"));
            return;
        }
        String amountText = this.textFieldAmount.getText();
        if (!amountText.matches("^-?\\d+(,\\d+)?(\\.\\d+)?$")) {
            this.showWarning(Localization.getString("warning.payment.amount"));
            return;
        }
        LocalDate date = (LocalDate)this.datePicker.getValue();
        if (date == null) {
            this.showWarning(Localization.getString("warning.empty.payment.date"));
            return;
        }
        int amount = 0;
        amount = new BigDecimal(amountText.replace(",", ".")).multiply(new BigDecimal(100)).toBigInteger().intValue();
        if (this.isPayment) {
            amount = -amount;
        }
        if ((description = this.textArea.getText()) != null) {
            if (description.length() > 200) {
                this.showWarning(Localization.getString("warning.description.character.limit.reached.150"));
                return;
            }
        } else {
            description = "";
        }
        int repeatingInterval = 0;
        int repeatingDay = 0;
        if (this.checkBoxRepeat.isSelected()) {
            LocalDate endDate;
            if (this.radioButtonPeriod.isSelected()) {
                repeatingInterval = (Integer)this.spinnerRepeatingPeriod.getValue();
            } else {
                repeatingDay = (Integer)this.comboBoxRepeatingDay.getValue();
            }
            if (repeatingInterval == 0 && repeatingDay == 0) {
                this.showWarning(Localization.getString("warning.payment.repeating"));
                return;
            }
            if (this.checkBoxEndDate.isSelected() && this.datePickerEnddate.getValue() != null && ((LocalDate)this.datePickerEnddate.getValue()).isBefore(date)) {
                this.showWarning(Localization.getString("warning.enddate.before.startdate"));
                return;
            }
            if (this.edit) {
                try {
                    endDate = this.checkBoxEndDate.isSelected() ? (LocalDate)this.datePickerEnddate.getValue() : null;
                    RepeatingPayment newPayment = new RepeatingPayment(-1, amount, Helpers.getDateString(date), ((Category)this.comboBoxCategory.getValue()).getID(), name, description, repeatingInterval, Helpers.getDateString(endDate), repeatingDay);
                    ServerConnection connection = new ServerConnection(this.controller.getSettings());
                    if (this.payment instanceof NormalPayment) {
                        connection.deleteNormalPayment((NormalPayment)this.payment);
                    } else {
                        connection.deleteRepeatingPayment((RepeatingPaymentEntry)this.payment);
                    }
                    int id = connection.addRepeatingPayment(newPayment);
                    finalPayment = newPayment;
                    this.previousTags = new ArrayList();
                    finalPayment.setID(id);
                }
                catch (Exception e) {
                    Logger.error(e);
                    this.controller.showConnectionErrorAlert(ExceptionHandler.getMessageForException(e));
                    this.getStage().close();
                    return;
                }
            } else {
                endDate = this.checkBoxEndDate.isSelected() ? (LocalDate)this.datePickerEnddate.getValue() : null;
                RepeatingPayment newPayment = new RepeatingPayment(-1, amount, Helpers.getDateString(date), ((Category)this.comboBoxCategory.getValue()).getID(), name, description, repeatingInterval, Helpers.getDateString(endDate), repeatingDay);
                try {
                    ServerConnection connection = new ServerConnection(this.controller.getSettings());
                    int id = connection.addRepeatingPayment(newPayment);
                    finalPayment = newPayment;
                    finalPayment.setID(id);
                }
                catch (Exception e) {
                    Logger.error(e);
                    this.controller.showConnectionErrorAlert(e.getMessage());
                    this.getStage().close();
                    return;
                }
            }
        } else {
            NormalPayment newPayment;
            if (this.edit) {
                newPayment = new NormalPayment(this.payment.getID(), amount, Helpers.getDateString(date), ((Category)this.comboBoxCategory.getValue()).getID(), name, description);
                int id = this.payment.getID();
                try {
                    ServerConnection connection = new ServerConnection(this.controller.getSettings());
                    if (this.payment instanceof RepeatingPaymentEntry) {
                        connection.deleteRepeatingPayment((RepeatingPaymentEntry)this.payment);
                        id = connection.addNormalPayment(newPayment);
                    } else {
                        connection.updateNormalPayment(newPayment);
                    }
                    finalPayment = newPayment;
                    finalPayment.setID(id);
                }
                catch (Exception e) {
                    Logger.error(e);
                    this.controller.showConnectionErrorAlert(e.getMessage());
                    this.getStage().close();
                    return;
                }
            }
            newPayment = new NormalPayment(-1, amount, Helpers.getDateString(date), ((Category)this.comboBoxCategory.getValue()).getID(), name, description);
            try {
                ServerConnection connection = new ServerConnection(this.controller.getSettings());
                int id = connection.addNormalPayment(newPayment);
                finalPayment = newPayment;
                finalPayment.setID(id);
            }
            catch (Exception e) {
                Logger.error(e);
                this.controller.showConnectionErrorAlert(e.getMessage());
                this.getStage().close();
                return;
            }
        }
        try {
            this.saveTags(this.tagField.getTags(), finalPayment);
        }
        catch (Exception e) {
            Logger.error(e);
            this.controller.showConnectionErrorAlert(e.getMessage());
        }
        this.getStage().close();
        this.paymentController.getController().refresh(this.controller.getFilterSettings());
    }

    public void cancel() {
        this.getStage().close();
    }

    @FXML
    public void showTagsHelp() {
        AlertGenerator.showAlert(Alert.AlertType.INFORMATION, Localization.getString("title.tags"), "", Localization.getString("info.tags"), this.controller.getIcon(), (Window)this.getStage(), null, false);
    }

    private void toggleRepeatingArea(boolean selected) {
        if (selected) {
            if (this.radioButtonPeriod.isSelected()) {
                this.spinnerRepeatingPeriod.setDisable(false);
                this.comboBoxRepeatingDay.setDisable(true);
            } else {
                this.spinnerRepeatingPeriod.setDisable(true);
                this.comboBoxRepeatingDay.setDisable(false);
            }
        } else {
            this.spinnerRepeatingPeriod.setDisable(!selected);
            this.comboBoxRepeatingDay.setDisable(!selected);
        }
        this.checkBoxEndDate.setDisable(!selected);
        this.datePickerEnddate.setDisable(!selected || !this.checkBoxEndDate.isSelected());
        this.radioButtonPeriod.setDisable(!selected);
        this.radioButtonDay.setDisable(!selected);
        this.labelText1.setDisable(!selected);
        this.labelText2.setDisable(!selected);
        this.labelText3.setDisable(!selected);
    }

    private void toggleRadioButtonPeriod(boolean selected) {
        this.spinnerRepeatingPeriod.setDisable(!selected);
        this.labelText1.setDisable(!selected);
        this.labelText2.setDisable(!selected);
        this.comboBoxRepeatingDay.setDisable(selected);
        this.labelText3.setDisable(selected);
    }

    private boolean tagListContainsTag(ArrayList<Tag> tags, String name) {
        for (Tag paymentTag : tags) {
            if (!name.equals(paymentTag.getName())) continue;
            return true;
        }
        return false;
    }

    private void saveTags(ArrayList<Tag> tags, Payment payment) throws Exception {
        ServerTagConnection serverTagConnection = new ServerTagConnection(this.controller.getSettings());
        for (Tag currentTag : this.previousTags) {
            if (this.tagListContainsTag(tags, currentTag.getName())) continue;
            if (payment instanceof RepeatingPayment) {
                RepeatingPayment repeatingPayment = (RepeatingPayment)payment;
                serverTagConnection.deleteTagMatchForRepeatingPayment(currentTag.getID(), repeatingPayment);
                continue;
            }
            NormalPayment normalPayment = (NormalPayment)payment;
            serverTagConnection.deleteTagMatchForPayment(currentTag.getID(), normalPayment);
        }
        for (Tag paymentTag : tags) {
            if (this.tagListContainsTag(this.previousTags, paymentTag.getName())) continue;
            String name = paymentTag.getName();
            Tag existingTag = serverTagConnection.getTag(name);
            if (existingTag == null) {
                serverTagConnection.addTag(new Tag(-1, name));
                existingTag = serverTagConnection.getTag(name);
            }
            if (payment instanceof RepeatingPayment) {
                RepeatingPayment repeatingPayment = (RepeatingPayment)payment;
                serverTagConnection.addTagMatchForRepeatingPayment(existingTag.getID(), repeatingPayment);
                continue;
            }
            NormalPayment normalPayment = (NormalPayment)payment;
            serverTagConnection.addTagMatchForPayment(existingTag.getID(), normalPayment);
        }
    }

    @Override
    public void applyStyle() {
        this.buttonTagsHelp.setGraphic((Node)new FontIcon(FontIconType.QUESTION, 13, Colors.TEXT));
        this.buttonCancel.setGraphic((Node)new FontIcon(FontIconType.TIMES, 17, Color.WHITE));
        this.buttonSave.setGraphic((Node)new FontIcon(FontIconType.SAVE, 17, Color.WHITE));
        this.scrollPane.setStyle("-fx-background-color: transparent");
        this.buttonTagsHelp.setStyle("-fx-background-color: transparent; -fx-border-radius: 50%; -fx-border-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.TEXT));
        this.buttonTagsHelp.getStyleClass().add((Object)"button-hoverable");
        this.buttonTagsHelp.setPrefWidth(18.0);
        this.buttonTagsHelp.setPrefHeight(18.0);
        this.buttonTagsHelp.setPadding(new Insets(0.0));
        this.buttonCancel.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 15;");
        this.buttonSave.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 15;");
    }
}

