/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.ui.controller;

import de.deadlocker8.budgetmaster.logic.Budget;
import de.deadlocker8.budgetmaster.logic.FilterSettings;
import de.deadlocker8.budgetmaster.logic.comparators.DateComparator;
import de.deadlocker8.budgetmaster.logic.comparators.RatingComparator;
import de.deadlocker8.budgetmaster.logic.payment.Payment;
import de.deadlocker8.budgetmaster.logic.payment.RepeatingPaymentEntry;
import de.deadlocker8.budgetmaster.logic.report.ColumnFilter;
import de.deadlocker8.budgetmaster.logic.report.ColumnOrder;
import de.deadlocker8.budgetmaster.logic.report.ColumnType;
import de.deadlocker8.budgetmaster.logic.report.ReportGenerator;
import de.deadlocker8.budgetmaster.logic.report.ReportItem;
import de.deadlocker8.budgetmaster.logic.report.ReportPreferences;
import de.deadlocker8.budgetmaster.logic.report.ReportSorting;
import de.deadlocker8.budgetmaster.logic.serverconnection.ExceptionHandler;
import de.deadlocker8.budgetmaster.logic.tag.TagHandler;
import de.deadlocker8.budgetmaster.logic.utils.Colors;
import de.deadlocker8.budgetmaster.logic.utils.Helpers;
import de.deadlocker8.budgetmasterclient.ui.Refreshable;
import de.deadlocker8.budgetmasterclient.ui.Styleable;
import de.deadlocker8.budgetmasterclient.ui.cells.report.table.ReportTableRatingCell;
import de.deadlocker8.budgetmasterclient.ui.cells.report.table.ReportTableRepeatingCell;
import de.deadlocker8.budgetmasterclient.ui.controller.Controller;
import de.deadlocker8.budgetmasterclient.ui.controller.FilterController;
import de.deadlocker8.budgetmasterclient.utils.LoadingModal;
import fontAwesome.FontIcon;
import fontAwesome.FontIconType;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import logger.Logger;
import org.joda.time.DateTime;
import tools.AlertGenerator;
import tools.ConvertTo;
import tools.Localization;
import tools.ObjectJSONHandler;
import tools.Worker;

public class ReportController
implements Refreshable,
Styleable {
    @FXML
    private AnchorPane anchorPaneMain;
    @FXML
    private Label labelPayments;
    @FXML
    private Label labelFilterActive;
    @FXML
    private CheckBox checkBoxIncludeBudget;
    @FXML
    private CheckBox checkBoxSplitTable;
    @FXML
    private CheckBox checkBoxIncludeCategoryBudgets;
    @FXML
    private Button buttonFilter;
    @FXML
    private Button buttonGenerate;
    @FXML
    private TableView<ReportItem> tableView;
    private Controller controller;
    private ColumnFilter columnFilter;
    private String initialReportFileName;
    private ReportPreferences reportPreferences;
    private TableColumn<ReportItem, Integer> columnPosition;
    private TableColumn<ReportItem, String> columnDate;
    private TableColumn<ReportItem, Boolean> columnIsRepeating;
    private TableColumn<ReportItem, String> columnCategory;
    private TableColumn<ReportItem, Integer> columnName;
    private TableColumn<ReportItem, String> columnDescription;
    private TableColumn<ReportItem, String> columnTags;
    private TableColumn<ReportItem, Integer> columnRating;
    private TableColumn<ReportItem, String> columnAmount;

    public void init(Controller controller) {
        this.controller = controller;
        this.initTable();
        this.applyStyle();
        this.applyReportPreferences();
    }

    private void initColumn(ColumnType columnType, boolean activated, TableColumn.SortType sortType) {
        switch (columnType) {
            case AMOUNT: {
                this.initColumnAmount(activated);
                this.toggleColumn(this.columnAmount, activated);
                if (sortType == null) break;
                this.columnAmount.setSortType(sortType);
                this.tableView.getSortOrder().add(this.columnAmount);
                break;
            }
            case CATEGORY: {
                this.initColumnCategory(activated);
                this.toggleColumn(this.columnCategory, activated);
                if (sortType == null) break;
                this.columnCategory.setSortType(sortType);
                this.tableView.getSortOrder().add(this.columnCategory);
                break;
            }
            case DATE: {
                this.initColumnDate(activated);
                this.toggleColumn(this.columnDate, activated);
                if (sortType == null) break;
                this.columnDate.setSortType(sortType);
                this.tableView.getSortOrder().add(this.columnDate);
                break;
            }
            case DESCRIPTION: {
                this.initColumnDescription(activated);
                this.toggleColumn(this.columnDescription, activated);
                if (sortType == null) break;
                this.columnDescription.setSortType(sortType);
                this.tableView.getSortOrder().add(this.columnDescription);
                break;
            }
            case NAME: {
                this.initColumnName(activated);
                this.toggleColumn(this.columnName, activated);
                if (sortType == null) break;
                this.columnName.setSortType(sortType);
                this.tableView.getSortOrder().add(this.columnName);
                break;
            }
            case POSITION: {
                this.initColumnPosition(activated);
                this.toggleColumn(this.columnPosition, activated);
                if (sortType == null) break;
                this.columnPosition.setSortType(sortType);
                this.tableView.getSortOrder().add(this.columnPosition);
                break;
            }
            case RATING: {
                this.initColumnRating(activated);
                this.toggleColumn(this.columnRating, activated);
                if (sortType == null) break;
                this.columnRating.setSortType(sortType);
                this.tableView.getSortOrder().add(this.columnRating);
                break;
            }
            case REPEATING: {
                this.initColumnIsRepeating(activated);
                this.toggleColumn(this.columnIsRepeating, activated);
                if (sortType == null) break;
                this.columnIsRepeating.setSortType(sortType);
                this.tableView.getSortOrder().add(this.columnIsRepeating);
                break;
            }
            case TAGS: {
                this.initColumnTags(activated);
                this.toggleColumn(this.columnTags, activated);
                if (sortType == null) break;
                this.columnTags.setSortType(sortType);
                this.tableView.getSortOrder().add(this.columnTags);
                break;
            }
        }
    }

    private void applyReportPreferences() {
        this.tableView.getColumns().clear();
        Object loadedObject = ObjectJSONHandler.loadObjectFromJSON(Localization.getString("folder"), "reportPreferences", new ReportPreferences());
        if (loadedObject != null) {
            this.reportPreferences = (ReportPreferences)loadedObject;
            this.checkBoxIncludeBudget.setSelected(this.reportPreferences.isIncludeBudget());
            this.checkBoxSplitTable.setSelected(this.reportPreferences.isSplitTable());
            this.checkBoxIncludeCategoryBudgets.setSelected(this.reportPreferences.isIncludeCategoryBudgets());
            ReportSorting reportSorting = this.reportPreferences.getReportSorting();
            ArrayList<ColumnType> allColumns = new ArrayList<ColumnType>(Arrays.asList(ColumnType.values()));
            for (ColumnType currentType : this.reportPreferences.getColumnOrder().getColumns()) {
                if (currentType == reportSorting.getColumnType()) {
                    this.initColumn(currentType, true, reportSorting.getSortType());
                } else {
                    this.initColumn(currentType, true, null);
                }
                allColumns.remove((Object)currentType);
            }
            for (ColumnType currentColumn : allColumns) {
                this.initColumn(currentColumn, false, null);
            }
        } else {
            for (ColumnType currentType : ColumnType.values()) {
                this.initColumn(currentType, true, null);
            }
        }
    }

    private void initColumnPosition(boolean activated) {
        this.columnPosition = new TableColumn();
        this.columnPosition.setUserData((Object)ColumnType.POSITION);
        this.columnPosition.setCellValueFactory((Callback)new PropertyValueFactory("position"));
        this.columnPosition.setStyle("-fx-alignment: CENTER;");
        HBox hboxColumnPosition = new HBox();
        hboxColumnPosition.setAlignment(Pos.CENTER);
        hboxColumnPosition.setSpacing(3.0);
        CheckBox checkBoxPositions = new CheckBox();
        hboxColumnPosition.getChildren().add((Object)checkBoxPositions);
        Label labelColumnPosition = new Label(Localization.getString("report.position"));
        hboxColumnPosition.getChildren().add((Object)labelColumnPosition);
        checkBoxPositions.selectedProperty().addListener((a, b, c) -> this.toggleColumn(this.columnPosition, (boolean)c));
        checkBoxPositions.setSelected(activated);
        this.columnPosition.setGraphic((Node)hboxColumnPosition);
        this.tableView.getColumns().add(this.columnPosition);
    }

    private void initColumnDate(boolean activated) {
        this.columnDate = new TableColumn();
        this.columnDate.setUserData((Object)ColumnType.DATE);
        this.columnDate.setCellValueFactory(param -> {
            String dateString = ((ReportItem)param.getValue()).getDate();
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                Date date = format.parse(dateString);
                SimpleDateFormat finalFormat = new SimpleDateFormat("dd.MM.yy");
                dateString = finalFormat.format(date);
                return new SimpleStringProperty(dateString);
            }
            catch (Exception e) {
                Logger.error(e);
                return null;
            }
        });
        this.columnDate.setStyle("-fx-alignment: CENTER;");
        HBox hboxColumnDate = new HBox();
        hboxColumnDate.setAlignment(Pos.CENTER);
        hboxColumnDate.setSpacing(3.0);
        CheckBox checkBoxDate = new CheckBox();
        hboxColumnDate.getChildren().add((Object)checkBoxDate);
        Label labelComlumnDate = new Label(Localization.getString("report.date"));
        hboxColumnDate.getChildren().add((Object)labelComlumnDate);
        checkBoxDate.selectedProperty().addListener((a, b, c) -> this.toggleColumn(this.columnDate, (boolean)c));
        checkBoxDate.setSelected(activated);
        this.columnDate.setGraphic((Node)hboxColumnDate);
        this.columnDate.setComparator((Comparator)new DateComparator());
        this.tableView.getColumns().add(this.columnDate);
    }

    private void initColumnIsRepeating(boolean activated) {
        this.columnIsRepeating = new TableColumn();
        this.columnIsRepeating.setUserData((Object)ColumnType.REPEATING);
        this.columnIsRepeating.setCellValueFactory((Callback)new PropertyValueFactory("repeating"));
        this.columnIsRepeating.setCellFactory(param -> new ReportTableRepeatingCell());
        this.columnIsRepeating.setStyle("-fx-alignment: CENTER;");
        HBox hboxColumnIsRepeating = new HBox();
        hboxColumnIsRepeating.setAlignment(Pos.CENTER);
        hboxColumnIsRepeating.setSpacing(3.0);
        CheckBox checkBoxRepeating = new CheckBox();
        hboxColumnIsRepeating.getChildren().add((Object)checkBoxRepeating);
        Label labelColumnIsRepeating = new Label(Localization.getString("report.repeating"));
        hboxColumnIsRepeating.getChildren().add((Object)labelColumnIsRepeating);
        checkBoxRepeating.selectedProperty().addListener((a, b, c) -> this.toggleColumn(this.columnIsRepeating, (boolean)c));
        checkBoxRepeating.setSelected(activated);
        this.columnIsRepeating.setGraphic((Node)hboxColumnIsRepeating);
        this.tableView.getColumns().add(this.columnIsRepeating);
    }

    private void initColumnCategory(boolean activated) {
        this.columnCategory = new TableColumn();
        this.columnCategory.setUserData((Object)ColumnType.CATEGORY);
        this.columnCategory.setCellValueFactory(param -> new SimpleStringProperty(((ReportItem)param.getValue()).getCategory().getName()));
        this.columnCategory.setStyle("-fx-alignment: CENTER;");
        HBox hboxColumnCategory = new HBox();
        hboxColumnCategory.setAlignment(Pos.CENTER);
        hboxColumnCategory.setSpacing(3.0);
        CheckBox checkBoxCategory = new CheckBox();
        hboxColumnCategory.getChildren().add((Object)checkBoxCategory);
        Label labelColumnCategory = new Label(Localization.getString("report.category"));
        hboxColumnCategory.getChildren().add((Object)labelColumnCategory);
        checkBoxCategory.selectedProperty().addListener((a, b, c) -> this.toggleColumn(this.columnCategory, (boolean)c));
        checkBoxCategory.setSelected(activated);
        this.columnCategory.setGraphic((Node)hboxColumnCategory);
        this.tableView.getColumns().add(this.columnCategory);
    }

    private void initColumnName(boolean activated) {
        this.columnName = new TableColumn();
        this.columnName.setUserData((Object)ColumnType.NAME);
        this.columnName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.columnName.setStyle("-fx-alignment: CENTER;");
        HBox hboxColumnName = new HBox();
        hboxColumnName.setAlignment(Pos.CENTER);
        hboxColumnName.setSpacing(3.0);
        CheckBox checkBoxName = new CheckBox();
        hboxColumnName.getChildren().add((Object)checkBoxName);
        Label labelColumnName = new Label(Localization.getString("report.name"));
        hboxColumnName.getChildren().add((Object)labelColumnName);
        checkBoxName.selectedProperty().addListener((a, b, c) -> this.toggleColumn(this.columnName, (boolean)c));
        checkBoxName.setSelected(activated);
        this.columnName.setGraphic((Node)hboxColumnName);
        this.tableView.getColumns().add(this.columnName);
    }

    private void initColumnDescription(boolean activated) {
        this.columnDescription = new TableColumn();
        this.columnDescription.setUserData((Object)ColumnType.DESCRIPTION);
        this.columnDescription.setCellValueFactory((Callback)new PropertyValueFactory("description"));
        this.columnDescription.setStyle("-fx-alignment: CENTER;");
        HBox hboxColumnDescription = new HBox();
        hboxColumnDescription.setAlignment(Pos.CENTER);
        hboxColumnDescription.setSpacing(3.0);
        CheckBox checkBoxDescription = new CheckBox();
        hboxColumnDescription.getChildren().add((Object)checkBoxDescription);
        Label labelColumnDescription = new Label(Localization.getString("report.description"));
        hboxColumnDescription.getChildren().add((Object)labelColumnDescription);
        checkBoxDescription.selectedProperty().addListener((a, b, c) -> this.toggleColumn(this.columnDescription, (boolean)c));
        checkBoxDescription.setSelected(activated);
        this.columnDescription.setGraphic((Node)hboxColumnDescription);
        this.tableView.getColumns().add(this.columnDescription);
    }

    private void initColumnTags(boolean activated) {
        this.columnTags = new TableColumn();
        this.columnTags.setUserData((Object)ColumnType.TAGS);
        this.columnTags.setCellValueFactory((Callback)new PropertyValueFactory("tags"));
        this.columnTags.setStyle("-fx-alignment: CENTER;");
        HBox hboxColumnTags = new HBox();
        hboxColumnTags.setAlignment(Pos.CENTER);
        hboxColumnTags.setSpacing(3.0);
        CheckBox checkBoxTags = new CheckBox();
        hboxColumnTags.getChildren().add((Object)checkBoxTags);
        Label labelColumnTags = new Label(Localization.getString("report.tags"));
        hboxColumnTags.getChildren().add((Object)labelColumnTags);
        checkBoxTags.selectedProperty().addListener((a, b, c) -> this.toggleColumn(this.columnTags, (boolean)c));
        checkBoxTags.setSelected(activated);
        this.columnTags.setGraphic((Node)hboxColumnTags);
        this.tableView.getColumns().add(this.columnTags);
    }

    private void initColumnRating(boolean activated) {
        this.columnRating = new TableColumn();
        this.columnRating.setUserData((Object)ColumnType.RATING);
        this.columnRating.setCellValueFactory((Callback)new PropertyValueFactory("amount"));
        this.columnRating.setCellFactory(param -> new ReportTableRatingCell());
        this.columnRating.setStyle("-fx-alignment: CENTER;");
        HBox hboxColumnRating = new HBox();
        hboxColumnRating.setAlignment(Pos.CENTER);
        hboxColumnRating.setSpacing(3.0);
        CheckBox checkBoxRating = new CheckBox();
        hboxColumnRating.getChildren().add((Object)checkBoxRating);
        Label labelColumnRating = new Label(Localization.getString("report.rating"));
        hboxColumnRating.getChildren().add((Object)labelColumnRating);
        checkBoxRating.selectedProperty().addListener((a, b, c) -> this.toggleColumn(this.columnRating, (boolean)c));
        checkBoxRating.setSelected(activated);
        this.columnRating.setGraphic((Node)hboxColumnRating);
        this.columnRating.setComparator((Comparator)new RatingComparator());
        this.tableView.getColumns().add(this.columnRating);
    }

    private void toggleColumn(TableColumn<ReportItem, ?> column, boolean activated) {
        String style = activated ? "" : "-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_REPORT_TABLE_HEADER_DISABLED);
        Node graphic = column.getGraphic();
        if (graphic != null) {
            graphic.setStyle(style);
        }
        this.columnFilter.toggleColumn((ColumnType)((Object)column.getUserData()), activated);
    }

    private void initColumnAmount(boolean activated) {
        this.columnAmount = new TableColumn();
        this.columnAmount.setUserData((Object)ColumnType.AMOUNT);
        this.columnAmount.setCellValueFactory(param -> {
            SimpleStringProperty value = new SimpleStringProperty();
            double amount = (double)((ReportItem)param.getValue()).getAmount() / 100.0;
            value.set((Object)Helpers.getCurrencyString(amount, this.controller.getSettings().getCurrency()));
            return value;
        });
        this.columnAmount.setStyle("-fx-alignment: CENTER;");
        HBox hboxColumnAmount = new HBox();
        hboxColumnAmount.setAlignment(Pos.CENTER);
        hboxColumnAmount.setSpacing(3.0);
        CheckBox checkBoxAmount = new CheckBox();
        hboxColumnAmount.getChildren().add((Object)checkBoxAmount);
        Label labelColumnAmount = new Label(Localization.getString("report.amount"));
        hboxColumnAmount.getChildren().add((Object)labelColumnAmount);
        checkBoxAmount.selectedProperty().addListener((a, b, c) -> this.toggleColumn(this.columnAmount, (boolean)c));
        checkBoxAmount.setSelected(activated);
        this.columnAmount.setGraphic((Node)hboxColumnAmount);
        this.tableView.getColumns().add(this.columnAmount);
    }

    private void initTable() {
        this.columnFilter = new ColumnFilter();
        for (ColumnType type : ColumnType.values()) {
            this.columnFilter.addColumn(type);
        }
        Label labelPlaceholder = new Label(Localization.getString("payments.placeholder"));
        labelPlaceholder.setStyle("-fx-font-size: 16");
        this.tableView.setPlaceholder((Node)labelPlaceholder);
        this.tableView.setFixedCellSize(26.0);
    }

    public void filter() {
        new FilterController(this.controller.getStage(), this.controller, this.controller.getFilterSettings());
    }

    private ArrayList<ReportItem> createReportItems(ArrayList<Payment> payments) {
        ArrayList<ReportItem> reportItems = new ArrayList<ReportItem>();
        TagHandler tagHander = new TagHandler(this.controller.getSettings());
        for (int i = 0; i < payments.size(); ++i) {
            Payment currentPayment = payments.get(i);
            ReportItem reportItem = new ReportItem();
            reportItem.setPosition(i + 1);
            reportItem.setDate(currentPayment.getDate());
            reportItem.setAmount(currentPayment.getAmount());
            reportItem.setName(currentPayment.getName());
            reportItem.setDescription(currentPayment.getDescription());
            reportItem.setRepeating(currentPayment instanceof RepeatingPaymentEntry);
            reportItem.setCategory(this.controller.getCategoryHandler().getCategory(currentPayment.getCategoryID()));
            try {
                reportItem.setTags(tagHander.getTagsAsString(currentPayment));
            }
            catch (Exception e) {
                Logger.error(e);
                this.controller.showConnectionErrorAlert(ExceptionHandler.getMessageForException(e));
            }
            reportItems.add(reportItem);
        }
        return reportItems;
    }

    private void refreshTableView() {
        Platform.runLater(() -> this.tableView.getItems().clear());
        ArrayList<Payment> payments = this.controller.getPaymentHandler().getPayments();
        if (payments != null) {
            ArrayList<ReportItem> reportItems = this.createReportItems(payments);
            Platform.runLater(() -> {
                ObservableList objectsForTable = FXCollections.observableArrayList((Collection)reportItems);
                this.tableView.setItems(objectsForTable);
            });
        }
    }

    private ReportPreferences getReportPreferences() {
        ColumnOrder columnOrder = new ColumnOrder();
        for (TableColumn currentColumn : this.tableView.getColumns()) {
            ColumnType currentType = (ColumnType)((Object)currentColumn.getUserData());
            if (!this.columnFilter.containsColumn(currentType)) continue;
            columnOrder.addColumn(currentType);
        }
        ReportSorting reportSorting = new ReportSorting();
        ObservableList sortOrder = this.tableView.getSortOrder();
        if (sortOrder.size() > 0) {
            reportSorting.setColumnType((ColumnType)((Object)((TableColumn)sortOrder.get(0)).getUserData()));
            reportSorting.setSortType(((TableColumn)sortOrder.get(0)).getSortType());
        } else {
            reportSorting.setColumnType(ColumnType.DATE);
            reportSorting.setSortType(TableColumn.SortType.DESCENDING);
        }
        String reportFolderPath = null;
        if (this.reportPreferences != null) {
            reportFolderPath = this.reportPreferences.getReportFolderPath();
        }
        return new ReportPreferences(columnOrder, this.checkBoxIncludeBudget.isSelected(), this.checkBoxSplitTable.isSelected(), this.checkBoxIncludeCategoryBudgets.isSelected(), reportSorting, reportFolderPath);
    }

    private void saveReportPreferences() {
        try {
            ObjectJSONHandler.saveObjectToJSON(Localization.getString("folder"), "reportPreferences", this.reportPreferences);
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    public void generate() {
        File file;
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(Localization.getString("title.report.save"));
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("PDF (*.pdf)", new String[]{"*.pdf"});
        fileChooser.setInitialFileName(this.initialReportFileName);
        fileChooser.getExtensionFilters().add((Object)extFilter);
        String initialReportFolder = this.reportPreferences.getReportFolderPath();
        if (initialReportFolder != null) {
            fileChooser.setInitialDirectory(new File(initialReportFolder));
        }
        if ((file = fileChooser.showSaveDialog((Window)this.controller.getStage())) != null) {
            Budget budget = new Budget(this.controller.getPaymentHandler().getPayments());
            this.reportPreferences = this.getReportPreferences();
            this.reportPreferences.setReportFolderPath(file.getParentFile().getAbsolutePath());
            this.saveReportPreferences();
            ReportGenerator reportGenerator = new ReportGenerator(new ArrayList<ReportItem>((Collection<ReportItem>)this.tableView.getItems()), this.controller.getCategoryBudgets(), this.reportPreferences, file, this.controller.getSettings().getCurrency(), this.controller.getCurrentDate(), budget);
            LoadingModal.showModal(this.controller, Localization.getString("title.modal"), Localization.getString("load.report"), this.controller.getStage(), this.controller.getIcon());
            Worker.runLater(() -> {
                try {
                    reportGenerator.generate();
                    Platform.runLater(() -> {
                        LoadingModal.closeModal();
                        this.controller.showNotification(Localization.getString("notification.report.save"));
                        Alert alert = new Alert(Alert.AlertType.INFORMATION);
                        alert.setTitle(Localization.getString("info.title.report.save"));
                        alert.setHeaderText("");
                        alert.initOwner((Window)this.controller.getStage());
                        alert.setContentText(Localization.getString("info.text.report.save"));
                        Stage dialogStage = (Stage)alert.getDialogPane().getScene().getWindow();
                        dialogStage.getIcons().add((Object)this.controller.getIcon());
                        ButtonType buttonTypeOne = new ButtonType(Localization.getString("info.text.report.save.open.folder"));
                        ButtonType buttonTypeTwo = new ButtonType(Localization.getString("info.text.report.save.open.report"));
                        ButtonType buttonTypeThree = new ButtonType(Localization.getString("ok"));
                        alert.getButtonTypes().setAll((Object[])new ButtonType[]{buttonTypeOne, buttonTypeTwo, buttonTypeThree});
                        DialogPane dialogPane = alert.getDialogPane();
                        dialogPane.getButtonTypes().stream().map(arg_0 -> ((DialogPane)dialogPane).lookupButton(arg_0)).forEach(button -> button.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
                            if (KeyCode.ENTER.equals((Object)event.getCode()) && event.getTarget() instanceof Button) {
                                ((Button)event.getTarget()).fire();
                            }
                        }));
                        Optional result = alert.showAndWait();
                        if (result.get() == buttonTypeOne) {
                            try {
                                Desktop.getDesktop().open(new File(file.getParent().replace("\\", "/")));
                            }
                            catch (IOException e1) {
                                Logger.error(e1);
                                AlertGenerator.showAlert(Alert.AlertType.ERROR, Localization.getString("title.error"), "", Localization.getString("error.open.folder", e1.getMessage()), this.controller.getIcon(), (Window)this.controller.getStage(), null, false);
                            }
                        } else if (result.get() == buttonTypeTwo) {
                            try {
                                Desktop.getDesktop().open(new File(file.getAbsolutePath().replace("\\", "/")));
                            }
                            catch (IOException e1) {
                                Logger.error(e1);
                                AlertGenerator.showAlert(Alert.AlertType.ERROR, Localization.getString("title.error"), "", Localization.getString("error.open.report", e1.getMessage()), this.controller.getIcon(), (Window)this.controller.getStage(), null, false);
                            }
                        } else {
                            alert.close();
                        }
                    });
                }
                catch (Exception e) {
                    Logger.error(e);
                    Platform.runLater(() -> {
                        LoadingModal.closeModal();
                        AlertGenerator.showAlert(Alert.AlertType.ERROR, Localization.getString("title.error"), "", Localization.getString("error.report.save", e.getMessage()), this.controller.getIcon(), (Window)this.controller.getStage(), null, false);
                    });
                }
            });
        }
    }

    public Controller getController() {
        return this.controller;
    }

    @Override
    public void refresh() {
        LoadingModal.showModal(this.controller, Localization.getString("title.modal"), Localization.getString("load.report.tab"), this.controller.getStage(), this.controller.getIcon());
        if (this.controller.getFilterSettings().equals(new FilterSettings())) {
            this.labelFilterActive.setVisible(false);
        } else {
            this.labelFilterActive.setVisible(true);
        }
        DateTime currentDate = this.controller.getCurrentDate();
        String currentMonth = currentDate.toString("MM");
        String currentYear = currentDate.toString("YYYY");
        this.initialReportFileName = Localization.getString("report.initial.filename", currentYear, currentMonth);
        this.reportPreferences = this.getReportPreferences();
        this.saveReportPreferences();
        Worker.runLater(() -> {
            this.refreshTableView();
            Platform.runLater(() -> {
                LoadingModal.closeModal();
                this.applyReportPreferences();
                this.tableView.refresh();
            });
        });
    }

    @Override
    public void applyStyle() {
        this.buttonFilter.setGraphic((Node)new FontIcon(FontIconType.FILTER, 18, Color.WHITE));
        this.buttonGenerate.setGraphic((Node)new FontIcon(FontIconType.COGS, 18, Color.WHITE));
        this.labelFilterActive.setGraphic((Node)new FontIcon(FontIconType.WARNING, 16, Colors.TEXT));
        this.anchorPaneMain.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND));
        this.labelFilterActive.setStyle("-fx-text-fill: " + ConvertTo.toRGBHexWithoutOpacity(Colors.TEXT));
        this.buttonFilter.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 16;");
        this.buttonGenerate.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 16;");
        this.checkBoxIncludeBudget.setStyle("-fx-text-fill: " + ConvertTo.toRGBHexWithoutOpacity(Colors.TEXT) + "; -fx-font-size: 14;");
        this.checkBoxSplitTable.setStyle("-fx-text-fill: " + ConvertTo.toRGBHexWithoutOpacity(Colors.TEXT) + "; -fx-font-size: 14;");
        this.checkBoxIncludeCategoryBudgets.setStyle("-fx-text-fill: " + ConvertTo.toRGBHexWithoutOpacity(Colors.TEXT) + "; -fx-font-size: 14;");
    }
}

