/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.ui.controller;

import de.deadlocker8.budgetmaster.logic.payment.Payment;
import de.deadlocker8.budgetmaster.logic.search.SearchPreferences;
import de.deadlocker8.budgetmaster.logic.serverconnection.ExceptionHandler;
import de.deadlocker8.budgetmaster.logic.serverconnection.ServerConnection;
import de.deadlocker8.budgetmaster.logic.utils.Colors;
import de.deadlocker8.budgetmasterclient.ui.Styleable;
import de.deadlocker8.budgetmasterclient.ui.cells.SearchCell;
import de.deadlocker8.budgetmasterclient.ui.controller.BaseController;
import de.deadlocker8.budgetmasterclient.ui.controller.Controller;
import de.deadlocker8.budgetmasterclient.utils.LoadingModal;
import fontAwesome.FontIcon;
import fontAwesome.FontIconType;
import java.util.ArrayList;
import java.util.Collection;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Color;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import logger.Logger;
import org.controlsfx.control.RangeSlider;
import tools.ConvertTo;
import tools.Localization;
import tools.Worker;

public class SearchController
extends BaseController
implements Styleable {
    @FXML
    private CheckBox checkBoxName;
    @FXML
    private CheckBox checkBoxDescription;
    @FXML
    private CheckBox checkBoxCategoryName;
    @FXML
    private CheckBox checkBoxTags;
    @FXML
    private TextField textFieldSearch;
    @FXML
    private CheckBox checkBoxSearchByAmount;
    @FXML
    private TextField textFieldAmountMin;
    @FXML
    private TextField textFieldAmountMax;
    @FXML
    private HBox hboxRangeSlider;
    @FXML
    private Label labelSeparator;
    @FXML
    private HBox hboxSearchByAmount;
    @FXML
    private Button buttonCancel;
    @FXML
    private Button buttonSearch;
    @FXML
    private ListView<Payment> listView;
    private Stage parentStage;
    private Controller controller;
    private RangeSlider rangeSlider;

    public SearchController(Stage parentStage, Controller controller) {
        this.parentStage = parentStage;
        this.controller = controller;
        this.load("/de/deadlocker8/budgetmaster/ui/fxml/SearchGUI.fxml", Localization.getBundle());
        this.getStage().showAndWait();
    }

    @Override
    public void initStage(Stage stage) {
        stage.initOwner((Window)this.parentStage);
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.setTitle(Localization.getString("title.search"));
        stage.getIcons().add((Object)this.controller.getIcon());
        stage.setResizable(true);
        stage.setMinWidth(500.0);
        stage.setMinHeight(500.0);
        stage.setWidth(650.0);
    }

    @Override
    public void init() {
        int maximum;
        final SearchController thisController = this;
        this.listView.setCellFactory((Callback)new Callback<ListView<Payment>, ListCell<Payment>>(){

            public ListCell<Payment> call(ListView<Payment> param) {
                SearchCell cell = new SearchCell(thisController);
                cell.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
                    if (event.getClickCount() == 2 && ((Payment)cell.getItem()).getCategoryID() != 2) {
                        SearchController.this.controller.getPaymentController().payment(!((Payment)cell.getItem()).isIncome(), true, (Payment)cell.getItem());
                        SearchController.this.search();
                    }
                });
                cell.prefWidthProperty().bind((ObservableValue)SearchController.this.listView.widthProperty().subtract(4));
                return cell;
            }
        });
        Label labelPlaceholder = new Label(Localization.getString("payments.placeholder"));
        labelPlaceholder.setStyle("-fx-font-size: 16");
        this.listView.setPlaceholder((Node)labelPlaceholder);
        this.listView.getSelectionModel().selectedIndexProperty().addListener((observable, oldValue, newValue) -> Platform.runLater(() -> this.listView.getSelectionModel().select(-1)));
        this.checkBoxName.setSelected(true);
        this.textFieldSearch.setOnKeyPressed(event -> {
            if (event.getCode().equals((Object)KeyCode.ENTER)) {
                this.search();
            }
        });
        this.checkBoxSearchByAmount.selectedProperty().addListener((a, b, c) -> this.hboxSearchByAmount.setDisable(c == false));
        this.hboxSearchByAmount.setDisable(true);
        try {
            maximum = this.getMaxAmountFromServer();
        }
        catch (Exception e) {
            Logger.error(e);
            this.controller.showConnectionErrorAlert(ExceptionHandler.getMessageForException(e));
            return;
        }
        this.rangeSlider = new RangeSlider();
        this.rangeSlider.setMin(0.0);
        this.rangeSlider.setMax(maximum);
        this.rangeSlider.setLowValue(this.rangeSlider.getMin());
        this.rangeSlider.setHighValue(this.rangeSlider.getMax());
        this.rangeSlider.setShowTickMarks(true);
        this.rangeSlider.setShowTickLabels(true);
        this.rangeSlider.setMajorTickUnit(this.getMayorTickUnit(maximum));
        this.rangeSlider.setMinorTickCount(0);
        this.rangeSlider.lowValueProperty().addListener((a, b, c) -> this.textFieldAmountMin.setText(String.valueOf(c.intValue())));
        this.rangeSlider.highValueProperty().addListener((a, b, c) -> this.textFieldAmountMax.setText(String.valueOf(c.intValue())));
        this.hboxRangeSlider.getChildren().add((Object)this.rangeSlider);
        this.hboxRangeSlider.setAlignment(Pos.CENTER);
        HBox.setHgrow((Node)this.rangeSlider, (Priority)Priority.ALWAYS);
        this.textFieldAmountMin.setTextFormatter(new TextFormatter(c -> {
            if (c.getControlNewText().isEmpty() || c.getControlNewText().matches("[0-9]*")) {
                return c;
            }
            return null;
        }));
        this.textFieldAmountMax.setTextFormatter(new TextFormatter(c -> {
            if (c.getControlNewText().isEmpty() || c.getControlNewText().matches("[0-9]*")) {
                return c;
            }
            return null;
        }));
        this.textFieldAmountMin.textProperty().addListener((a, b, c) -> this.setRangeSliderAmountMin());
        this.textFieldAmountMax.textProperty().addListener((a, b, c) -> this.setRangeSliderAmountMax());
        this.textFieldAmountMin.setText("0");
        this.textFieldAmountMax.setText(String.valueOf(maximum));
        SearchPreferences searchPreferences = this.controller.getSearchPreferences();
        if (this.controller.getSearchPreferences() != null) {
            this.textFieldSearch.setText(searchPreferences.getLastQuery());
            this.checkBoxName.setSelected(searchPreferences.isSearchName());
            this.checkBoxDescription.setSelected(searchPreferences.isSearchDescription());
            this.checkBoxCategoryName.setSelected(searchPreferences.isSearchCategorNames());
            this.checkBoxTags.setSelected(searchPreferences.isSearchTags());
            this.checkBoxSearchByAmount.setSelected(searchPreferences.isSearchAmount());
            this.rangeSlider.setLowValue(searchPreferences.getMinAmount());
            this.rangeSlider.setHighValue(searchPreferences.getMaxAmount());
        }
        this.applyStyle();
    }

    private void setRangeSliderAmountMin() {
        String text = this.textFieldAmountMin.getText();
        if (text != null && !text.equals("")) {
            this.rangeSlider.setLowValue(Integer.parseInt(text));
        }
    }

    private void setRangeSliderAmountMax() {
        String text = this.textFieldAmountMax.getText();
        if (text != null && !text.equals("")) {
            this.rangeSlider.setHighValue(Integer.parseInt(text));
        }
    }

    private int getMaxAmountFromServer() throws Exception {
        ServerConnection connection = new ServerConnection(this.controller.getSettings());
        return connection.getMaxAmount();
    }

    private int getMayorTickUnit(int maximum) {
        if (maximum < 10) {
            return 1;
        }
        if (maximum < 100) {
            return 5;
        }
        int length = String.valueOf(maximum).length();
        return (int)Math.pow(10.0, length - 2);
    }

    public void search() {
        String query = this.textFieldSearch.getText().trim();
        if (this.controller.getSearchPreferences() == null) {
            this.controller.setSearchPreferences(new SearchPreferences());
        }
        SearchPreferences searchPreferences = this.controller.getSearchPreferences();
        searchPreferences.setLastQuery(query);
        searchPreferences.setSearchName(this.checkBoxName.isSelected());
        searchPreferences.setSearchDescription(this.checkBoxDescription.isSelected());
        searchPreferences.setSearchCategorNames(this.checkBoxCategoryName.isSelected());
        searchPreferences.setSearchTags(this.checkBoxTags.isSelected());
        searchPreferences.setSearchAmount(this.checkBoxSearchByAmount.isSelected());
        searchPreferences.setMinAmount((int)this.rangeSlider.getLowValue());
        searchPreferences.setMaxAmount((int)this.rangeSlider.getHighValue());
        LoadingModal.showModal(this.controller, Localization.getString("title.modal"), Localization.getString("load.search"), this.getStage(), this.controller.getIcon());
        Worker.runLater(() -> {
            try {
                ServerConnection connection = new ServerConnection(this.controller.getSettings());
                ArrayList<Payment> payments = connection.getPaymentsForSearch(query, this.checkBoxName.isSelected(), this.checkBoxDescription.isSelected(), this.checkBoxCategoryName.isSelected(), this.checkBoxTags.isSelected(), this.checkBoxSearchByAmount.isSelected(), (int)this.rangeSlider.getLowValue() * 100, (int)this.rangeSlider.getHighValue() * 100);
                Platform.runLater(() -> {
                    this.listView.getItems().clear();
                    if (payments != null) {
                        this.listView.getItems().setAll((Collection)payments);
                    }
                    LoadingModal.closeModal();
                });
            }
            catch (Exception e) {
                Logger.error(e);
                Platform.runLater(() -> {
                    LoadingModal.closeModal();
                    this.controller.showConnectionErrorAlert(ExceptionHandler.getMessageForException(e));
                });
            }
        });
        this.textFieldSearch.requestFocus();
        this.textFieldSearch.positionCaret(this.textFieldSearch.getText().length());
    }

    public void cancel() {
        this.getStage().close();
    }

    public Controller getController() {
        return this.controller;
    }

    @Override
    public void applyStyle() {
        this.labelSeparator.setStyle("-fx-background-color: #CCCCCC;");
        this.labelSeparator.setMinHeight(1.0);
        this.labelSeparator.setMaxHeight(1.0);
        this.buttonCancel.setGraphic((Node)new FontIcon(FontIconType.TIMES, 17, Color.WHITE));
        this.buttonSearch.setGraphic((Node)new FontIcon(FontIconType.SEARCH, 17, Color.WHITE));
        this.buttonCancel.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 15;");
        this.buttonSearch.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 15;");
    }
}

