/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM.util;

import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.Dispatch;
import com.sun.jna.platform.win32.COM.DispatchListener;
import com.sun.jna.platform.win32.COM.IDispatch;
import com.sun.jna.platform.win32.COM.IDispatchCallback;
import com.sun.jna.platform.win32.COM.Unknown;
import com.sun.jna.platform.win32.COM.util.Convert;
import com.sun.jna.platform.win32.COM.util.Factory;
import com.sun.jna.platform.win32.COM.util.IComEventCallbackListener;
import com.sun.jna.platform.win32.COM.util.IUnknown;
import com.sun.jna.platform.win32.COM.util.annotation.ComEventCallback;
import com.sun.jna.platform.win32.COM.util.annotation.ComInterface;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.OaIdl;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.Variant;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinError;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class CallbackProxy
implements IDispatchCallback {
    Factory factory;
    Class<?> comEventCallbackInterface;
    IComEventCallbackListener comEventCallbackListener;
    Guid.GUID.ByValue listenedToRiid;
    public DispatchListener dispatchListener;
    Map<OaIdl.DISPID, Method> dsipIdMap;
    ExecutorService executorService;

    public CallbackProxy(Factory factory, Class<?> comEventCallbackInterface, IComEventCallbackListener comEventCallbackListener) {
        this.factory = factory;
        this.comEventCallbackInterface = comEventCallbackInterface;
        this.comEventCallbackListener = comEventCallbackListener;
        this.listenedToRiid = this.createRIID(comEventCallbackInterface);
        this.dsipIdMap = this.createDispIdMap(comEventCallbackInterface);
        this.dispatchListener = new DispatchListener(this);
        this.executorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "COM Event Callback executor");
                thread.setDaemon(true);
                thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread t, Throwable e) {
                        CallbackProxy.this.factory.comThread.uncaughtExceptionHandler.uncaughtException(t, e);
                    }
                });
                return thread;
            }
        });
    }

    Guid.GUID.ByValue createRIID(Class<?> comEventCallbackInterface) {
        ComInterface comInterfaceAnnotation = comEventCallbackInterface.getAnnotation(ComInterface.class);
        if (null == comInterfaceAnnotation) {
            throw new COMException("advise: Interface must define a value for either iid via the ComInterface annotation");
        }
        String iidStr = comInterfaceAnnotation.iid();
        if (null == iidStr || iidStr.isEmpty()) {
            throw new COMException("ComInterface must define a value for iid");
        }
        return new Guid.GUID.ByValue(new Guid.IID(iidStr).getPointer());
    }

    Map<OaIdl.DISPID, Method> createDispIdMap(Class<?> comEventCallbackInterface) {
        HashMap<OaIdl.DISPID, Method> map = new HashMap<OaIdl.DISPID, Method>();
        for (Method meth : comEventCallbackInterface.getMethods()) {
            ComEventCallback annotation = meth.getAnnotation(ComEventCallback.class);
            if (null == annotation) continue;
            int dispId = annotation.dispid();
            if (-1 == dispId) {
                dispId = this.fetchDispIdFromName(annotation);
            }
            map.put(new OaIdl.DISPID(dispId), meth);
        }
        return map;
    }

    int fetchDispIdFromName(ComEventCallback annotation) {
        return -1;
    }

    void invokeOnThread(final OaIdl.DISPID dispIdMember, Guid.GUID.ByValue riid, WinDef.LCID lcid, WinDef.WORD wFlags, OleAuto.DISPPARAMS.ByReference pDispParams) {
        ArrayList<Object> rjargs = new ArrayList<Object>();
        if (pDispParams.cArgs.intValue() > 0) {
            Variant.VariantArg.ByReference vargs = pDispParams.rgvarg;
            vargs.setArraySize(pDispParams.cArgs.intValue());
            for (Variant.VARIANT varg : vargs.variantArg) {
                Object jarg = Convert.toJavaObject(varg);
                if (jarg instanceof IDispatch) {
                    IDispatch dispatch = (IDispatch)jarg;
                    PointerByReference ppvObject = new PointerByReference();
                    Guid.IID iid = com.sun.jna.platform.win32.COM.IUnknown.IID_IUNKNOWN;
                    dispatch.QueryInterface(new Guid.GUID.ByValue(iid), ppvObject);
                    Unknown rawUnk = new Unknown(ppvObject.getValue());
                    long unknownId = Pointer.nativeValue(rawUnk.getPointer());
                    int n = rawUnk.Release();
                    IUnknown unk = this.factory.createProxy(IUnknown.class, unknownId, dispatch);
                    rjargs.add(unk);
                    continue;
                }
                rjargs.add(jarg);
            }
        }
        final ArrayList jargs = new ArrayList(rjargs);
        Runnable invokation = new Runnable(){

            @Override
            public void run() {
                try {
                    if (CallbackProxy.this.dsipIdMap.containsKey(dispIdMember)) {
                        Method eventMethod = CallbackProxy.this.dsipIdMap.get(dispIdMember);
                        if (eventMethod.getParameterTypes().length != jargs.size()) {
                            CallbackProxy.this.comEventCallbackListener.errorReceivingCallbackEvent("Trying to invoke method " + eventMethod + " with " + jargs.size() + " arguments", null);
                        } else {
                            try {
                                ArrayList<Object> margs = new ArrayList<Object>();
                                Class<?>[] params = eventMethod.getParameterTypes();
                                for (int i = 0; i < eventMethod.getParameterTypes().length; ++i) {
                                    Class<?> paramType = params[i];
                                    Object jobj = jargs.get(i);
                                    if (jobj != null && paramType.getAnnotation(ComInterface.class) != null) {
                                        if (jobj instanceof IUnknown) {
                                            IUnknown unk = (IUnknown)jobj;
                                            Object mobj = unk.queryInterface(paramType);
                                            margs.add(mobj);
                                            continue;
                                        }
                                        throw new RuntimeException("Cannot convert argument " + jobj.getClass() + " to ComInterface " + paramType);
                                    }
                                    margs.add(jobj);
                                }
                                eventMethod.invoke((Object)CallbackProxy.this.comEventCallbackListener, margs.toArray());
                            }
                            catch (Exception e) {
                                CallbackProxy.this.comEventCallbackListener.errorReceivingCallbackEvent("Exception invoking method " + eventMethod, e);
                            }
                        }
                    } else {
                        CallbackProxy.this.comEventCallbackListener.errorReceivingCallbackEvent("No method found with dispId = " + dispIdMember, null);
                    }
                }
                catch (Exception e) {
                    CallbackProxy.this.comEventCallbackListener.errorReceivingCallbackEvent("Exception receiving callback event ", e);
                }
            }
        };
        this.executorService.execute(invokation);
    }

    @Override
    public Pointer getPointer() {
        return this.dispatchListener.getPointer();
    }

    @Override
    public WinNT.HRESULT GetTypeInfoCount(WinDef.UINTByReference pctinfo) {
        return new WinNT.HRESULT(-2147467263);
    }

    @Override
    public WinNT.HRESULT GetTypeInfo(WinDef.UINT iTInfo, WinDef.LCID lcid, PointerByReference ppTInfo) {
        return new WinNT.HRESULT(-2147467263);
    }

    @Override
    public WinNT.HRESULT GetIDsOfNames(Guid.GUID.ByValue riid, WString[] rgszNames, int cNames, WinDef.LCID lcid, OaIdl.DISPIDByReference rgDispId) {
        return new WinNT.HRESULT(-2147467263);
    }

    @Override
    public WinNT.HRESULT Invoke(OaIdl.DISPID dispIdMember, Guid.GUID.ByValue riid, WinDef.LCID lcid, WinDef.WORD wFlags, OleAuto.DISPPARAMS.ByReference pDispParams, Variant.VARIANT.ByReference pVarResult, OaIdl.EXCEPINFO.ByReference pExcepInfo, IntByReference puArgErr) {
        this.invokeOnThread(dispIdMember, riid, lcid, wFlags, pDispParams);
        return WinError.S_OK;
    }

    @Override
    public WinNT.HRESULT QueryInterface(Guid.GUID.ByValue refid, PointerByReference ppvObject) {
        if (null == ppvObject) {
            return new WinNT.HRESULT(-2147467261);
        }
        if (refid.equals(this.listenedToRiid)) {
            ppvObject.setValue(this.getPointer());
            return WinError.S_OK;
        }
        if (new Guid.IID(refid.getPointer()).equals(Unknown.IID_IUNKNOWN)) {
            ppvObject.setValue(this.getPointer());
            return WinError.S_OK;
        }
        if (new Guid.IID(refid.getPointer()).equals(Dispatch.IID_IDISPATCH)) {
            ppvObject.setValue(this.getPointer());
            return WinError.S_OK;
        }
        return new WinNT.HRESULT(-2147467262);
    }

    @Override
    public int AddRef() {
        return 0;
    }

    @Override
    public int Release() {
        return 0;
    }
}

