/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmaster.logic.payment;

import de.deadlocker8.budgetmaster.logic.FilterSettings;
import de.deadlocker8.budgetmaster.logic.payment.NormalPayment;
import de.deadlocker8.budgetmaster.logic.payment.Payment;
import de.deadlocker8.budgetmaster.logic.payment.RepeatingPaymentEntry;
import de.deadlocker8.budgetmaster.logic.tag.TagHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.stream.Collectors;

public class PaymentHandler {
    private ArrayList<Payment> payments = new ArrayList();

    public ArrayList<Payment> getPayments() {
        return this.payments;
    }

    public void setPayments(ArrayList<Payment> payments) {
        this.payments = payments;
    }

    public int getPosition(Payment payment) {
        if (payment == null) {
            return -1;
        }
        for (int i = 0; i < this.payments.size(); ++i) {
            if (payment.getID() != this.payments.get(i).getID()) continue;
            return i;
        }
        return -1;
    }

    public void sort() {
        Collections.sort(this.payments, new Comparator<Payment>(){

            @Override
            public int compare(Payment payment1, Payment payment2) {
                return payment2.getDate().compareTo(payment1.getDate());
            }
        });
    }

    private ArrayList<Payment> filterByRepeating(FilterSettings filterSettings, ArrayList<Payment> paymentsList) {
        if (filterSettings.isNoRepeatingAllowed() && filterSettings.isMonthlyRepeatingAllowed() && filterSettings.isRepeatingEveryXDaysAllowed()) {
            return paymentsList;
        }
        ArrayList<Payment> filteredPayments = new ArrayList<Payment>();
        for (Payment currentPayment : paymentsList) {
            if (currentPayment instanceof NormalPayment || currentPayment.getID() == -1) {
                if (!filterSettings.isNoRepeatingAllowed()) continue;
                filteredPayments.add(currentPayment);
                continue;
            }
            RepeatingPaymentEntry repeatingPayment = (RepeatingPaymentEntry)currentPayment;
            if ((repeatingPayment.getRepeatInterval() == 0 || !filterSettings.isRepeatingEveryXDaysAllowed()) && (repeatingPayment.getRepeatMonthDay() == 0 || !filterSettings.isMonthlyRepeatingAllowed())) continue;
            filteredPayments.add(currentPayment);
        }
        return filteredPayments;
    }

    private ArrayList<Payment> filterByCategory(FilterSettings filterSettings, ArrayList<Payment> paymentsList) {
        if (filterSettings.getAllowedCategoryIDs() == null) {
            return paymentsList;
        }
        if (filterSettings.getAllowedCategoryIDs().size() == 0) {
            return new ArrayList<Payment>();
        }
        ArrayList<Payment> filteredPayments = new ArrayList<Payment>();
        for (Payment currentPayment : paymentsList) {
            if (!filterSettings.getAllowedCategoryIDs().contains(currentPayment.getCategoryID())) continue;
            filteredPayments.add(currentPayment);
        }
        return filteredPayments;
    }

    private ArrayList<Payment> filterByName(FilterSettings filterSettings, ArrayList<Payment> paymentsList) {
        if (filterSettings.getName() == null) {
            return paymentsList;
        }
        ArrayList<Payment> filteredPayments = new ArrayList<Payment>();
        for (Payment currentPayment : paymentsList) {
            if (!currentPayment.getName().toLowerCase().contains(filterSettings.getName().toLowerCase())) continue;
            filteredPayments.add(currentPayment);
        }
        return filteredPayments;
    }

    private ArrayList<Payment> filterByType(FilterSettings filterSettings, ArrayList<Payment> paymentsList) {
        if (filterSettings.isIncomeAllowed() && filterSettings.isPaymentAllowed()) {
            return paymentsList;
        }
        if (filterSettings.isIncomeAllowed()) {
            return new ArrayList<Payment>(paymentsList.stream().filter(p -> p.getAmount() > 0).collect(Collectors.toList()));
        }
        if (filterSettings.isPaymentAllowed()) {
            return new ArrayList<Payment>(paymentsList.stream().filter(p -> p.getAmount() < 0).collect(Collectors.toList()));
        }
        return new ArrayList<Payment>();
    }

    private ArrayList<Payment> filterByTag(FilterSettings filterSettings, ArrayList<Payment> paymentsList, TagHandler tagHandler) throws Exception {
        if (filterSettings.getAllowedTagIDs() == null) {
            return paymentsList;
        }
        if (filterSettings.getAllowedTagIDs().size() == 0) {
            return new ArrayList<Payment>();
        }
        ArrayList<Payment> filteredPayments = new ArrayList<Payment>();
        block0: for (Payment currentPayment : paymentsList) {
            ArrayList<Integer> paymentTagIDs = tagHandler.getTagIDs(currentPayment);
            for (Integer tagID : filterSettings.getAllowedTagIDs()) {
                if (!paymentTagIDs.contains(tagID)) continue;
                filteredPayments.add(currentPayment);
                continue block0;
            }
        }
        return filteredPayments;
    }

    public void filter(FilterSettings filterSettings, TagHandler tagHandler) throws Exception {
        ArrayList<Payment> filteredPayments = this.filterByType(filterSettings, this.payments);
        filteredPayments = this.filterByType(filterSettings, filteredPayments);
        filteredPayments = this.filterByRepeating(filterSettings, filteredPayments);
        filteredPayments = this.filterByCategory(filterSettings, filteredPayments);
        filteredPayments = this.filterByName(filterSettings, filteredPayments);
        filteredPayments = this.filterByTag(filterSettings, filteredPayments, tagHandler);
        this.payments = filteredPayments;
    }

    public String toString() {
        return "PaymentHandler [payments=" + this.payments + "]";
    }
}

