/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmaster.logic.serverconnection;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import de.deadlocker8.budgetmaster.logic.Settings;
import de.deadlocker8.budgetmaster.logic.category.Category;
import de.deadlocker8.budgetmaster.logic.category.CategoryBudget;
import de.deadlocker8.budgetmaster.logic.charts.CategoryInOutSum;
import de.deadlocker8.budgetmaster.logic.charts.MonthInOutSum;
import de.deadlocker8.budgetmaster.logic.database.Database;
import de.deadlocker8.budgetmaster.logic.payment.NormalPayment;
import de.deadlocker8.budgetmaster.logic.payment.Payment;
import de.deadlocker8.budgetmaster.logic.payment.PaymentJSONDeserializer;
import de.deadlocker8.budgetmaster.logic.payment.RepeatingPayment;
import de.deadlocker8.budgetmaster.logic.payment.RepeatingPaymentEntry;
import de.deadlocker8.budgetmaster.logic.serverconnection.ServerConnectionException;
import de.deadlocker8.budgetmaster.logic.serverconnection.ServerInformation;
import de.deadlocker8.budgetmaster.logic.updater.VersionInformation;
import de.deadlocker8.budgetmaster.logic.utils.Helpers;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.joda.time.DateTime;
import tools.Read;

public class ServerConnection {
    private Settings settings;
    private Gson gson;

    public ServerConnection(Settings settings) throws Exception {
        this.settings = settings;
        this.gson = new Gson();
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier((hostname, sslSession) -> settings.getTrustedHosts().contains(hostname));
    }

    public ArrayList<Category> getCategories() throws Exception {
        URL url = new URL(this.settings.getUrl() + "/category?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()));
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setDoOutput(true);
        httpsCon.setRequestMethod("GET");
        if (httpsCon.getResponseCode() == 200) {
            String result = Read.getStringFromInputStream(httpsCon.getInputStream());
            Type listType = new TypeToken<ArrayList<Category>>(){}.getType();
            return (ArrayList)this.gson.fromJson(result, listType);
        }
        return new ArrayList<Category>();
    }

    public Category getCategory(int ID) throws Exception {
        URL url = new URL(this.settings.getUrl() + "/category/single?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()) + "&id=" + ID);
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setDoOutput(true);
        httpsCon.setRequestMethod("GET");
        if (httpsCon.getResponseCode() == 200) {
            String result = Read.getStringFromInputStream(httpsCon.getInputStream());
            return this.gson.fromJson(result, Category.class);
        }
        return null;
    }

    public void addCategory(Category category) throws Exception {
        URL url = new URL(this.settings.getUrl() + "/category?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()) + "&name=" + Helpers.getURLEncodedString(category.getName()) + "&color=" + category.getColor().replace("#", ""));
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setRequestMethod("POST");
        httpsCon.setDoInput(true);
        if (httpsCon.getResponseCode() != 200) {
            throw new ServerConnectionException(String.valueOf(httpsCon.getResponseCode()));
        }
        InputStream stream = httpsCon.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        reader.close();
    }

    public void updateCategory(Category category) throws Exception {
        URL url = new URL(this.settings.getUrl() + "/category?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()) + "&id=" + category.getID() + "&name=" + Helpers.getURLEncodedString(category.getName()) + "&color=" + category.getColor().replace("#", ""));
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setRequestMethod("PUT");
        httpsCon.setDoInput(true);
        if (httpsCon.getResponseCode() != 200) {
            throw new ServerConnectionException(String.valueOf(httpsCon.getResponseCode()));
        }
        InputStream stream = httpsCon.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        reader.close();
    }

    public void deleteCategory(int ID) throws Exception {
        URL url = new URL(this.settings.getUrl() + "/category?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()) + "&id=" + ID);
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setRequestMethod("DELETE");
        httpsCon.setDoInput(true);
        if (httpsCon.getResponseCode() != 200) {
            throw new ServerConnectionException(String.valueOf(httpsCon.getResponseCode()));
        }
        InputStream stream = httpsCon.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        reader.close();
    }

    public ArrayList<NormalPayment> getPayments(int year, int month) throws Exception {
        URL url = new URL(this.settings.getUrl() + "/payment?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()) + "&year=" + year + "&month=" + month);
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setDoOutput(true);
        httpsCon.setRequestMethod("GET");
        if (httpsCon.getResponseCode() == 200) {
            String result = Read.getStringFromInputStream(httpsCon.getInputStream());
            Type listType = new TypeToken<ArrayList<NormalPayment>>(){}.getType();
            return (ArrayList)this.gson.fromJson(result, listType);
        }
        throw new ServerConnectionException(String.valueOf(httpsCon.getResponseCode()));
    }

    public ArrayList<RepeatingPaymentEntry> getRepeatingPayments(int year, int month) throws Exception {
        URL url = new URL(this.settings.getUrl() + "/repeatingpayment?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()) + "&year=" + year + "&month=" + month);
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setDoOutput(true);
        httpsCon.setRequestMethod("GET");
        if (httpsCon.getResponseCode() == 200) {
            String result = Read.getStringFromInputStream(httpsCon.getInputStream());
            Type listType = new TypeToken<ArrayList<RepeatingPaymentEntry>>(){}.getType();
            return (ArrayList)this.gson.fromJson(result, listType);
        }
        throw new ServerConnectionException(String.valueOf(httpsCon.getResponseCode()));
    }

    public RepeatingPayment getRepeatingPayment(int ID) throws Exception {
        URL url = new URL(this.settings.getUrl() + "/repeatingpayment/single?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()) + "&id=" + ID);
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setDoOutput(true);
        httpsCon.setRequestMethod("GET");
        if (httpsCon.getResponseCode() == 200) {
            String result = Read.getStringFromInputStream(httpsCon.getInputStream());
            return this.gson.fromJson(result, RepeatingPayment.class);
        }
        throw new ServerConnectionException(String.valueOf(httpsCon.getResponseCode()));
    }

    public Integer addNormalPayment(NormalPayment payment) throws Exception {
        URL url = new URL(this.settings.getUrl() + "/payment?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()) + "&amount=" + payment.getAmount() + "&date=" + payment.getDate() + "&categoryID=" + payment.getCategoryID() + "&name=" + Helpers.getURLEncodedString(payment.getName()) + "&description=" + Helpers.getURLEncodedString(payment.getDescription()));
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setRequestMethod("POST");
        httpsCon.setDoInput(true);
        if (httpsCon.getResponseCode() == 200) {
            String result = Read.getStringFromInputStream(httpsCon.getInputStream());
            return this.gson.fromJson(result, Integer.class);
        }
        throw new ServerConnectionException(String.valueOf(httpsCon.getResponseCode()));
    }

    public void updateNormalPayment(NormalPayment payment) throws Exception {
        URL url = new URL(this.settings.getUrl() + "/payment?secret=" + this.settings.getSecret() + "&id=" + payment.getID() + "&amount=" + payment.getAmount() + "&date=" + payment.getDate() + "&categoryID=" + payment.getCategoryID() + "&name=" + Helpers.getURLEncodedString(payment.getName()) + "&description=" + Helpers.getURLEncodedString(payment.getDescription()));
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setRequestMethod("PUT");
        httpsCon.setDoInput(true);
        if (httpsCon.getResponseCode() != 200) {
            throw new ServerConnectionException(String.valueOf(httpsCon.getResponseCode()));
        }
        InputStream stream = httpsCon.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        reader.close();
    }

    public Integer addRepeatingPayment(RepeatingPayment payment) throws Exception {
        String repeatEndDate = payment.getRepeatEndDate();
        if (repeatEndDate == null || repeatEndDate.equals("")) {
            repeatEndDate = "A";
        }
        URL url = new URL(this.settings.getUrl() + "/repeatingpayment?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()) + "&amount=" + payment.getAmount() + "&date=" + payment.getDate() + "&categoryID=" + payment.getCategoryID() + "&name=" + Helpers.getURLEncodedString(payment.getName()) + "&repeatInterval=" + payment.getRepeatInterval() + "&repeatEndDate=" + repeatEndDate + "&repeatMonthDay=" + payment.getRepeatMonthDay() + "&description=" + Helpers.getURLEncodedString(payment.getDescription()));
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setRequestMethod("POST");
        httpsCon.setDoInput(true);
        if (httpsCon.getResponseCode() == 200) {
            String result = Read.getStringFromInputStream(httpsCon.getInputStream());
            return this.gson.fromJson(result, Integer.class);
        }
        throw new ServerConnectionException(String.valueOf(httpsCon.getResponseCode()));
    }

    public void deleteNormalPayment(NormalPayment payment) throws Exception {
        URL url = new URL(this.settings.getUrl() + "/payment?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()) + "&id=" + payment.getID());
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setRequestMethod("DELETE");
        httpsCon.setDoInput(true);
        if (httpsCon.getResponseCode() != 200) {
            throw new ServerConnectionException(String.valueOf(httpsCon.getResponseCode()));
        }
        InputStream stream = httpsCon.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        reader.close();
    }

    public void deleteRepeatingPayment(RepeatingPaymentEntry payment) throws Exception {
        URL url = new URL(this.settings.getUrl() + "/repeatingpayment?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()) + "&id=" + payment.getRepeatingPaymentID());
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setRequestMethod("DELETE");
        httpsCon.setDoInput(true);
        if (httpsCon.getResponseCode() != 200) {
            throw new ServerConnectionException(String.valueOf(httpsCon.getResponseCode()));
        }
        InputStream stream = httpsCon.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        reader.close();
    }

    public ArrayList<Payment> getPaymentsForSearch(String query, boolean searchName, boolean searchDescription, boolean searchCategoryName, boolean searchTags, boolean searchAmount, int minAmount, int maxAmount) throws Exception {
        String urlString = this.settings.getUrl() + "/payment/search?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()) + "&query=" + Helpers.getURLEncodedString(query);
        if (searchName) {
            urlString = urlString + "&name=1";
        }
        if (searchDescription) {
            urlString = urlString + "&description=1";
        }
        if (searchCategoryName) {
            urlString = urlString + "&categoryName=1";
        }
        if (searchTags) {
            urlString = urlString + "&tags=1";
        }
        if (searchAmount) {
            urlString = urlString + "&minAmount=" + minAmount;
            urlString = urlString + "&maxAmount=" + maxAmount;
        }
        URL url = new URL(urlString);
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setDoOutput(true);
        httpsCon.setRequestMethod("GET");
        if (httpsCon.getResponseCode() == 200) {
            String result = Read.getStringFromInputStream(httpsCon.getInputStream());
            JsonParser parser = new JsonParser();
            JsonElement resultJSON = parser.parse(result);
            return PaymentJSONDeserializer.deserializePaymentList(resultJSON.getAsJsonObject().get("payments").getAsJsonArray());
        }
        throw new ServerConnectionException(String.valueOf(httpsCon.getResponseCode()));
    }

    public int getMaxAmount() throws Exception {
        URL url = new URL(this.settings.getUrl() + "/payment/search/maxAmount?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()));
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setDoOutput(true);
        httpsCon.setRequestMethod("GET");
        if (httpsCon.getResponseCode() == 200) {
            String result = Read.getStringFromInputStream(httpsCon.getInputStream());
            return this.gson.fromJson(result, Integer.class);
        }
        throw new ServerConnectionException(String.valueOf(httpsCon.getResponseCode()));
    }

    public ArrayList<CategoryBudget> getCategoryBudgets(int year, int month) throws Exception {
        URL url = new URL(this.settings.getUrl() + "/categorybudget?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()) + "&year=" + year + "&month=" + month);
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setDoOutput(true);
        httpsCon.setRequestMethod("GET");
        if (httpsCon.getResponseCode() == 200) {
            String result = Read.getStringFromInputStream(httpsCon.getInputStream());
            Type listType = new TypeToken<ArrayList<CategoryBudget>>(){}.getType();
            return (ArrayList)this.gson.fromJson(result, listType);
        }
        throw new ServerConnectionException(String.valueOf(httpsCon.getResponseCode()));
    }

    public int getRestForAllPreviousMonths(int year, int month) throws Exception {
        URL url = new URL(this.settings.getUrl() + "/rest?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()) + "&year=" + year + "&month=" + month);
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setDoOutput(true);
        httpsCon.setRequestMethod("GET");
        if (httpsCon.getResponseCode() == 200) {
            String result = Read.getStringFromInputStream(httpsCon.getInputStream());
            return this.gson.fromJson(result, Integer.class);
        }
        throw new ServerConnectionException(String.valueOf(httpsCon.getResponseCode()));
    }

    public void deleteDatabase() throws Exception {
        URL url = new URL(this.settings.getUrl() + "/database?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()));
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setRequestMethod("DELETE");
        httpsCon.setDoInput(true);
        if (httpsCon.getResponseCode() != 200) {
            throw new ServerConnectionException(String.valueOf(httpsCon.getResponseCode()));
        }
        InputStream stream = httpsCon.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        reader.close();
    }

    public String exportDatabase() throws Exception {
        URL url = new URL(this.settings.getUrl() + "/database?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()));
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setDoOutput(true);
        httpsCon.setRequestMethod("GET");
        if (httpsCon.getResponseCode() == 200) {
            return Read.getStringFromInputStream(httpsCon.getInputStream());
        }
        throw new ServerConnectionException(String.valueOf(httpsCon.getResponseCode()));
    }

    public void importDatabase(Database database) throws Exception {
        String databaseJSON = new Gson().toJson(database);
        URL url = new URL(this.settings.getUrl() + "/database?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()));
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setRequestMethod("POST");
        httpsCon.setRequestProperty("Content-Type", "application/json");
        httpsCon.setRequestProperty("Accept", "application/json");
        httpsCon.setDoInput(true);
        httpsCon.setDoOutput(true);
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(httpsCon.getOutputStream(), StandardCharsets.UTF_8));
        writer.write(databaseJSON);
        writer.flush();
        writer.close();
        if (httpsCon.getResponseCode() != 200) {
            throw new ServerConnectionException(String.valueOf(httpsCon.getResponseCode()));
        }
        InputStream stream = httpsCon.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        reader.close();
    }

    public ArrayList<CategoryInOutSum> getCategoryInOutSumForMonth(DateTime startDate, DateTime endDate) throws Exception {
        URL url = new URL(this.settings.getUrl() + "/charts/categoryInOutSum?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()) + "&startDate=" + startDate.toString("yyyy-MM-dd") + "&endDate=" + endDate.toString("yyyy-MM-dd"));
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setDoOutput(true);
        httpsCon.setRequestMethod("GET");
        if (httpsCon.getResponseCode() == 200) {
            String result = Read.getStringFromInputStream(httpsCon.getInputStream());
            Type listType = new TypeToken<ArrayList<CategoryInOutSum>>(){}.getType();
            return (ArrayList)this.gson.fromJson(result, listType);
        }
        return null;
    }

    public ArrayList<MonthInOutSum> getMonthInOutSum(DateTime startDate, DateTime endDate) throws Exception {
        URL url = new URL(this.settings.getUrl() + "/charts/monthInOutSum?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()) + "&startDate=" + startDate.toString("yyyy-MM-dd") + "&endDate=" + endDate.toString("yyyy-MM-dd"));
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setDoOutput(true);
        httpsCon.setRequestMethod("GET");
        if (httpsCon.getResponseCode() == 200) {
            String result = Read.getStringFromInputStream(httpsCon.getInputStream());
            Type listType = new TypeToken<ArrayList<MonthInOutSum>>(){}.getType();
            return (ArrayList)this.gson.fromJson(result, listType);
        }
        return null;
    }

    public ServerInformation getServerInfo() throws Exception {
        URL url = new URL(this.settings.getUrl() + "/info?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()));
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setDoOutput(true);
        httpsCon.setRequestMethod("GET");
        if (httpsCon.getResponseCode() == 200) {
            String result = Read.getStringFromInputStream(httpsCon.getInputStream());
            return this.gson.fromJson(result, ServerInformation.class);
        }
        throw new ServerConnectionException(String.valueOf(httpsCon.getResponseCode()));
    }

    public VersionInformation getServerVersion() throws Exception {
        URL url = new URL(this.settings.getUrl() + "/version?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()));
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setDoOutput(true);
        httpsCon.setRequestMethod("GET");
        if (httpsCon.getResponseCode() == 200) {
            String result = Read.getStringFromInputStream(httpsCon.getInputStream());
            return this.gson.fromJson(result, VersionInformation.class);
        }
        throw new ServerConnectionException(String.valueOf(httpsCon.getResponseCode()));
    }

    public void deleteLog() throws Exception {
        URL url = new URL(this.settings.getUrl() + "/log?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()));
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setRequestMethod("DELETE");
        httpsCon.setDoInput(true);
        if (httpsCon.getResponseCode() != 200) {
            throw new ServerConnectionException(String.valueOf(httpsCon.getResponseCode()));
        }
        InputStream stream = httpsCon.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        reader.close();
    }

    public void shutdownServer() throws Exception {
        URL url = new URL(this.settings.getUrl() + "/shutdown?secret=" + Helpers.getURLEncodedString(this.settings.getSecret()));
        HttpsURLConnection httpsCon = (HttpsURLConnection)url.openConnection();
        httpsCon.setRequestMethod("GET");
        httpsCon.setDoInput(true);
        if (httpsCon.getResponseCode() != 200) {
            throw new ServerConnectionException(String.valueOf(httpsCon.getResponseCode()));
        }
        InputStream stream = httpsCon.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        reader.close();
    }
}

