/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmaster.logic.utils;

import de.deadlocker8.budgetmaster.logic.utils.Colors;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import javafx.scene.paint.Color;
import tools.Localization;

public class Helpers {
    public static final DecimalFormat NUMBER_FORMAT = new DecimalFormat("0.00");
    public static final String SALT = "ny9/Y+G|WrJ,82|oIYQQ X %i-sq#4,uA-qKPtwFPnw+s(k2`rV)^-a1|t{D3Z>S";
    public static final String ROADMAP_URL = "https://deadlocker.thecodelabs.de/roadmap/php/index.php?id=1";

    public static String getCurrencyString(int amount, String currency) {
        return String.valueOf(NUMBER_FORMAT.format((double)amount / 100.0).replace(".", ",")) + " " + currency;
    }

    public static String getCurrencyString(double amount, String currency) {
        return String.valueOf(NUMBER_FORMAT.format(amount).replace(".", ",")) + " " + currency;
    }

    public static String getURLEncodedString(String input) {
        try {
            return URLEncoder.encode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return input;
        }
    }

    public static String getDateString(LocalDate date) {
        if (date == null) {
            return "";
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        return date.format(formatter);
    }

    public static ArrayList<String> getMonthList() {
        ArrayList<String> monthNames = new ArrayList<String>();
        monthNames.add(Localization.getString("month.january"));
        monthNames.add(Localization.getString("month.february"));
        monthNames.add(Localization.getString("month.march"));
        monthNames.add(Localization.getString("month.april"));
        monthNames.add(Localization.getString("month.may"));
        monthNames.add(Localization.getString("month.june"));
        monthNames.add(Localization.getString("month.july"));
        monthNames.add(Localization.getString("month.august"));
        monthNames.add(Localization.getString("month.september"));
        monthNames.add(Localization.getString("month.october"));
        monthNames.add(Localization.getString("month.november"));
        monthNames.add(Localization.getString("month.december"));
        return monthNames;
    }

    public static ArrayList<String> getYearList() {
        ArrayList<String> years = new ArrayList<String>();
        for (int i = 2000; i < 2100; ++i) {
            years.add(String.valueOf(i));
        }
        return years;
    }

    public static ArrayList<Color> getCategoryColorList() {
        ArrayList<Color> colors = new ArrayList<Color>();
        colors.add(Colors.CATEGORIES_LIGHT_GREY);
        colors.add(Colors.CATEGORIES_GREY);
        colors.add(Colors.CATEGORIES_DARK_GREY);
        colors.add(Colors.CATEGORIES_LIGHT_YELLOW);
        colors.add(Colors.CATEGORIES_YELLOW);
        colors.add(Colors.CATEGORIES_ORANGE);
        colors.add(Colors.CATEGORIES_RED);
        colors.add(Colors.CATEGORIES_DARK_RED);
        colors.add(Colors.CATEGORIES_PINK);
        colors.add(Colors.CATEGORIES_PURPLE);
        colors.add(Colors.CATEGORIES_DARK_PURPLE);
        colors.add(Colors.CATEGORIES_BLUE);
        colors.add(Colors.CATEGORIES_LIGHT_BLUE);
        colors.add(Colors.CATEGORIES_LIGHT_GREEN);
        colors.add(Colors.CATEGORIES_DARK_GREEN);
        return colors;
    }

    public static String getFlatText(String text) {
        text = text.replace("\n", " ");
        text = text.replace("\t", " ");
        return text;
    }
}

