/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.ui.cells;

import de.deadlocker8.budgetmaster.logic.category.Category;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import tools.ConvertTo;

public class ButtonCategoryCell
extends ListCell<Category> {
    private Color color;

    public ButtonCategoryCell(Color color) {
        this.color = color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    protected void updateItem(Category item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (!empty) {
            HBox hbox = new HBox();
            Label labelName = new Label(item.getName());
            labelName.setStyle("-fx-font-weight: bold; -fx-font-size: 14; -fx-text-fill: " + ConvertTo.toRGBHex(ConvertTo.getAppropriateTextColor(this.color)));
            labelName.setAlignment(Pos.CENTER);
            hbox.getChildren().add((Object)labelName);
            hbox.setPadding(new Insets(0.0));
            this.setStyle("-fx-background: transparent;");
            this.setGraphic((Node)hbox);
            this.setText(null);
            this.setAlignment(Pos.CENTER);
        } else {
            this.setStyle("-fx-background: transparent");
            this.setText(null);
            this.setGraphic(null);
        }
    }
}

