/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.ui.cells;

import de.deadlocker8.budgetmaster.logic.category.Category;
import de.deadlocker8.budgetmasterclient.ui.controller.CategoryController;
import fontAwesome.FontIcon;
import fontAwesome.FontIconType;
import java.util.Optional;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import tools.ConvertTo;
import tools.Localization;

public class CategoryCell
extends ListCell<Category> {
    private final double HEIGHT = 40.0;
    private CategoryController categoryController;

    public CategoryCell(CategoryController categoryController) {
        this.categoryController = categoryController;
    }

    protected void updateItem(Category item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (!empty) {
            HBox hbox = new HBox();
            Label labelCircle = new Label(item.getName().substring(0, 1).toUpperCase());
            labelCircle.setPrefWidth(40.0);
            labelCircle.setPrefHeight(40.0);
            labelCircle.setAlignment(Pos.CENTER);
            labelCircle.getStyleClass().add((Object)"greylabel");
            String textColor = ConvertTo.toRGBHex(ConvertTo.getAppropriateTextColor(Color.web((String)item.getColor())));
            labelCircle.setStyle("-fx-background-color: " + item.getColor() + "; -fx-background-radius: 50%; -fx-text-fill: " + textColor + "; -fx-font-weight: bold; -fx-font-size: 20;");
            hbox.getChildren().add((Object)labelCircle);
            Label labelName = new Label(item.getName());
            labelName.setPrefHeight(40.0);
            labelName.setStyle("-fx-font-weight: bold; -fx-font-size: 16; -fx-text-fill: #212121");
            labelName.setAlignment(Pos.CENTER);
            labelName.getStyleClass().add((Object)"greylabel");
            hbox.getChildren().add((Object)labelName);
            HBox.setMargin((Node)labelName, (Insets)new Insets(0.0, 0.0, 0.0, 20.0));
            Region r = new Region();
            hbox.getChildren().add((Object)r);
            HBox.setHgrow((Node)r, (Priority)Priority.ALWAYS);
            Button buttonEdit = new Button();
            buttonEdit.setGraphic((Node)new FontIcon(FontIconType.PENCIL, 16, Color.web((String)"#212121")));
            buttonEdit.setPrefHeight(40.0);
            buttonEdit.getStyleClass().add((Object)"greylabel");
            buttonEdit.setStyle("-fx-background-color: transparent");
            buttonEdit.setOnAction(e -> this.categoryController.newCategory(true, item));
            hbox.getChildren().add((Object)buttonEdit);
            HBox.setMargin((Node)buttonEdit, (Insets)new Insets(0.0, 0.0, 0.0, 25.0));
            Button buttonDelete = new Button();
            buttonDelete.setGraphic((Node)new FontIcon(FontIconType.TRASH, 16, Color.web((String)"#212121")));
            buttonDelete.setPrefHeight(40.0);
            buttonDelete.getStyleClass().add((Object)"greylabel");
            buttonDelete.setStyle("-fx-background-color: transparent");
            buttonDelete.setOnAction(event -> {
                Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                alert.setTitle(Localization.getString("info.title.category.delete"));
                alert.setHeaderText("");
                alert.setContentText(Localization.getString("info.text.category.delete"));
                Stage dialogStage = (Stage)alert.getDialogPane().getScene().getWindow();
                dialogStage.getIcons().add((Object)this.categoryController.getController().getIcon());
                dialogStage.centerOnScreen();
                Optional result = alert.showAndWait();
                if (result.get() == ButtonType.OK) {
                    this.categoryController.deleteCategory(item.getID());
                }
            });
            if (item.getID() != 2) {
                hbox.getChildren().add((Object)buttonDelete);
                HBox.setMargin((Node)buttonDelete, (Insets)new Insets(0.0, 0.0, 0.0, 5.0));
            }
            hbox.setPadding(new Insets(10.0));
            this.setStyle("-fx-background: transparent; -fx-border-color: #545454; -fx-border-width: 0 0 1 0");
            this.setGraphic((Node)hbox);
            this.setAlignment(Pos.CENTER);
        } else {
            this.setStyle("-fx-background: transparent");
            this.setText(null);
            this.setGraphic(null);
        }
    }
}

