/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.ui.cells;

import de.deadlocker8.budgetmaster.logic.utils.LanguageType;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;

public class LanguageCell
extends ListCell<LanguageType> {
    private final double HEIGHT = 20.0;
    private boolean useBorder;

    public LanguageCell(boolean useBorder) {
        this.useBorder = useBorder;
    }

    protected void updateItem(LanguageType item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (!empty) {
            HBox hbox = new HBox();
            Image image = new Image("de/deadlocker8/budgetmaster/flags/" + item.getIconName() + ".png");
            ImageView imageView = new ImageView(image);
            imageView.setFitWidth(20.0);
            imageView.setFitHeight(20.0);
            hbox.getChildren().add((Object)imageView);
            Label labelName = new Label(item.getName());
            labelName.setPrefHeight(20.0);
            labelName.setStyle("-fx-font-weight: bold; -fx-font-size: 14; -fx-text-fill: #212121");
            labelName.setAlignment(Pos.CENTER);
            hbox.getChildren().add((Object)labelName);
            HBox.setMargin((Node)labelName, (Insets)new Insets(0.0, 0.0, 0.0, 20.0));
            hbox.setPadding(new Insets(0.0));
            if (this.useBorder) {
                this.setStyle("-fx-background: transparent; -fx-border-color: #545454; -fx-border-width: 0 0 1 0");
            } else {
                this.setStyle("-fx-background: transparent;");
            }
            this.setGraphic((Node)hbox);
            this.setAlignment(Pos.CENTER);
        } else {
            this.setStyle("-fx-background: transparent");
            this.setText(null);
            this.setGraphic(null);
        }
    }
}

