/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.ui.colorPick;

import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import tools.ConvertTo;

public class ColorPickController {
    @FXML
    private Label labelColor;
    @FXML
    private Slider sliderRed;
    @FXML
    private TextField textFieldRed;
    @FXML
    private Slider sliderGreen;
    @FXML
    private TextField textFieldGreen;
    @FXML
    private Slider sliderBlue;
    @FXML
    private TextField textFieldBlue;
    @FXML
    private TextField textFieldHex;
    @FXML
    private Button buttonSave;
    @FXML
    private Button buttonCancel;
    private Stage stage;
    private Consumer<Color> finish;

    public void init(Stage stage, Consumer<Color> finish) {
        this.stage = stage;
        this.finish = finish;
        this.initializeSliderAndTextField(this.sliderRed, this.textFieldRed);
        this.initializeSliderAndTextField(this.sliderGreen, this.textFieldGreen);
        this.initializeSliderAndTextField(this.sliderBlue, this.textFieldBlue);
        this.initializeTextFieldHex();
        this.updatePreview();
    }

    private void initializeSliderAndTextField(Slider slider, TextField textField) {
        this.initializeSlider(slider, textField);
        this.initializeTextField(slider, textField);
    }

    private void initializeSlider(Slider slider, TextField textField) {
        slider.valueProperty().addListener((observer, oldValue, newValue) -> {
            textField.setText(String.valueOf(newValue.intValue()));
            this.textFieldHex.setText(ConvertTo.toRGBHexWithoutOpacity(this.getColor()));
            this.updatePreview();
        });
    }

    private void initializeTextField(Slider slider, TextField textField) {
        textField.setTextFormatter(new TextFormatter(c -> {
            if (c.getControlNewText().isEmpty()) {
                return c;
            }
            if (c.getControlNewText().matches("[0-9]*")) {
                if (Double.parseDouble(c.getControlNewText()) > 255.0) {
                    return null;
                }
                return c;
            }
            return null;
        }));
        textField.textProperty().addListener((observer, oldValue, newValue) -> {
            double value = newValue.isEmpty() ? 0.0 : Double.parseDouble(newValue);
            slider.setValue(value);
            this.textFieldHex.setText(ConvertTo.toRGBHexWithoutOpacity(this.getColor()));
        });
    }

    private void initializeTextFieldHex() {
        this.textFieldHex.textProperty().addListener((observer, oldValue, newValue) -> {
            try {
                Color hexColor = Color.web((String)newValue);
                this.sliderRed.setValue((double)((int)(hexColor.getRed() * 255.0)));
                this.sliderGreen.setValue((double)((int)(hexColor.getGreen() * 255.0)));
                this.sliderBlue.setValue((double)((int)(hexColor.getBlue() * 255.0)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private Color getColor() {
        return Color.rgb((int)((int)this.sliderRed.getValue()), (int)((int)this.sliderGreen.getValue()), (int)((int)this.sliderBlue.getValue()));
    }

    private void updatePreview() {
        this.labelColor.setStyle("-fx-border-color: #000000; -fx-border-width: 1; -fx-background-color: " + ConvertTo.toRGBHex(this.getColor()));
    }

    @FXML
    void cancel(ActionEvent event) {
        this.stage.close();
    }

    @FXML
    void save(ActionEvent event) {
        this.finish.accept(this.getColor());
        this.stage.close();
    }
}

