/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.ui.commandLine;

import de.deadlocker8.budgetmasterclient.ui.commandLine.CommandBundle;
import de.deadlocker8.budgetmasterclient.ui.commandLine.CommandLineController;
import de.deadlocker8.budgetmasterclient.ui.commandLine.HistoryEntry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;

public class CommandLine {
    private Stage owner;
    private Stage newStage;
    private Image icon;
    private ResourceBundle languageBundle;
    public ArrayList<HistoryEntry> globalHistory = new ArrayList();
    public int lastShownCommand = 1;
    public ArrayList<HistoryEntry> history = new ArrayList();
    private final String promptText = ">>>";
    private CommandBundle bundle;

    public CommandLine(Stage owner, Image icon, ResourceBundle languageBundle, CommandBundle commandBundle) {
        this.owner = owner;
        this.icon = icon;
        this.languageBundle = languageBundle;
        this.bundle = commandBundle;
    }

    public Stage getOwner() {
        return this.owner;
    }

    public Stage getStage() {
        return this.newStage;
    }

    public Image getIcon() {
        return this.icon;
    }

    public int getLastShwonCommand() {
        return this.lastShownCommand;
    }

    public String getPromptText() {
        return ">>>";
    }

    public ResourceBundle getLanguageBundle() {
        return this.languageBundle;
    }

    public CommandBundle getBundle() {
        return this.bundle;
    }

    public void showCommandLine(String title, double width, double height, double minWidth, double minHeight, double positionX, double positionY, boolean dark) throws IOException {
        if (this.newStage != null && this.newStage.isShowing()) {
            return;
        }
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/de/deadlocker8/budgetmaster/ui/commandLine/CommandLineGUI.fxml"));
        Parent root = (Parent)fxmlLoader.load();
        this.newStage = new Stage();
        this.newStage.setScene(new Scene(root, width, height));
        this.newStage.setResizable(true);
        this.newStage.setTitle(title);
        this.newStage.initOwner((Window)this.owner);
        this.newStage.setMinWidth(minWidth);
        this.newStage.setMinHeight(minHeight);
        if (positionX != -1.0) {
            this.newStage.setX(positionX);
        }
        if (positionY != -1.0) {
            this.newStage.setY(positionY);
        }
        if (dark) {
            root.setStyle("-fx-base: rgb(50, 50, 50); -fx-background: rgb(50, 50, 50); -fx-control-inner-background:  rgb(10, 10, 10);");
        }
        if (this.icon != null) {
            this.newStage.getIcons().add((Object)this.icon);
        }
        CommandLineController newController = (CommandLineController)fxmlLoader.getController();
        newController.init(this);
        this.newStage.initModality(Modality.NONE);
        this.newStage.show();
    }

    public void closeCommandLine() {
        if (this.newStage != null && this.newStage.isShowing()) {
            this.newStage.close();
        }
    }
}

