/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.ui.controller;

import de.deadlocker8.budgetmaster.logic.charts.ChartExportable;
import de.deadlocker8.budgetmaster.logic.utils.Colors;
import de.deadlocker8.budgetmasterclient.ui.Styleable;
import de.deadlocker8.budgetmasterclient.ui.controller.BaseController;
import de.deadlocker8.budgetmasterclient.ui.controller.ChartController;
import fontAwesome.FontIcon;
import fontAwesome.FontIconType;
import java.awt.Desktop;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import javafx.embed.swing.SwingFXUtils;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.imageio.ImageIO;
import logger.Logger;
import tools.AlertGenerator;
import tools.ConvertTo;
import tools.Localization;

public class ExportChartController
extends BaseController
implements Styleable {
    @FXML
    private AnchorPane anchorPaneMain;
    @FXML
    private TextField textFieldWidth;
    @FXML
    private TextField textFieldHeight;
    @FXML
    private Label labelSavePath;
    @FXML
    private Button buttonChooseFile;
    @FXML
    private Button buttonExport;
    @FXML
    private Button buttonCancel;
    private ChartController controller;
    private Stage parentStage;
    private ChartExportable chart;
    private File savePath;

    public ExportChartController(Stage parentStage, ChartController controller, ChartExportable chart) {
        this.parentStage = parentStage;
        this.controller = controller;
        this.chart = chart;
        this.load("/de/deadlocker8/budgetmaster/ui/fxml/ExportChartGUI.fxml", Localization.getBundle());
        this.getStage().showAndWait();
    }

    @Override
    public void initStage(Stage stage) {
        stage.initOwner((Window)this.parentStage);
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.setTitle(Localization.getString("title.chart.export"));
        stage.getIcons().add((Object)this.controller.getController().getIcon());
        stage.setResizable(false);
    }

    @Override
    public void init() {
        this.applyStyle();
        this.savePath = this.controller.getLastExportPath();
        if (this.savePath != null) {
            this.labelSavePath.setText(this.savePath.getAbsolutePath());
        }
        this.textFieldWidth.setText(String.valueOf((int)this.chart.getSuggestedWidth()));
        this.textFieldHeight.setText(String.valueOf((int)this.chart.getSuggestedHeight()));
        this.textFieldWidth.setTextFormatter(new TextFormatter(c -> {
            if (c.getControlNewText().isEmpty()) {
                return c;
            }
            if (c.getControlNewText().matches("[0-9]*")) {
                return c;
            }
            return null;
        }));
        this.textFieldHeight.setTextFormatter(new TextFormatter(c -> {
            if (c.getControlNewText().isEmpty()) {
                return c;
            }
            if (c.getControlNewText().matches("[0-9]*")) {
                return c;
            }
            return null;
        }));
    }

    public void chooseFile() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(Localization.getString("title.chart.export"));
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("PNG (*.png)", new String[]{"*.png"});
        if (this.savePath != null) {
            fileChooser.setInitialDirectory(this.savePath.getParentFile());
            fileChooser.setInitialFileName(this.savePath.getName());
        }
        fileChooser.getExtensionFilters().add((Object)extFilter);
        File file = fileChooser.showSaveDialog((Window)this.getStage());
        if (file != null) {
            this.savePath = file;
            this.labelSavePath.setText(file.getAbsolutePath());
        }
    }

    public void export() {
        String widthText = this.textFieldWidth.getText();
        if (widthText == null || widthText.equals("")) {
            AlertGenerator.showAlert(Alert.AlertType.WARNING, Localization.getString("title.warning"), "", Localization.getString("warning.empty.width.in.pixels"), this.controller.getController().getIcon(), (Window)this.getStage(), null, false);
            return;
        }
        int width = 0;
        try {
            width = Integer.parseInt(widthText);
        }
        catch (Exception e) {
            AlertGenerator.showAlert(Alert.AlertType.WARNING, Localization.getString("title.warning"), "", Localization.getString("warning.integer.width.in.pixels"), this.controller.getController().getIcon(), (Window)this.getStage(), null, false);
            return;
        }
        String heightText = this.textFieldHeight.getText();
        if (heightText == null || heightText.equals("")) {
            AlertGenerator.showAlert(Alert.AlertType.WARNING, Localization.getString("title.warning"), "", Localization.getString("warning.empty.height.in.pixels"), this.controller.getController().getIcon(), (Window)this.getStage(), null, false);
            return;
        }
        int height = 0;
        try {
            height = Integer.parseInt(heightText);
        }
        catch (Exception e) {
            AlertGenerator.showAlert(Alert.AlertType.WARNING, Localization.getString("title.warning"), "", Localization.getString("warning.integer.height.in.pixels"), this.controller.getController().getIcon(), (Window)this.getStage(), null, false);
            return;
        }
        if (this.savePath == null) {
            AlertGenerator.showAlert(Alert.AlertType.WARNING, Localization.getString("title.warning"), "", Localization.getString("warning.empty.savepath.chart"), this.controller.getController().getIcon(), (Window)this.getStage(), null, false);
            return;
        }
        WritableImage image = this.chart.export(width, height);
        try {
            ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage((Image)image, null), "png", this.savePath);
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setTitle(Localization.getString("info.title.chart.export"));
            alert.initOwner((Window)this.controller.getController().getStage());
            alert.setHeaderText("");
            alert.setContentText(Localization.getString("info.text.chart.export"));
            Stage dialogStage = (Stage)alert.getDialogPane().getScene().getWindow();
            dialogStage.getIcons().add((Object)this.controller.getController().getIcon());
            ButtonType buttonTypeOne = new ButtonType(Localization.getString("info.text.chart.export.open.folder"));
            ButtonType buttonTypeTwo = new ButtonType(Localization.getString("info.text.chart.export.open.chart"));
            ButtonType buttonTypeThree = new ButtonType(Localization.getString("ok"));
            alert.getButtonTypes().setAll((Object[])new ButtonType[]{buttonTypeOne, buttonTypeTwo, buttonTypeThree});
            DialogPane dialogPane = alert.getDialogPane();
            dialogPane.getButtonTypes().stream().map(arg_0 -> ((DialogPane)dialogPane).lookupButton(arg_0)).forEach(button -> button.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
                if (KeyCode.ENTER.equals((Object)event.getCode()) && event.getTarget() instanceof Button) {
                    ((Button)event.getTarget()).fire();
                }
            }));
            Optional result = alert.showAndWait();
            if (result.get() == buttonTypeOne) {
                try {
                    Desktop.getDesktop().open(new File(this.savePath.getParent().replace("\\", "/")));
                }
                catch (IOException e1) {
                    Logger.error(e1);
                    AlertGenerator.showAlert(Alert.AlertType.ERROR, Localization.getString("title.error"), "", Localization.getString("error.open.folder", e1.getMessage()), this.controller.getController().getIcon(), (Window)this.getStage(), null, false);
                }
            } else if (result.get() == buttonTypeTwo) {
                try {
                    Desktop.getDesktop().open(new File(this.savePath.getAbsolutePath().replace("\\", "/")));
                }
                catch (IOException e1) {
                    Logger.error(e1);
                    AlertGenerator.showAlert(Alert.AlertType.ERROR, Localization.getString("title.error"), "", Localization.getString("error.open.chart", e1.getMessage()), this.controller.getController().getIcon(), (Window)this.getStage(), null, false);
                }
            } else {
                alert.close();
            }
        }
        catch (IOException e) {
            Logger.error(e);
            AlertGenerator.showAlert(Alert.AlertType.ERROR, Localization.getString("title.error"), "", Localization.getString("error.chart.export", e.getMessage()), this.controller.getController().getIcon(), (Window)this.getStage(), null, false);
        }
        this.getStage().close();
        this.controller.getController().showNotification(Localization.getString("notification.chart.export"));
        this.controller.setLastExportPath(this.savePath);
    }

    public void cancel() {
        this.getStage().close();
    }

    @Override
    public void applyStyle() {
        this.anchorPaneMain.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND));
        this.buttonChooseFile.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 14;");
        this.buttonChooseFile.setGraphic((Node)new FontIcon(FontIconType.FOLDER_OPEN, 14, Color.WHITE));
        this.buttonExport.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 14;");
        this.buttonExport.setGraphic((Node)new FontIcon(FontIconType.SAVE, 14, Color.WHITE));
        this.buttonCancel.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 14;");
        this.buttonCancel.setGraphic((Node)new FontIcon(FontIconType.TIMES, 14, Color.WHITE));
    }
}

