/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.ui.controller;

import de.deadlocker8.budgetmaster.logic.Budget;
import de.deadlocker8.budgetmaster.logic.category.CategoryBudget;
import de.deadlocker8.budgetmaster.logic.utils.Colors;
import de.deadlocker8.budgetmaster.logic.utils.Helpers;
import de.deadlocker8.budgetmasterclient.ui.Refreshable;
import de.deadlocker8.budgetmasterclient.ui.Styleable;
import de.deadlocker8.budgetmasterclient.ui.cells.CategoryBudgetCell;
import de.deadlocker8.budgetmasterclient.ui.controller.Controller;
import java.util.ArrayList;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.AnchorPane;
import tools.ConvertTo;
import tools.Localization;

public class HomeController
implements Refreshable,
Styleable {
    @FXML
    private AnchorPane anchorPaneMain;
    @FXML
    private Label labelBudget;
    @FXML
    private Label labelStartBudget;
    @FXML
    private ProgressBar progressBar;
    @FXML
    private ListView<CategoryBudget> listView;
    private Controller controller;

    public void init(Controller controller) {
        this.controller = controller;
        HomeController thisController = this;
        this.listView.setCellFactory(param -> new CategoryBudgetCell(thisController));
        Label labelPlaceholder = new Label(Localization.getString("home.placeholder"));
        labelPlaceholder.setStyle("-fx-font-size: 16");
        this.listView.setPlaceholder((Node)labelPlaceholder);
        this.listView.getSelectionModel().selectedIndexProperty().addListener((observable, oldValue, newValue) -> Platform.runLater(() -> this.listView.getSelectionModel().select(-1)));
        this.applyStyle();
    }

    private void refreshListView() {
        this.listView.getItems().clear();
        ArrayList<CategoryBudget> categoryBudgets = this.controller.getCategoryBudgets();
        if (categoryBudgets != null) {
            this.listView.getItems().setAll(categoryBudgets);
        }
    }

    private void refreshCounter() {
        if (this.controller.getPaymentHandler().getPayments() != null) {
            Budget budget = new Budget(this.controller.getPaymentHandler().getPayments());
            double remaining = budget.getIncomeSum() + budget.getPaymentSum();
            String currency = "\u20ac";
            if (this.controller.getSettings() != null) {
                currency = this.controller.getSettings().getCurrency();
            }
            this.labelBudget.setText(Helpers.getCurrencyString(remaining, currency));
            if (remaining <= 0.0) {
                this.labelBudget.setStyle("-fx-text-fill: " + ConvertTo.toRGBHexWithoutOpacity(Colors.TEXT_RED));
            } else {
                this.labelBudget.setStyle("-fx-text-fill: " + ConvertTo.toRGBHexWithoutOpacity(Colors.TEXT));
            }
            this.labelStartBudget.setText(Localization.getString("home.budget", Helpers.getCurrencyString(budget.getIncomeSum(), currency)));
            double factor = remaining / budget.getIncomeSum();
            if (factor < 0.0) {
                factor = 0.0;
            }
            this.progressBar.setProgress(factor);
        }
    }

    public Controller getController() {
        return this.controller;
    }

    @Override
    public void refresh() {
        this.refreshListView();
        this.refreshCounter();
    }

    @Override
    public void applyStyle() {
        this.anchorPaneMain.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND));
    }
}

