/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.ui.controller;

import de.deadlocker8.budgetmasterclient.ui.controller.Controller;
import java.util.Optional;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import logger.Logger;
import tools.Localization;

public class ModalController {
    @FXML
    private Label labelMessage;
    private Alert alert;

    public void init(Controller controller, Stage stage, String message) {
        this.labelMessage.setText(message);
        stage.setOnCloseRequest(e -> {
            this.alert = new Alert(Alert.AlertType.CONFIRMATION);
            this.alert.setTitle(Localization.getString("info.title.shutdown"));
            this.alert.initModality(Modality.APPLICATION_MODAL);
            this.alert.initOwner((Window)controller.getStage());
            this.alert.setHeaderText("");
            this.alert.setContentText(Localization.getString("info.text.shutdown"));
            Stage dialogStage = (Stage)this.alert.getDialogPane().getScene().getWindow();
            dialogStage.getIcons().add((Object)controller.getIcon());
            ButtonType buttonTypeOne = new ButtonType(Localization.getString("cancel"));
            ButtonType buttonTypeTwo = new ButtonType(Localization.getString("ok"));
            this.alert.getButtonTypes().setAll((Object[])new ButtonType[]{buttonTypeOne, buttonTypeTwo});
            DialogPane dialogPane = this.alert.getDialogPane();
            dialogPane.getButtonTypes().stream().map(arg_0 -> ((DialogPane)dialogPane).lookupButton(arg_0)).forEach(button -> button.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
                if (KeyCode.ENTER.equals((Object)event.getCode()) && event.getTarget() instanceof Button) {
                    ((Button)event.getTarget()).fire();
                }
            }));
            Optional result = this.alert.showAndWait();
            if (result.get() == buttonTypeTwo) {
                Logger.debug("Shutting down during operation due to client request...");
                controller.getStage().fireEvent((Event)new WindowEvent((Window)controller.getStage(), WindowEvent.WINDOW_CLOSE_REQUEST));
            }
            e.consume();
        });
    }

    public void setMessage(String message) {
        this.labelMessage.setText(message);
    }

    public void closeAlert() {
        if (this.alert != null && this.alert.isShowing()) {
            Button cancelButton = (Button)this.alert.getDialogPane().lookupButton((ButtonType)this.alert.getButtonTypes().get(0));
            cancelButton.fire();
        }
    }
}

