/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.ui.controller;

import de.deadlocker8.budgetmaster.logic.category.Category;
import de.deadlocker8.budgetmaster.logic.serverconnection.ExceptionHandler;
import de.deadlocker8.budgetmaster.logic.serverconnection.ServerConnection;
import de.deadlocker8.budgetmaster.logic.utils.Colors;
import de.deadlocker8.budgetmaster.logic.utils.Helpers;
import de.deadlocker8.budgetmasterclient.ui.Styleable;
import de.deadlocker8.budgetmasterclient.ui.colorPick.ColorView;
import de.deadlocker8.budgetmasterclient.ui.controller.BaseController;
import de.deadlocker8.budgetmasterclient.ui.controller.CategoryController;
import de.deadlocker8.budgetmasterclient.ui.controller.Controller;
import fontAwesome.FontIcon;
import fontAwesome.FontIconType;
import java.util.ArrayList;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.paint.Color;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import org.controlsfx.control.PopOver;
import tools.AlertGenerator;
import tools.ConvertTo;
import tools.Localization;

public class NewCategoryController
extends BaseController
implements Styleable {
    @FXML
    private TextField textFieldName;
    @FXML
    private Button buttonColor;
    @FXML
    private Button buttonCancel;
    @FXML
    private Button buttonSave;
    private Stage parentStage;
    private Controller controller;
    private CategoryController categoryController;
    private boolean edit;
    private Color color;
    private PopOver colorChooser;
    private ColorView colorView;
    private Category category;

    public NewCategoryController(Stage parentStage, Controller controller, CategoryController categoryController, boolean edit, Category category) {
        this.parentStage = parentStage;
        this.controller = controller;
        this.categoryController = categoryController;
        this.edit = edit;
        this.color = null;
        this.category = category;
        this.load("/de/deadlocker8/budgetmaster/ui/fxml/NewCategoryGUI.fxml", Localization.getBundle());
        this.getStage().showAndWait();
    }

    @Override
    public void initStage(Stage stage) {
        stage.initOwner((Window)this.parentStage);
        stage.initModality(Modality.APPLICATION_MODAL);
        if (this.edit) {
            stage.setTitle(Localization.getString("title.category.edit"));
        } else {
            stage.setTitle(Localization.getString("title.category.new"));
        }
        stage.getIcons().add((Object)this.controller.getIcon());
        stage.setResizable(false);
        stage.getScene().getStylesheets().add((Object)"/de/deadlocker8/budgetmaster/ui/style.css");
    }

    @Override
    public void init() {
        this.applyStyle();
        this.buttonColor.prefWidthProperty().bind((ObservableValue)this.textFieldName.widthProperty());
        ArrayList<Color> colors = Helpers.getCategoryColorList();
        this.buttonColor.setOnMouseClicked(e -> {
            if (this.colorChooser == null || !this.colorChooser.isShowing()) {
                this.colorChooser = new PopOver();
                this.colorChooser.setContentNode((Node)this.colorView);
                this.colorChooser.setDetachable(false);
                this.colorChooser.setAutoHide(true);
                this.colorChooser.setCornerRadius(5.0);
                this.colorChooser.setArrowLocation(PopOver.ArrowLocation.LEFT_CENTER);
                this.colorChooser.setOnHiding(event -> {
                    this.colorChooser = null;
                });
                this.colorChooser.show((Node)this.buttonColor);
            }
        });
        this.getStage().setOnCloseRequest(event -> {
            if (this.colorChooser != null) {
                this.colorChooser.hide(Duration.millis((double)0.0));
            }
        });
        if (this.edit) {
            this.textFieldName.setText(this.category.getName());
            this.colorView = new ColorView(Color.web((String)this.category.getColor()), colors, this, finishColor -> this.setColor((Color)finishColor));
            this.setColor(Color.web((String)this.category.getColor()));
        } else {
            this.colorView = new ColorView(colors.get(0), colors, this, finishColor -> this.setColor((Color)finishColor));
            this.setColor(colors.get(0));
        }
    }

    private void setColor(Color color) {
        this.color = color;
        this.buttonColor.setStyle("-fx-border-color: #000000; -fx-border-width: 2; -fx-border-radius: 5; -fx-background-radius: 5; -fx-background-color: " + ConvertTo.toRGBHex(color));
        if (this.colorChooser != null) {
            this.colorChooser.hide(Duration.millis((double)0.0));
        }
    }

    public void save() {
        String name = this.textFieldName.getText();
        if (name == null || name.equals("")) {
            AlertGenerator.showAlert(Alert.AlertType.WARNING, Localization.getString("title.warning"), "", Localization.getString("warning.empty.category.name"), this.controller.getIcon(), (Window)this.controller.getStage(), null, false);
            return;
        }
        if (name.length() > 45) {
            AlertGenerator.showAlert(Alert.AlertType.WARNING, Localization.getString("title.warning"), "", Localization.getString("warning.name.character.limit.reached.45"), this.controller.getIcon(), (Window)this.controller.getStage(), null, false);
            return;
        }
        if (this.edit) {
            this.category.setName(name);
            this.category.setColor(ConvertTo.toRGBHexWithoutOpacity(this.color));
            try {
                ServerConnection connection = new ServerConnection(this.controller.getSettings());
                connection.updateCategory(this.category);
            }
            catch (Exception e) {
                this.controller.showConnectionErrorAlert(ExceptionHandler.getMessageForException(e));
            }
        } else {
            Category newCategory = new Category(name, ConvertTo.toRGBHexWithoutOpacity(this.color));
            try {
                ServerConnection connection = new ServerConnection(this.controller.getSettings());
                connection.addCategory(newCategory);
            }
            catch (Exception e) {
                this.controller.showConnectionErrorAlert(e.getMessage());
            }
        }
        this.getStage().close();
        this.categoryController.getController().refresh(this.controller.getFilterSettings());
    }

    public void cancel() {
        this.getStage().close();
    }

    @Override
    public void applyStyle() {
        this.buttonCancel.setGraphic((Node)new FontIcon(FontIconType.TIMES, 17, Color.WHITE));
        this.buttonSave.setGraphic((Node)new FontIcon(FontIconType.SAVE, 17, Color.WHITE));
        this.buttonCancel.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 15;");
        this.buttonSave.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 15;");
        this.buttonColor.setStyle("-fx-border-color: #000000; -fx-border-width: 2; -fx-border-radius: 5; -fx-background-radius: 5;");
    }
}

