/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.ui.controller;

import de.deadlocker8.budgetmaster.logic.Budget;
import de.deadlocker8.budgetmaster.logic.FilterSettings;
import de.deadlocker8.budgetmaster.logic.payment.NormalPayment;
import de.deadlocker8.budgetmaster.logic.payment.Payment;
import de.deadlocker8.budgetmaster.logic.payment.RepeatingPayment;
import de.deadlocker8.budgetmaster.logic.payment.RepeatingPaymentEntry;
import de.deadlocker8.budgetmaster.logic.serverconnection.ExceptionHandler;
import de.deadlocker8.budgetmaster.logic.serverconnection.ServerConnection;
import de.deadlocker8.budgetmaster.logic.utils.Colors;
import de.deadlocker8.budgetmaster.logic.utils.Helpers;
import de.deadlocker8.budgetmasterclient.ui.Refreshable;
import de.deadlocker8.budgetmasterclient.ui.Styleable;
import de.deadlocker8.budgetmasterclient.ui.cells.PaymentCell;
import de.deadlocker8.budgetmasterclient.ui.controller.Controller;
import de.deadlocker8.budgetmasterclient.ui.controller.FilterController;
import de.deadlocker8.budgetmasterclient.ui.controller.NewPaymentController;
import de.deadlocker8.budgetmasterclient.ui.controller.SearchController;
import fontAwesome.FontIcon;
import fontAwesome.FontIconType;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import javafx.util.Callback;
import logger.Logger;
import tools.ConvertTo;
import tools.Localization;

public class PaymentController
implements Refreshable,
Styleable {
    @FXML
    private AnchorPane anchorPaneMain;
    @FXML
    private Label labelIncome;
    @FXML
    private Label labelIncomes;
    @FXML
    private Label labelPayment;
    @FXML
    private Label labelPayments;
    @FXML
    private Label labelFilterActive;
    @FXML
    private ListView<Payment> listView;
    @FXML
    private Button buttonNewIncome;
    @FXML
    private Button buttonFilter;
    @FXML
    private Button buttonNewPayment;
    @FXML
    private Button buttonSearch;
    private Controller controller;

    public void init(Controller controller) {
        this.controller = controller;
        final PaymentController thisController = this;
        this.listView.setCellFactory((Callback)new Callback<ListView<Payment>, ListCell<Payment>>(){

            public ListCell<Payment> call(ListView<Payment> param) {
                PaymentCell cell = new PaymentCell(thisController);
                cell.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
                    if (event.getClickCount() == 2 && ((Payment)cell.getItem()).getCategoryID() != 2) {
                        PaymentController.this.payment(!((Payment)cell.getItem()).isIncome(), true, (Payment)cell.getItem());
                    }
                });
                cell.prefWidthProperty().bind((ObservableValue)PaymentController.this.listView.widthProperty().subtract(20));
                return cell;
            }
        });
        Label labelPlaceholder = new Label(Localization.getString("payments.placeholder"));
        labelPlaceholder.setStyle("-fx-font-size: 16");
        this.listView.setPlaceholder((Node)labelPlaceholder);
        this.listView.getSelectionModel().selectedIndexProperty().addListener((observable, oldValue, newValue) -> Platform.runLater(() -> this.listView.getSelectionModel().select(-1)));
        this.applyStyle();
    }

    public void newIncome() {
        this.payment(false, false, null);
    }

    public void newPayment() {
        this.payment(true, false, null);
    }

    public void payment(boolean isPayment, boolean edit, Payment payment) {
        new NewPaymentController(this.controller.getStage(), this.controller, this, isPayment, edit, payment);
    }

    private void refreshListView(Payment selectedPayment) {
        this.listView.getItems().clear();
        ArrayList<Payment> payments = this.controller.getPaymentHandler().getPayments();
        if (payments != null) {
            this.listView.getItems().setAll(payments);
            this.listView.scrollTo(this.controller.getPaymentHandler().getPosition(selectedPayment));
        }
    }

    private void refreshCounter() {
        Budget budget = new Budget((List<Payment>)this.listView.getItems());
        String currency = "\u20ac";
        if (this.controller.getSettings() != null) {
            currency = this.controller.getSettings().getCurrency();
        }
        this.labelIncomes.setText(Helpers.getCurrencyString(budget.getIncomeSum(), currency));
        this.labelPayments.setText(Helpers.getCurrencyString(budget.getPaymentSum(), currency));
    }

    public void deleteNormalPayment(NormalPayment payment) {
        try {
            ServerConnection connection = new ServerConnection(this.controller.getSettings());
            connection.deleteNormalPayment(payment);
            this.controller.refresh(this.controller.getFilterSettings());
        }
        catch (Exception e) {
            Logger.error(e);
            this.controller.showConnectionErrorAlert(ExceptionHandler.getMessageForException(e));
        }
    }

    public void deleteRepeatingPayment(RepeatingPaymentEntry payment) {
        try {
            ServerConnection connection = new ServerConnection(this.controller.getSettings());
            connection.deleteRepeatingPayment(payment);
            this.controller.refresh(this.controller.getFilterSettings());
        }
        catch (Exception e) {
            Logger.error(e);
            this.controller.showConnectionErrorAlert(ExceptionHandler.getMessageForException(e));
        }
    }

    public void deleteFuturePayments(RepeatingPaymentEntry payment) {
        try {
            ServerConnection connection = new ServerConnection(this.controller.getSettings());
            RepeatingPayment oldRepeatingPayment = connection.getRepeatingPayment(payment.getRepeatingPaymentID());
            RepeatingPayment newRepeatingPayment = new RepeatingPayment(payment.getID(), payment.getAmount(), oldRepeatingPayment.getDate(), payment.getCategoryID(), payment.getName(), payment.getDescription(), payment.getRepeatInterval(), payment.getDate(), payment.getRepeatMonthDay());
            connection.deleteRepeatingPayment(payment);
            connection.addRepeatingPayment(newRepeatingPayment);
            this.controller.refresh(this.controller.getFilterSettings());
        }
        catch (Exception e) {
            Logger.error(e);
            this.controller.showConnectionErrorAlert(ExceptionHandler.getMessageForException(e));
        }
    }

    public void filter() {
        new FilterController(this.controller.getStage(), this.controller, this.controller.getFilterSettings());
    }

    public void search() {
        new SearchController(this.controller.getStage(), this.controller);
    }

    public Controller getController() {
        return this.controller;
    }

    @Override
    public void refresh() {
        this.refreshListView(this.controller.getSelectedPayment());
        this.refreshCounter();
        if (this.controller.getFilterSettings().equals(new FilterSettings())) {
            this.labelFilterActive.setVisible(false);
        } else {
            this.labelFilterActive.setVisible(true);
        }
    }

    @Override
    public void applyStyle() {
        this.buttonNewIncome.setGraphic((Node)new FontIcon(FontIconType.DOWNLOAD, 18, Color.WHITE));
        this.buttonFilter.setGraphic((Node)new FontIcon(FontIconType.FILTER, 18, Color.WHITE));
        this.buttonNewPayment.setGraphic((Node)new FontIcon(FontIconType.UPLOAD, 18, Color.WHITE));
        this.labelFilterActive.setGraphic((Node)new FontIcon(FontIconType.WARNING, 13, Colors.TEXT));
        this.buttonSearch.setGraphic((Node)new FontIcon(FontIconType.SEARCH, 18, Color.WHITE));
        this.anchorPaneMain.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND));
        this.labelIncome.setStyle("-fx-text-fill: " + ConvertTo.toRGBHexWithoutOpacity(Colors.TEXT));
        this.labelIncomes.setStyle("-fx-text-fill: " + ConvertTo.toRGBHexWithoutOpacity(Colors.TEXT));
        this.labelPayment.setStyle("-fx-text-fill: " + ConvertTo.toRGBHexWithoutOpacity(Colors.TEXT));
        this.labelPayments.setStyle("-fx-text-fill: " + ConvertTo.toRGBHexWithoutOpacity(Colors.TEXT));
        this.labelFilterActive.setStyle("-fx-text-fill: " + ConvertTo.toRGBHexWithoutOpacity(Colors.TEXT));
        this.buttonNewIncome.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 16;");
        this.buttonFilter.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 16;");
        this.buttonNewPayment.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 16;");
        this.buttonSearch.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_BUTTON_BLUE) + "; -fx-text-fill: white; -fx-font-weight: bold; -fx-font-size: 16;");
    }
}

