/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.ui.customAlert;

import de.deadlocker8.budgetmasterclient.ui.controller.BaseController;
import de.deadlocker8.budgetmasterclient.ui.controller.SplashScreenController;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import tools.Localization;

public class CustomAlertController
extends BaseController {
    @FXML
    private AnchorPane anchorPaneMain;
    @FXML
    private ImageView imageView;
    @FXML
    private Label labelMessage;
    private Stage parentStage;
    private SplashScreenController controller;
    private Alert.AlertType alertType;
    private String title;
    private String message;

    public CustomAlertController(Stage parentStage, SplashScreenController controller, Alert.AlertType alertType, String title, String message) {
        this.parentStage = parentStage;
        this.controller = controller;
        this.alertType = alertType;
        this.title = title;
        this.message = message;
        this.load("/de/deadlocker8/budgetmaster/ui/customAlert/CustomAlert.fxml", Localization.getBundle());
        this.getStage().showAndWait();
    }

    @Override
    public void initStage(Stage stage) {
        stage.initOwner((Window)this.parentStage);
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.setTitle(this.title);
        stage.getIcons().add((Object)this.controller.getIcon());
        stage.setResizable(false);
    }

    @Override
    public void init() {
        this.labelMessage.setText(this.message);
        this.getStage().getScene().setOnKeyReleased(event -> {
            event.consume();
            if (event.getCode().equals((Object)KeyCode.ENTER)) {
                this.confirm();
            }
        });
        switch (this.alertType) {
            case CONFIRMATION: {
                this.imageView.setImage(new Image("/com/sun/javafx/scene/control/skin/modena/dialog-confirmation.png"));
                break;
            }
            case ERROR: {
                this.imageView.setImage(new Image("/com/sun/javafx/scene/control/skin/modena/dialog-error.png"));
                break;
            }
            case INFORMATION: {
                this.imageView.setImage(new Image("/com/sun/javafx/scene/control/skin/modena/dialog-information.png"));
                break;
            }
            case WARNING: {
                this.imageView.setImage(new Image("/com/sun/javafx/scene/control/skin/modena/dialog-warning.png"));
                break;
            }
            default: {
                this.imageView.setImage(new Image("/com/sun/javafx/scene/control/skin/modena/dialog-information.png"));
            }
        }
    }

    @FXML
    public void confirm() {
        this.getStage().close();
    }
}

