/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.ui.tagField;

import de.deadlocker8.budgetmaster.logic.tag.Tag;
import de.deadlocker8.budgetmaster.logic.utils.Colors;
import de.deadlocker8.budgetmasterclient.ui.controller.NewPaymentController;
import fontAwesome.FontIcon;
import fontAwesome.FontIconType;
import java.util.ArrayList;
import java.util.Collection;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Window;
import javafx.util.Callback;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.controlsfx.control.textfield.TextFields;
import tools.AlertGenerator;
import tools.ConvertTo;
import tools.Localization;

public class TagField
extends VBox {
    private ArrayList<Tag> tags;
    private ArrayList<Tag> allTags;
    private HBox hboxTags;
    private TextField textField;
    private NewPaymentController parentController;

    public TagField(ArrayList<Tag> tags, ArrayList<Tag> allAvailableTags, NewPaymentController parentController) {
        this.tags = tags;
        this.allTags = allAvailableTags;
        this.parentController = parentController;
        this.hboxTags = this.initHboxTags();
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setContent((Node)this.hboxTags);
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        scrollPane.setMinHeight(50.0);
        scrollPane.setStyle("-fx-background-color: #FFFFFF; -fx-background-radius: 5px; -fx-border-color: #000000; -fx-border-width: 1 1 0 1; -fx-border-radius: 5px 5px 0 0");
        this.getChildren().add((Object)scrollPane);
        VBox.setVgrow((Node)scrollPane, (Priority)Priority.ALWAYS);
        this.textField = new TextField();
        this.textField.setStyle("-fx-background-color: #FFFFFF; -fx-border-color: #000000; -fx-border-width: 1; -fx-background-radius: 5px; -fx-border-radius: 0 0 5px 5px");
        this.textField.setPromptText(Localization.getString("tagfield.placeholder"));
        this.textField.setMaxWidth(Double.MAX_VALUE);
        this.textField.setOnKeyPressed(event -> {
            if (event.getCode().equals((Object)KeyCode.ENTER)) {
                this.addTag(this.textField.getText().trim());
            } else if (event.getCode().equals((Object)KeyCode.DOWN)) {
                this.textField.setText(" ");
                this.textField.setText("");
            }
        });
        this.textField.setOnMousePressed(event -> {
            this.textField.setText(" ");
            this.textField.setText("");
        });
        TextFields.bindAutoCompletion(this.textField, new Callback<AutoCompletionBinding.ISuggestionRequest, Collection<String>>(){

            public Collection<String> call(AutoCompletionBinding.ISuggestionRequest param) {
                ArrayList completions = TagField.this.getCompletions(TagField.this.allTags);
                ArrayList<String> remainingCompletions = new ArrayList<String>();
                for (String currentCompletion : completions) {
                    if (!currentCompletion.toLowerCase().contains(param.getUserText().toLowerCase())) continue;
                    remainingCompletions.add(currentCompletion);
                }
                return remainingCompletions;
            }
        });
        this.getChildren().add((Object)this.textField);
        this.setStyle("-fx-background-color: #FFFFFF; -fx-background-radius: 5px;");
        this.refresh(false);
    }

    private HBox initHboxTags() {
        HBox newHboxTags = new HBox();
        newHboxTags.setSpacing(5.0);
        newHboxTags.setPadding(new Insets(5.0));
        newHboxTags.setStyle("-fx-background-color: transparent");
        return newHboxTags;
    }

    private ArrayList<String> getCompletions(ArrayList<Tag> allTags) {
        ArrayList<String> newCompletions = new ArrayList<String>();
        for (Tag currentTag : allTags) {
            boolean isAlreadyInList = false;
            for (Tag paymentTag : this.tags) {
                if (!currentTag.getName().equals(paymentTag.getName())) continue;
                isAlreadyInList = true;
            }
            if (isAlreadyInList) continue;
            newCompletions.add(currentTag.getName());
        }
        return newCompletions;
    }

    public ArrayList<Tag> getTags() {
        return this.tags;
    }

    public void setTags(ArrayList<Tag> tags) {
        this.tags = tags;
        this.refresh(false);
    }

    public void setAllTags(ArrayList<Tag> allTags) {
        this.allTags = allTags;
        this.refresh(false);
    }

    public void addTag(String tagName) {
        if (tagName.equals("")) {
            return;
        }
        for (Tag currentTag : this.tags) {
            if (!currentTag.getName().equals(tagName)) continue;
            return;
        }
        if (tagName.length() > 45) {
            AlertGenerator.showAlert(Alert.AlertType.WARNING, Localization.getString("title.warning"), "", Localization.getString("warning.tag.character.limit.reached.45"), this.parentController.getController().getIcon(), (Window)this.parentController.getStage(), null, false);
            return;
        }
        this.tags.add(new Tag(-1, tagName));
        this.refresh(true);
    }

    public void removeTag(Tag tag) {
        this.tags.remove(tag);
        this.refresh(true);
    }

    private void refresh(boolean requstFocus) {
        this.hboxTags.getChildren().clear();
        for (Tag currentTag : this.tags) {
            this.hboxTags.getChildren().add((Object)this.generateTag(currentTag));
        }
        if (requstFocus) {
            this.textField.setText("");
            this.textField.requestFocus();
        }
    }

    private HBox generateTag(Tag tag) {
        HBox hboxTag = new HBox();
        hboxTag.setSpacing(5.0);
        hboxTag.setAlignment(Pos.CENTER_LEFT);
        hboxTag.setPadding(new Insets(0.0, 3.0, 0.0, 7.0));
        hboxTag.setStyle("-fx-background-color: #cccccc; -fx-background-radius: 5px;");
        Label labelTagName = new Label(tag.getName());
        labelTagName.setStyle("-fx-font-size: 13; -fx-text-fill: " + ConvertTo.toRGBHexWithoutOpacity(Colors.TEXT));
        hboxTag.getChildren().add((Object)labelTagName);
        Button buttonDelete = new Button();
        buttonDelete.setGraphic((Node)new FontIcon(FontIconType.TIMES, 13, Colors.TEXT));
        buttonDelete.setStyle("-fx-background-color: transparent;");
        buttonDelete.getStyleClass().add((Object)"button-hoverable");
        buttonDelete.setOnAction(event -> this.removeTag(tag));
        hboxTag.getChildren().add((Object)buttonDelete);
        return hboxTag;
    }
}

