/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterclient.utils;

import de.deadlocker8.budgetmaster.logic.serverconnection.ExceptionHandler;
import de.deadlocker8.budgetmaster.logic.serverconnection.ServerConnection;
import de.deadlocker8.budgetmasterclient.ui.controller.Controller;
import de.deadlocker8.budgetmasterclient.utils.DatabaseImporter;
import de.deadlocker8.budgetmasterclient.utils.LoadingModal;
import java.util.Optional;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.scene.control.TextInputDialog;
import javafx.stage.Stage;
import javafx.stage.Window;
import logger.Logger;
import tools.AlertGenerator;
import tools.BASE58Type;
import tools.ConvertTo;
import tools.Localization;
import tools.RandomCreations;
import tools.Worker;

public class DatabaseDeleter {
    private Controller controller;

    public DatabaseDeleter(Controller controller) {
        this.controller = controller;
    }

    public void deleteDatabase(boolean importPending) {
        String verificationCode = ConvertTo.toBase58(RandomCreations.generateRandomMixedCaseString(4, true), true, BASE58Type.UPPER);
        TextInputDialog dialog = new TextInputDialog();
        dialog.setTitle(Localization.getString("info.title.database.delete"));
        dialog.setHeaderText(Localization.getString("info.header.text.database.delete"));
        dialog.setContentText(Localization.getString("info.text.database.delete", verificationCode));
        Stage dialogStage = (Stage)dialog.getDialogPane().getScene().getWindow();
        dialogStage.getIcons().add((Object)this.controller.getIcon());
        dialogStage.initOwner((Window)this.controller.getStage());
        Optional result = dialog.showAndWait();
        if (result.isPresent()) {
            if (((String)result.get()).equals(verificationCode)) {
                LoadingModal.showModal(this.controller, Localization.getString("title.modal"), Localization.getString("load.database.delete"), this.controller.getStage(), this.controller.getIcon());
                Worker.runLater(() -> {
                    try {
                        ServerConnection connection = new ServerConnection(this.controller.getSettings());
                        connection.deleteDatabase();
                        Platform.runLater(() -> {
                            LoadingModal.closeModal();
                            if (importPending) {
                                DatabaseImporter importer = new DatabaseImporter(this.controller);
                                importer.importDB();
                            } else {
                                this.controller.refresh(this.controller.getFilterSettings());
                            }
                        });
                    }
                    catch (Exception e) {
                        Logger.error(e);
                        Platform.runLater(() -> {
                            LoadingModal.closeModal();
                            this.controller.showConnectionErrorAlert(ExceptionHandler.getMessageForException(e));
                        });
                    }
                });
            } else {
                AlertGenerator.showAlert(Alert.AlertType.WARNING, Localization.getString("title.warning"), "", Localization.getString("warning.wrong.verificationcode"), this.controller.getIcon(), (Window)this.controller.getStage(), null, false);
                this.deleteDatabase(importPending);
            }
        }
    }
}

