/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqla.io;

import com.mysql.cj.api.mysqla.io.NativeProtocol;
import com.mysql.cj.api.mysqla.io.PacketPayload;
import com.mysql.cj.api.mysqla.io.ProtocolEntityFactory;
import com.mysql.cj.api.mysqla.io.ProtocolEntityReader;
import com.mysql.cj.api.mysqla.result.ColumnDefinition;
import com.mysql.cj.api.mysqla.result.Resultset;
import com.mysql.cj.api.mysqla.result.ResultsetRow;
import com.mysql.cj.mysqla.io.BinaryRowFactory;
import com.mysql.cj.mysqla.io.ColumnDefinitionFactory;
import com.mysql.cj.mysqla.io.MysqlaProtocol;
import com.mysql.cj.mysqla.result.AbstractResultsetRows;
import com.mysql.cj.mysqla.result.OkPacket;
import com.mysql.cj.mysqla.result.ResultsetRowsCursor;
import com.mysql.cj.mysqla.result.ResultsetRowsStatic;
import com.mysql.cj.mysqla.result.ResultsetRowsStreaming;
import java.io.IOException;
import java.util.ArrayList;

public class BinaryResultsetReader
implements ProtocolEntityReader<Resultset> {
    protected MysqlaProtocol protocol;

    public BinaryResultsetReader(MysqlaProtocol prot) {
        this.protocol = prot;
    }

    @Override
    public Resultset read(int maxRows, boolean streamResults, PacketPayload resultPacket, ColumnDefinition metadata, ProtocolEntityFactory<Resultset> resultSetFactory) throws IOException {
        Resultset rs = null;
        long columnCount = resultPacket.readInteger(NativeProtocol.IntegerDataType.INT_LENENC);
        if (columnCount > 0L) {
            boolean isCursorPosible;
            ColumnDefinition cdef = this.protocol.read(ColumnDefinition.class, new ColumnDefinitionFactory(columnCount, metadata));
            boolean bl = isCursorPosible = this.protocol.getPropertySet().getBooleanReadableProperty("useCursorFetch").getValue() != false && resultSetFactory.getResultSetType() == Resultset.Type.FORWARD_ONLY;
            if (!this.protocol.getServerSession().isEOFDeprecated() || isCursorPosible) {
                this.protocol.readServerStatusForResultSets(this.protocol.readPacket(this.protocol.getReusablePacket()), true);
            }
            AbstractResultsetRows rows = null;
            if (isCursorPosible) {
                if (this.protocol.getServerSession().cursorExists()) {
                    rows = new ResultsetRowsCursor(this.protocol, cdef);
                }
            } else if (!streamResults) {
                BinaryRowFactory brf = new BinaryRowFactory(this.protocol, cdef, resultSetFactory.getResultSetConcurrency(), false);
                ArrayList<ResultsetRow> rowList = new ArrayList<ResultsetRow>();
                ResultsetRow row = this.protocol.read(ResultsetRow.class, brf);
                while (row != null) {
                    if (maxRows == -1 || rowList.size() < maxRows) {
                        rowList.add(row);
                    }
                    row = this.protocol.read(ResultsetRow.class, brf);
                }
                rows = new ResultsetRowsStatic(rowList, cdef);
            } else {
                rows = new ResultsetRowsStreaming<Resultset>(this.protocol, cdef, true, resultSetFactory);
                this.protocol.setStreamingData(rows);
            }
            rs = resultSetFactory.createFromProtocolEntity(rows);
        } else {
            if (columnCount == -1L) {
                String charEncoding = this.protocol.getPropertySet().getStringReadableProperty("characterEncoding").getValue();
                String fileName = resultPacket.readString(NativeProtocol.StringSelfDataType.STRING_TERM, this.protocol.doesPlatformDbCharsetMatches() ? charEncoding : null);
                resultPacket = this.protocol.sendFileToServer(fileName);
            }
            OkPacket ok = (OkPacket)this.protocol.readServerStatusForResultSets(resultPacket, false);
            rs = resultSetFactory.createFromProtocolEntity(ok);
        }
        return rs;
    }
}

