/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmaster.logic.charts;

import de.deadlocker8.budgetmaster.logic.charts.CategoryInOutSum;
import de.deadlocker8.budgetmaster.logic.charts.ChartExportable;
import de.deadlocker8.budgetmaster.logic.charts.MonthInOutSum;
import de.deadlocker8.budgetmaster.logic.utils.Colors;
import de.deadlocker8.budgetmaster.logic.utils.Helpers;
import java.util.ArrayList;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.Tooltip;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Transform;
import javafx.stage.Modality;
import javafx.stage.Stage;
import tools.ConvertTo;
import tools.Localization;

public class MonthBarChart
extends VBox
implements ChartExportable {
    private ArrayList<MonthInOutSum> monthInOutSums;
    private String currency;

    public MonthBarChart(ArrayList<MonthInOutSum> monthInOutSums, String currency) {
        this.monthInOutSums = monthInOutSums == null ? new ArrayList() : monthInOutSums;
        this.currency = currency;
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        scrollPane.setFocusTraversable(false);
        scrollPane.setStyle("-fx-background-color: transparent; -fx-background-insets: 0; -fx-border-color: transparent; -fx-border-width: 0; -fx-border-insets: 0;");
        scrollPane.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        HBox generatedChart = this.generate();
        scrollPane.setContent((Node)generatedChart);
        generatedChart.prefHeightProperty().bind((ObservableValue)scrollPane.heightProperty().subtract(30));
        this.getChildren().add((Object)scrollPane);
        VBox.setVgrow((Node)scrollPane, (Priority)Priority.ALWAYS);
        this.getChildren().add((Object)this.generateLegend());
    }

    private HBox generate() {
        HBox generatedChart = new HBox();
        generatedChart.setAlignment(Pos.TOP_CENTER);
        generatedChart.setSpacing(25.0);
        double total = this.getMaximum(this.monthInOutSums);
        for (MonthInOutSum currentMonthSum : this.monthInOutSums) {
            VBox chartPart = new VBox();
            chartPart.setAlignment(Pos.TOP_CENTER);
            HBox hboxChart = new HBox();
            hboxChart.setAlignment(Pos.BOTTOM_CENTER);
            hboxChart.setSpacing(10.0);
            VBox chartIncome = this.generateChart(currentMonthSum.getSums(), total, true);
            hboxChart.getChildren().add((Object)chartIncome);
            HBox.setHgrow((Node)chartIncome, (Priority)Priority.ALWAYS);
            VBox chartPayment = this.generateChart(currentMonthSum.getSums(), total, false);
            hboxChart.getChildren().add((Object)chartPayment);
            HBox.setHgrow((Node)chartPayment, (Priority)Priority.ALWAYS);
            chartPart.getChildren().add((Object)hboxChart);
            VBox.setVgrow((Node)hboxChart, (Priority)Priority.ALWAYS);
            Label labelTitle = new Label(currentMonthSum.getDate().toString("MMMM \nYY"));
            labelTitle.setStyle("-fx-font-size: 12;");
            labelTitle.setTextAlignment(TextAlignment.CENTER);
            chartPart.getChildren().add((Object)labelTitle);
            VBox.setMargin((Node)labelTitle, (Insets)new Insets(10.0, 0.0, 0.0, 0.0));
            generatedChart.getChildren().add((Object)chartPart);
            generatedChart.getChildren().add((Object)new Separator(Orientation.VERTICAL));
        }
        return generatedChart;
    }

    private VBox generateChart(ArrayList<CategoryInOutSum> categoryInOutSums, double total, boolean useBudgetIN) {
        VBox result = new VBox();
        Label labelAmount = new Label(Helpers.getCurrencyString(this.getTotal(categoryInOutSums, useBudgetIN), this.currency));
        labelAmount.setStyle("-fx-font-size: 12; -fx-font-weight: bold;");
        result.getChildren().add((Object)labelAmount);
        VBox.setMargin((Node)labelAmount, (Insets)new Insets(0.0, 0.0, 10.0, 0.0));
        VBox chart = new VBox();
        chart.setAlignment(Pos.BOTTOM_CENTER);
        for (CategoryInOutSum currentItem : categoryInOutSums) {
            Label currentPart = new Label();
            currentPart.setStyle("-fx-background-color: " + currentItem.getColor());
            currentPart.prefWidthProperty().bind((ObservableValue)chart.widthProperty());
            chart.getChildren().add((Object)currentPart);
            double value = useBudgetIN ? (double)currentItem.getBudgetIN() / 100.0 : (double)(-currentItem.getBudgetOUT()) / 100.0;
            double percentage = value / total;
            currentPart.setMinHeight(0.0);
            currentPart.prefHeightProperty().bind((ObservableValue)chart.heightProperty().multiply(percentage));
            Tooltip tooltip = new Tooltip();
            tooltip.setText(Localization.getString("tooltip.chart.categories", currentItem.getName(), Helpers.NUMBER_FORMAT.format(percentage * 100.0), Helpers.getCurrencyString(value, this.currency)));
            currentPart.setTooltip(tooltip);
        }
        result.getChildren().add((Object)chart);
        VBox.setVgrow((Node)chart, (Priority)Priority.ALWAYS);
        return result;
    }

    private GridPane generateLegend() {
        GridPane legend = new GridPane();
        legend.setPadding(new Insets(10.0));
        legend.setHgap(20.0);
        legend.setVgap(10.0);
        legend.setAlignment(Pos.CENTER);
        legend.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.BACKGROUND_CHART_LEGEND) + "; -fx-border-color: #212121; -fx-border-width: 1; -fx-border-radius: 5;");
        if (this.monthInOutSums.size() == 0) {
            return legend;
        }
        ArrayList<HBox> legendItems = new ArrayList<HBox>();
        for (CategoryInOutSum currentItem : this.monthInOutSums.get(0).getSums()) {
            legendItems.add(this.getLegendItem(currentItem.getName(), Color.web((String)currentItem.getColor())));
        }
        int numberOfItems = legendItems.size();
        int legendWidth = numberOfItems <= 3 ? numberOfItems : (int)Math.ceil(Math.sqrt(numberOfItems));
        for (int i = 0; i < numberOfItems; ++i) {
            int columnIndex = i % legendWidth;
            int rowIndex = i / legendWidth;
            legend.add((Node)legendItems.get(i), columnIndex, rowIndex);
        }
        return legend;
    }

    private HBox getLegendItem(String name, Color color) {
        HBox legendItem = new HBox();
        Label labelCircle = new Label();
        labelCircle.setMinWidth(20.0);
        labelCircle.setMinHeight(20.0);
        labelCircle.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(color) + "; -fx-background-radius: 50%; -fx-border-width: 1; -fx-border-color: black - fx-border-radius: 50%");
        Label labelText = new Label(name);
        labelText.setStyle("-fx-font-weight: bold;");
        legendItem.getChildren().add((Object)labelCircle);
        legendItem.getChildren().add((Object)labelText);
        HBox.setMargin((Node)labelText, (Insets)new Insets(0.0, 0.0, 0.0, 5.0));
        return legendItem;
    }

    private double getTotal(ArrayList<CategoryInOutSum> categoryInOutSums, boolean useBudgetIN) {
        double total = 0.0;
        for (CategoryInOutSum currentItem : categoryInOutSums) {
            if (useBudgetIN) {
                total += (double)currentItem.getBudgetIN() / 100.0;
                continue;
            }
            total += (double)(-currentItem.getBudgetOUT()) / 100.0;
        }
        return total;
    }

    private double getMaximum(ArrayList<MonthInOutSum> monthInOutSums) {
        double maximum = 0.0;
        for (MonthInOutSum currentItem : monthInOutSums) {
            if ((double)currentItem.getBudgetIN() > maximum) {
                maximum = currentItem.getBudgetIN();
            }
            if (!((double)Math.abs(currentItem.getBudgetOUT()) > maximum)) continue;
            maximum = Math.abs(currentItem.getBudgetOUT());
        }
        return maximum / 100.0;
    }

    @Override
    public WritableImage export(int width, int height) {
        VBox root = new VBox();
        root.setStyle("-fx-background-color: transparent;");
        root.setPadding(new Insets(25.0));
        HBox generatedChart = this.generate();
        root.getChildren().add((Object)generatedChart);
        VBox.setVgrow((Node)generatedChart, (Priority)Priority.ALWAYS);
        Region spacer = new Region();
        spacer.setMinHeight(30.0);
        root.getChildren().add((Object)spacer);
        root.getChildren().add((Object)this.generateLegend());
        Stage newStage = new Stage();
        newStage.initModality(Modality.NONE);
        newStage.setScene(new Scene((Parent)root, (double)width, (double)height));
        newStage.setResizable(false);
        newStage.show();
        SnapshotParameters sp = new SnapshotParameters();
        sp.setTransform((Transform)Transform.scale((double)((double)width / root.getWidth()), (double)((double)height / root.getHeight())));
        newStage.close();
        return root.snapshot(sp, null);
    }

    @Override
    public double getSuggestedWidth() {
        if (this.getChildren().size() < 2) {
            return 0.0;
        }
        Node currentNode = (Node)this.getChildren().get(0);
        if (!(currentNode instanceof ScrollPane)) {
            return 0.0;
        }
        ScrollPane scrollPane = (ScrollPane)currentNode;
        Node content = scrollPane.getContent();
        if (content == null) {
            return 0.0;
        }
        return ((Region)content).getWidth() + 50.0;
    }

    @Override
    public double getSuggestedHeight() {
        return this.getHeight() + 50.0;
    }
}

