/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmaster.logic.charts;

import de.deadlocker8.budgetmaster.logic.charts.ChartExportable;
import de.deadlocker8.budgetmaster.logic.charts.MonthInOutSum;
import de.deadlocker8.budgetmaster.logic.utils.Colors;
import de.deadlocker8.budgetmaster.logic.utils.Helpers;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SnapshotParameters;
import javafx.scene.chart.Axis;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javafx.scene.transform.Transform;
import javafx.stage.Modality;
import javafx.stage.Stage;
import tools.ConvertTo;
import tools.Localization;

public class MonthLineChart
extends VBox
implements ChartExportable {
    private ArrayList<MonthInOutSum> monthInOutSums;
    private String currency;

    public MonthLineChart(ArrayList<MonthInOutSum> monthInOutSums, String currency) {
        this.monthInOutSums = monthInOutSums;
        this.currency = currency;
        this.setSpacing(10.0);
        this.getChildren().add(this.generate(true));
    }

    private LineChart<String, Number> generate(boolean animated) {
        CategoryAxis xAxis = new CategoryAxis();
        NumberAxis yAxis = new NumberAxis();
        LineChart generatedChart = new LineChart((Axis)xAxis, (Axis)yAxis);
        generatedChart.setTitle(null);
        generatedChart.setAnimated(animated);
        xAxis.setLabel("");
        yAxis.setLabel(Localization.getString("chart.month.line.sum", this.currency));
        XYChart.Series seriesIN = new XYChart.Series();
        seriesIN.setName(Localization.getString("title.incomes"));
        XYChart.Series seriesOUT = new XYChart.Series();
        seriesOUT.setName(Localization.getString("title.payments"));
        for (MonthInOutSum currentItem : this.monthInOutSums) {
            String label = currentItem.getDate().toString("MMMM YY");
            seriesIN.getData().add((Object)new XYChart.Data((Object)label, (Object)((double)currentItem.getBudgetIN() / 100.0)));
            seriesOUT.getData().add((Object)new XYChart.Data((Object)label, (Object)((double)(-currentItem.getBudgetOUT()) / 100.0)));
        }
        generatedChart.getData().add((Object)seriesIN);
        generatedChart.getData().add((Object)seriesOUT);
        generatedChart.setLegendVisible(true);
        generatedChart.getData().stream().forEach(tool -> {
            for (XYChart.Data data : tool.getData()) {
                final Tooltip tooltip = new Tooltip();
                tooltip.setText(Helpers.getCurrencyString(((Number)data.getYValue()).doubleValue(), this.currency));
                Tooltip.install((Node)tool.getNode(), (Tooltip)tooltip);
                final Node node = data.getNode();
                node.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent event) {
                        Point2D p = node.localToScreen(event.getX() + 5.0, event.getY() + 7.0);
                        tooltip.show(node, p.getX(), p.getY());
                    }
                });
                node.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent event) {
                        tooltip.hide();
                    }
                });
            }
        });
        for (Node n : generatedChart.lookupAll(".default-color0.chart-series-line")) {
            n.setStyle("-fx-stroke: " + ConvertTo.toRGBHexWithoutOpacity(Colors.INCOME) + ";");
        }
        for (Node n : generatedChart.lookupAll(".default-color0.chart-line-symbol")) {
            n.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.INCOME) + ", white;");
        }
        for (Node n : generatedChart.lookupAll(".default-color1.chart-series-line")) {
            n.setStyle("-fx-stroke: " + ConvertTo.toRGBHexWithoutOpacity(Colors.PAYMENT) + ";");
        }
        for (Node n : generatedChart.lookupAll(".default-color1.chart-line-symbol")) {
            n.setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.PAYMENT) + ", white;");
        }
        Set nodes = generatedChart.lookupAll(".chart-legend-item");
        if (nodes.size() > 0) {
            Iterator iterator = nodes.iterator();
            int counter = 0;
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                if (node instanceof Label) {
                    Label labelLegendItem = (Label)node;
                    if (counter == 0) {
                        labelLegendItem.getGraphic().setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.INCOME) + ";");
                    } else {
                        labelLegendItem.getGraphic().setStyle("-fx-background-color: " + ConvertTo.toRGBHexWithoutOpacity(Colors.PAYMENT) + ";");
                    }
                }
                ++counter;
            }
        }
        return generatedChart;
    }

    @Override
    public WritableImage export(int width, int height) {
        VBox root = new VBox();
        root.setStyle("-fx-background-color: transparent;");
        root.setPadding(new Insets(25.0));
        root.getChildren().add(this.generate(false));
        Stage newStage = new Stage();
        newStage.initModality(Modality.NONE);
        newStage.setScene(new Scene((Parent)root, (double)width, (double)height));
        newStage.setResizable(false);
        newStage.show();
        SnapshotParameters sp = new SnapshotParameters();
        sp.setTransform((Transform)Transform.scale((double)((double)width / root.getWidth()), (double)((double)height / root.getHeight())));
        newStage.close();
        return root.snapshot(sp, null);
    }

    @Override
    public double getSuggestedWidth() {
        return this.getWidth() + 50.0;
    }

    @Override
    public double getSuggestedHeight() {
        return this.getHeight() + 50.0;
    }
}

