/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterserver.logic.database;

import de.deadlocker8.budgetmaster.logic.category.Category;
import de.deadlocker8.budgetmaster.logic.database.Database;
import de.deadlocker8.budgetmaster.logic.payment.NormalPayment;
import de.deadlocker8.budgetmaster.logic.payment.RepeatingPayment;
import de.deadlocker8.budgetmaster.logic.tag.Tag;
import de.deadlocker8.budgetmaster.logic.tag.TagMatch;
import de.deadlocker8.budgetmasterserver.logic.database.handler.DatabaseHandler;
import de.deadlocker8.budgetmasterserver.logic.database.taghandler.DatabaseTagHandler;
import java.util.ArrayList;
import java.util.Iterator;

public class DatabaseImporter {
    private DatabaseHandler handler;
    private DatabaseTagHandler tagHandler;
    private ArrayList<Category> categories;
    private ArrayList<NormalPayment> normalPayments;
    private ArrayList<RepeatingPayment> repeatingPayments;
    private ArrayList<NormalPayment> changedNormalPayments;
    private ArrayList<RepeatingPayment> changedRepeatingPayments;
    private ArrayList<Tag> tags;
    private ArrayList<TagMatch> tagMatches;
    private ArrayList<TagMatch> changedTagMatches;

    public DatabaseImporter(DatabaseHandler handler, DatabaseTagHandler tagHandler) throws IllegalStateException {
        this.handler = handler;
        this.tagHandler = tagHandler;
    }

    public void importDatabase(Database database) {
        this.categories = database.getCategories();
        this.normalPayments = database.getNormalPayments();
        this.repeatingPayments = database.getRepeatingPayments();
        this.changedNormalPayments = new ArrayList();
        this.changedRepeatingPayments = new ArrayList();
        this.tags = database.getTags();
        this.tagMatches = database.getTagMatches();
        this.changedTagMatches = new ArrayList();
        this.importAll();
    }

    private void importAll() {
        for (Category currentCategory : this.categories) {
            if (currentCategory.getID() == 1 || currentCategory.getID() == 2) continue;
            Category existingCategory = this.handler.getCategory(currentCategory.getName(), currentCategory.getColor());
            if (existingCategory == null) {
                this.handler.addCategory(currentCategory.getName(), currentCategory.getColor());
                int newID = this.handler.getLastInsertID();
                this.updatePayments(currentCategory.getID(), newID);
                continue;
            }
            this.updatePayments(currentCategory.getID(), existingCategory.getID());
        }
        this.normalPayments.addAll(this.changedNormalPayments);
        this.repeatingPayments.addAll(this.changedRepeatingPayments);
        this.importNormalPayments(this.normalPayments);
        this.tagMatches.addAll(this.changedTagMatches);
        this.changedTagMatches = new ArrayList();
        this.importRepeatingPayments(this.repeatingPayments);
        this.tagMatches.addAll(this.changedTagMatches);
        this.changedTagMatches = new ArrayList();
        for (Tag currentTag : this.tags) {
            int tagID = currentTag.getID();
            Tag existingTag = this.tagHandler.getTagByName(currentTag.getName());
            if (existingTag == null) {
                this.tagHandler.addTag(currentTag.getName());
                int newID = this.tagHandler.getLastInsertID();
                this.updateTagMatchesByTagID(tagID, newID);
                continue;
            }
            this.updateTagMatchesByTagID(tagID, existingTag.getID());
        }
        this.tagMatches.addAll(this.changedTagMatches);
        this.importTagMatches(this.tagMatches);
    }

    private void updatePayments(int oldID, int newID) {
        Iterator<NormalPayment> iterator = this.normalPayments.iterator();
        while (iterator.hasNext()) {
            NormalPayment currentPayment = iterator.next();
            if (currentPayment.getCategoryID() != oldID) continue;
            currentPayment.setCategoryID(newID);
            this.changedNormalPayments.add(currentPayment);
            iterator.remove();
        }
        Iterator<RepeatingPayment> iterator2 = this.repeatingPayments.iterator();
        while (iterator2.hasNext()) {
            RepeatingPayment currentPayment = iterator2.next();
            if (currentPayment.getCategoryID() != oldID) continue;
            currentPayment.setCategoryID(newID);
            this.changedRepeatingPayments.add(currentPayment);
            iterator2.remove();
        }
    }

    private void importNormalPayments(ArrayList<NormalPayment> normalPayments) {
        for (NormalPayment currentPayment : normalPayments) {
            int newID = this.handler.addNormalPayment(currentPayment.getAmount(), currentPayment.getDate(), currentPayment.getCategoryID(), currentPayment.getName(), currentPayment.getDescription());
            this.updateTagMatchesByPaymentID(currentPayment.getID(), newID);
        }
    }

    private void importRepeatingPayments(ArrayList<RepeatingPayment> repeatingPayments) {
        for (RepeatingPayment currentPayment : repeatingPayments) {
            int newID = this.handler.addRepeatingPayment(currentPayment.getAmount(), currentPayment.getDate(), currentPayment.getCategoryID(), currentPayment.getName(), currentPayment.getDescription(), currentPayment.getRepeatInterval(), currentPayment.getRepeatEndDate(), currentPayment.getRepeatMonthDay());
            this.updateTagMatchesByRepeatingPaymentID(currentPayment.getID(), newID);
        }
    }

    private void updateTagMatchesByTagID(int oldID, int newID) {
        Iterator<TagMatch> iterator = this.tagMatches.iterator();
        while (iterator.hasNext()) {
            TagMatch currentTagMatch = iterator.next();
            if (currentTagMatch.getTagID() != oldID) continue;
            currentTagMatch.setTagID(newID);
            this.changedTagMatches.add(currentTagMatch);
            iterator.remove();
        }
    }

    private void updateTagMatchesByPaymentID(int oldID, int newID) {
        Iterator<TagMatch> iterator = this.tagMatches.iterator();
        while (iterator.hasNext()) {
            TagMatch currentTagMatch = iterator.next();
            if (currentTagMatch.getPaymentID() != oldID) continue;
            currentTagMatch.setPaymentID(newID);
            this.changedTagMatches.add(currentTagMatch);
            iterator.remove();
        }
    }

    private void updateTagMatchesByRepeatingPaymentID(int oldID, int newID) {
        Iterator<TagMatch> iterator = this.tagMatches.iterator();
        while (iterator.hasNext()) {
            TagMatch currentTagMatch = iterator.next();
            if (currentTagMatch.getRepeatingPaymentID() != oldID) continue;
            currentTagMatch.setRepeatingPaymentID(newID);
            this.changedTagMatches.add(currentTagMatch);
            iterator.remove();
        }
    }

    private void importTagMatches(ArrayList<TagMatch> tagMatches) {
        for (TagMatch currentTagMatch : tagMatches) {
            if (currentTagMatch.getRepeatingPaymentID() == -1) {
                this.tagHandler.addTagMatchForPayment(currentTagMatch.getTagID(), currentTagMatch.getPaymentID());
                continue;
            }
            this.tagHandler.addTagMatchForRepeatingPayment(currentTagMatch.getTagID(), currentTagMatch.getRepeatingPaymentID());
        }
    }
}

