/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterserver.server.categorybudget;

import com.google.gson.Gson;
import de.deadlocker8.budgetmaster.logic.category.Category;
import de.deadlocker8.budgetmaster.logic.category.CategoryBudget;
import de.deadlocker8.budgetmaster.logic.payment.Payment;
import de.deadlocker8.budgetmasterserver.logic.AdvancedRoute;
import de.deadlocker8.budgetmasterserver.logic.database.handler.DatabaseHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import spark.Request;
import spark.Response;
import spark.Spark;

public class CategoryBudgetGet
implements AdvancedRoute {
    private DatabaseHandler handler;
    private Gson gson;

    public CategoryBudgetGet(DatabaseHandler handler, Gson gson) {
        this.handler = handler;
        this.gson = gson;
    }

    @Override
    public void before() {
        this.handler.connect();
    }

    @Override
    public Object handleRequest(Request req, Response res) {
        if (!req.queryParams().contains("year") || !req.queryParams().contains("month")) {
            Spark.halt(400, "Bad Request");
        }
        int year = 0;
        int month = 0;
        try {
            year = Integer.parseInt(req.queryMap("year").value());
            month = Integer.parseInt(req.queryMap("month").value());
            if (year < 0 || month < 1 || month > 12) {
                Spark.halt(400, "Bad Request");
            }
            try {
                ArrayList<Payment> payments = new ArrayList<Payment>();
                payments.addAll(this.handler.getPayments(year, month));
                payments.addAll(this.handler.getRepeatingPayments(year, month));
                ArrayList<CategoryBudget> budgets = new ArrayList<CategoryBudget>();
                for (Category currentCategory : this.handler.getCategories()) {
                    budgets.add(new CategoryBudget(currentCategory, 0.0));
                    CategoryBudget currentBudget = (CategoryBudget)budgets.get(budgets.size() - 1);
                    for (Payment currentPayment : payments) {
                        if (currentCategory.getID() != currentPayment.getCategoryID()) continue;
                        currentBudget.setBudget(currentBudget.getBudget() + (double)currentPayment.getAmount());
                    }
                }
                Iterator iterator = budgets.iterator();
                while (iterator.hasNext()) {
                    if (((CategoryBudget)iterator.next()).getBudget() != 0.0) continue;
                    iterator.remove();
                }
                Collections.sort(budgets, new Comparator<CategoryBudget>(){

                    @Override
                    public int compare(CategoryBudget budget1, CategoryBudget budget2) {
                        return Double.compare(budget1.getBudget(), budget2.getBudget());
                    }
                });
                return this.gson.toJson(budgets);
            }
            catch (IllegalStateException ex) {
                Spark.halt(500, "Internal Server Error");
            }
        }
        catch (Exception e) {
            Spark.halt(400, "Bad Request");
        }
        return null;
    }

    @Override
    public void after() {
        this.handler.closeConnection();
    }
}

