/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterserver.server.payment.normal;

import de.deadlocker8.budgetmasterserver.logic.AdvancedRoute;
import de.deadlocker8.budgetmasterserver.logic.database.handler.DatabaseHandler;
import de.deadlocker8.budgetmasterserver.logic.database.taghandler.DatabaseTagHandler;
import java.util.ArrayList;
import spark.Request;
import spark.Response;
import spark.Spark;

public class PaymentDelete
implements AdvancedRoute {
    private DatabaseHandler handler;
    private DatabaseTagHandler tagHandler;

    public PaymentDelete(DatabaseHandler handler, DatabaseTagHandler tagHandler) {
        this.handler = handler;
        this.tagHandler = tagHandler;
    }

    @Override
    public void before() {
        this.handler.connect();
    }

    @Override
    public Object handleRequest(Request req, Response res) {
        if (!req.queryParams().contains("id")) {
            Spark.halt(400, "Bad Request");
        }
        int id = -1;
        try {
            id = Integer.parseInt(req.queryMap("id").value());
            if (id < 0) {
                Spark.halt(400, "Bad Request");
            }
            try {
                this.handler.deletePayment(id);
                ArrayList<Integer> tagIDs = this.tagHandler.getAllTagsForPayment(id);
                for (Integer currentTagID : tagIDs) {
                    this.tagHandler.deleteTagMatchForPayment(currentTagID, id);
                }
                return "";
            }
            catch (IllegalStateException ex) {
                Spark.halt(500, "Internal Server Error");
            }
        }
        catch (Exception e) {
            Spark.halt(400, "Bad Request");
        }
        return "";
    }

    @Override
    public void after() {
        this.handler.closeConnection();
        this.tagHandler.closeConnection();
    }
}

