/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterserver.server.payment.normal;

import de.deadlocker8.budgetmasterserver.logic.AdvancedRoute;
import de.deadlocker8.budgetmasterserver.logic.database.handler.DatabaseHandler;
import spark.Request;
import spark.Response;
import spark.Spark;

public class PaymentUpdate
implements AdvancedRoute {
    private DatabaseHandler handler;

    public PaymentUpdate(DatabaseHandler handler) {
        this.handler = handler;
    }

    @Override
    public void before() {
        this.handler.connect();
    }

    @Override
    public Object handleRequest(Request req, Response res) {
        if (!(req.queryParams().contains("id") && req.queryParams().contains("amount") && req.queryParams().contains("date") && req.queryParams().contains("categoryID") && req.queryParams().contains("name") && req.queryParams().contains("description"))) {
            Spark.halt(400, "Bad Request");
        }
        int id = -1;
        int amount = 0;
        int categoryID = -1;
        try {
            id = Integer.parseInt(req.queryMap("id").value());
            amount = Integer.parseInt(req.queryMap("amount").value());
            categoryID = Integer.parseInt(req.queryMap("categoryID").value());
            if (id < 0) {
                Spark.halt(400, "Bad Request");
            }
            try {
                this.handler.updateNormalPayment(id, amount, req.queryMap("date").value(), categoryID, req.queryMap("name").value(), req.queryMap("description").value());
                return "";
            }
            catch (IllegalStateException ex) {
                Spark.halt(500, "Internal Server Error");
            }
        }
        catch (Exception e) {
            Spark.halt(400, "Bad Request");
        }
        return "";
    }

    @Override
    public void after() {
        this.handler.closeConnection();
    }
}

