/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterserver.server.payment.search;

import com.google.gson.Gson;
import de.deadlocker8.budgetmasterserver.logic.AdvancedRoute;
import de.deadlocker8.budgetmasterserver.logic.database.handler.DatabaseHandler;
import spark.Request;
import spark.Response;
import spark.Spark;

public class PaymentMaxAmount
implements AdvancedRoute {
    private DatabaseHandler handler;
    private Gson gson;

    public PaymentMaxAmount(DatabaseHandler handler, Gson gson) {
        this.handler = handler;
        this.gson = gson;
    }

    @Override
    public void before() {
        this.handler.connect();
    }

    @Override
    public Object handleRequest(Request req, Response res) {
        try {
            int maxNormal = this.handler.getNormalPaymentMaxAmount();
            int maxRepeating = this.handler.getRepeatingPaymentMaxAmount();
            int max = maxNormal;
            if (maxRepeating > max) {
                max = maxRepeating;
            }
            return this.gson.toJson((max + 1) / 100);
        }
        catch (IllegalStateException ex) {
            Spark.halt(500, "Internal Server Error");
            return null;
        }
    }

    @Override
    public void after() {
        this.handler.closeConnection();
    }
}

