/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterserver.server.tag.tag;

import com.google.gson.Gson;
import de.deadlocker8.budgetmaster.logic.tag.Tag;
import de.deadlocker8.budgetmasterserver.logic.AdvancedRoute;
import de.deadlocker8.budgetmasterserver.logic.database.taghandler.DatabaseTagHandler;
import spark.Request;
import spark.Response;
import spark.Spark;

public class TagGetByName
implements AdvancedRoute {
    private DatabaseTagHandler tagHandler;
    private Gson gson;

    public TagGetByName(DatabaseTagHandler tagHandler, Gson gson) {
        this.tagHandler = tagHandler;
        this.gson = gson;
    }

    @Override
    public void before() {
        this.tagHandler.connect();
    }

    @Override
    public Object handleRequest(Request req, Response res) {
        if (!req.queryParams().contains("name")) {
            Spark.halt(400, "Bad Request");
        }
        try {
            Tag tag = this.tagHandler.getTagByName(req.queryMap("name").value());
            return this.gson.toJson(tag);
        }
        catch (Exception e) {
            Spark.halt(500, "Internal Server Error");
            return null;
        }
    }

    @Override
    public void after() {
        this.tagHandler.closeConnection();
    }
}

