/*
 * Decompiled with CFR 0.152.
 */
package de.deadlocker8.budgetmasterserver.server.updater;

import de.deadlocker8.budgetmaster.logic.payment.LatestRepeatingPayment;
import de.deadlocker8.budgetmaster.logic.payment.RepeatingPayment;
import de.deadlocker8.budgetmasterserver.logic.database.handler.DatabaseHandler;
import java.util.ArrayList;
import logger.Logger;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Months;

public class RepeatingPaymentUpdater {
    private DatabaseHandler handler;

    public RepeatingPaymentUpdater(DatabaseHandler handler) {
        this.handler = handler;
    }

    public void updateRepeatingPayments(DateTime now) {
        try {
            ArrayList<RepeatingPayment> repeatingPayments = this.handler.getAllRepeatingPayments();
            ArrayList<LatestRepeatingPayment> latest = this.handler.getLatestRepeatingPaymentEntries();
            for (RepeatingPayment currentPayment : repeatingPayments) {
                DateTime endDate;
                DateTime date = now;
                int index = latest.indexOf(currentPayment);
                if (currentPayment.getRepeatEndDate() != null && (endDate = DateTime.parse(currentPayment.getRepeatEndDate())).isBefore(date)) {
                    date = endDate;
                }
                ArrayList<DateTime> correctDates = this.getCorrectRepeatingDates(currentPayment, date);
                if (index != -1) {
                    DateTime currentDate;
                    LatestRepeatingPayment currentLatest = latest.get(index);
                    DateTime latestDate = DateTime.parse(currentLatest.getLastDate());
                    for (int i = correctDates.size() - 1; i > 0 && !(currentDate = correctDates.get(i)).isBefore(latestDate) && !currentDate.isEqual(latestDate); --i) {
                        this.handler.addRepeatingPaymentEntry(currentLatest.getRepeatingPaymentID(), currentDate.toString("yyyy-MM-dd"));
                    }
                    continue;
                }
                for (DateTime currentDate : correctDates) {
                    this.handler.addRepeatingPaymentEntry(currentPayment.getID(), currentDate.toString("yyyy-MM-dd"));
                }
            }
        }
        catch (IllegalStateException ex) {
            Logger.error(ex);
        }
    }

    private ArrayList<DateTime> getCorrectRepeatingDates(RepeatingPayment payment, DateTime now) {
        ArrayList<DateTime> dates = new ArrayList<DateTime>();
        DateTime startDate = DateTime.parse(payment.getDate());
        if (payment.getRepeatInterval() != 0) {
            int numberOfDays = Days.daysBetween(startDate, now).getDays();
            int occurrences = numberOfDays / payment.getRepeatInterval();
            for (int i = 0; i <= occurrences; ++i) {
                dates.add(startDate.plusDays(i * payment.getRepeatInterval()));
            }
        } else {
            int numberOfMonths = Months.monthsBetween(startDate.withDayOfMonth(payment.getRepeatMonthDay()), now).getMonths();
            for (int i = 0; i <= numberOfMonths; ++i) {
                dates.add(startDate.plusMonths(i));
            }
        }
        return dates;
    }
}

